<?php
class DeveloperToolController extends Controller
{
    public function removeDuplicateLabelAction( )
    {
        if ( DEVELOPER_MODE != TRUE ) {
            exit;
        }
        $file_array = array( );
        $XML        = $this->getRequestValue( 2 );
        $path       = $this->getPath( $XML );
        if ( !file_exists( $path ) ) {
            echo 'File not Found';
            exit;
        }
        $file = fopen( $path, 'rt' );
        if ( $file ) {
            while ( !feof( $file ) ) {
                $val = fgets( $file );
                if ( is_string( $val ) && trim( $val ) != '' )
                    array_push( $file_array, trim( str_replace( '&', '&amp;', $val ) ) );
            }
            fclose( $file );
        }
        $new_array  = array_unique( $file_array );
        $filename   = __CORE_PUBLIC_PATH . '/developer/en.xml';
        $file_write = fopen( $filename, 'wt' );
        if ( $file_write ) {
            fwrite( $file_write, implode( "", $new_array ) );
            fclose( $file_write );
        }
        $xml            = simplexml_load_file( $filename );
        $arr            = array( );
        $temp           = array( );
        $duplicate      = array( );
        $duplicate_find = false;
        foreach ( $xml as $key => $id ) {
            $elm = (array) $id;
            if ( in_array( $key, $temp ) ) {
                $duplicate_find = true;
                $duplicate[ ]   = $key;
            } else {
                $temp[ ] = $key;
            }
        }
        if ( $duplicate_find ) {
            echo '<pre>' . ( count( $file_array ) - count( $new_array ) ) . " Duplicate Lines Found<br/>";
            echo '<pre>The Following labels are repeating but the <b><i>Default value</i></b> is different,Please manually remove the unnecessary keys:<br/>';
            print_r( $duplicate );
        } else {
            echo '<pre>' . ( count( $file_array ) - count( $new_array ) ) . " Duplicate Lines Found<br/>";
        }
        if ( ( count( $file_array ) - count( $new_array ) ) > 0 ) {
            echo '<a href="../../output/aim/languageXML/">View the output XML</a><br/>';
            echo '<a href="../../download/aim/languageXML/">Download the output XML</a><br/>';
            echo '<a href="../../save/aim/languageXML/path/' . $XML . '/">Save the file in server(Replace the old file).</a>';
        }
        exit;
    }
    public function outputAction( )
    {
        $aim = $this->getRequestValue( 'aim' );
        if ( $aim == 'languageXML' ) {
            if ( !file_exists( __CORE_PUBLIC_PATH . '/developer/en.xml' ) )
                $this->setRedirect( 'DeveloperTool/removeDuplicateLabel/' );
            header( "Content-type: text/xml;" );
            readfile( __CORE_PUBLIC_PATH . '/developer/en.xml' );
            unlink( __CORE_PUBLIC_PATH . '/developer/en.xml' );
        }
    }
    public function downloadAction( )
    {
        $aim = $this->getRequestValue( 'aim' );
        if ( $aim == 'languageXML' ) {
            if ( !file_exists( __CORE_PUBLIC_PATH . '/developer/en.xml' ) )
                $this->setRedirect( 'DeveloperTool/removeDuplicateLabel/' );
            header( 'Content-disposition: attachment; filename="en.xml"' );
            header( 'Content-type: "text/xml"; charset="utf8"' );
            $doc               = new DOMDocument();
            $doc->formatOutput = true;
            $doc->load( __CORE_PUBLIC_PATH . '/developer/en.xml' );
            $doc->save( __CORE_PUBLIC_PATH . '/developer/en.xml' );
            readfile( __CORE_PUBLIC_PATH . '/developer/en.xml' );
            unlink( __CORE_PUBLIC_PATH . '/developer/en.xml' );
        }
    }
    public function saveAction( )
    {
        $pathName = $this->getRequestValue( 'path' );
        $aim      = $this->getRequestValue( 'aim' );
        $path     = $this->getPath( $pathName );
        if ( $aim == 'languageXML' ) {
            if ( !file_exists( __CORE_PUBLIC_PATH . '/developer/en.xml' ) )
                $this->setRedirect( 'DeveloperTool/removeDuplicateLabel/' );
            $doc               = new DOMDocument();
            $doc->formatOutput = true;
            try {
                $doc->load( __CORE_PUBLIC_PATH . '/developer/en.xml' );
                $doc->save( $path );
                echo '<h2>Success!!</h2> .<br/><a href="../../../../../removeDuplicateLabel/">Back</a>';
            }
            catch ( Exception $e ) {
                echo 'Caught exception: ', $e->getMessage(), "\n";
            }
            unlink( __CORE_PUBLIC_PATH . '/developer/en.xml' );
        }
    }
    private function getPath( $pathName )
    {
        switch ( $pathName ) {
            case 'manage':
                $path = __CORE_PUBLIC_MANAGE_PATH . "/languages/en.xml";
                break;
            case 'front':
                $path = __CORE_PUBLIC_FRONTEND_PATH . "/languages/en.xml";
                break;
            case 'business':
                $path = __CORE_PUBLIC_BUSINESS_PATH . "/languages/en.xml";
                break;
            case 'affiliate':
                $path = __CORE_PUBLIC_AFFILIATE_PATH . "/languages/en.xml";
                break;
            case 'salesrep':
                $path = __CORE_PUBLIC_SALESREP_PATH . "/languages/en.xml";
                break;
            case '':
                echo "	<ul>
							<li><a href='manage'>manage/DeveloperTool/removeDuplicateLabel/manage/</a></li>
							<li><a href='front'>manage/DeveloperTool/removeDuplicateLabel/front/</a></li>
							<li><a href='business'>manage/DeveloperTool/removeDuplicateLabel/business/</a></li>
							<li><a href='affiliate'>manage/DeveloperTool/removeDuplicateLabel/affiliate/</a></li>
							<li><a href='salesrep'>manage/DeveloperTool/removeDuplicateLabel/salesrep/</a></li>
							</ul>	";
                exit;
        }
        return $path;
    }
}