<?php
/***************************************************************************
 *                                                                          *
 * Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
 *                                                                          *
 * This  is  commercial  software,  only  users  who have purchased a valid *
 * license  and  accept  to the terms of the  License Agreement can install *
 * and use this program.                                                    *
 *                                                                          *
 ****************************************************************************
 * PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
 * "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
 ****************************************************************************/
//
//$Id: LicenseController, v 1.0 2014/05/07 16:18:26
//
class LicenseController extends Controller 
{
	public function indexAction()    
	{
		$ObjLicense    	= new LicenseModel();
		$languageIDs	= $this->ObjView->languageIDs;	
		$ObjPackage		= new PackageModel();
		$resPackage		= $ObjPackage->listPackageOptions();
		foreach($resPackage as $key=>$value) {
			$resPackage[$key][0] = $this->encryptDecrypt("decrypt",$value['packageKey']);
			$resPackage[$key][1] = $this->encryptDecrypt("decrypt",$value['packageName']);
		}
		$this->ObjView->assign('resPackage', $resPackage);		
		$ObjAdmin	 	= new AdminuserModel();
		$resBranches	= $ObjAdmin->listBranchCodes();
		$this->ObjView->assign('resBranches', $resBranches);
		$adminId		= $this->ObjCommon->manageUserID; 
		$branchCodeSes	= $this->ObjCommon->manageBranchCode;
		$transID		=	$this->ObjCommon->transSession; 
		$settingsDateFormat = $this->getSettingValue("site_settings", "date_format");
		$settingsTimeFormat = $this->getSettingValue("site_settings", "time_format");	
		$ObjAdminlog	= 	new AdminlogModel();
		if ((isset($_POST['select_status'])) && ($_POST['select_status']!=""))
		{
			if(($transID=="") || ($transID!=$adminId))
			{
				$this->setRedirect("adminuser/transPwd/urlback/ajax/ctrlpath/license/");
			}
			else
			{
				$domainNames		= array();
				$licenceIDs			= array();
				foreach($_POST['licenceID'] as $key=>$licenseValues)
				{
					$domainNames[]	= $key;
					$licenceIDs[]	= $licenseValues[0];
				}
				$ObjLicense			=	new LicenseModel();
				$params=array(
					'status'=>$_POST['select_status'],
					'licenceIDs'=>$licenceIDs
				);
				$licIDStr		= implode(",",$licenceIDs);
				$licNameStr		= implode(",",$domainNames);
				if(($_POST['select_status']=="Inactive") || ($_POST['select_status']=="Deleted"))
				{
					$licenseUsed	= $ObjLicense->checkLicenseParent($licenseIDs);
					if(count($licenseUsed)>0)
					{
						$this->setMessage('language.lblLicenseNotUpdate','message_info');
						/* Adminlog */
						$adminAccessIP		= $this->ObjCommon->getClientIP();
						$i									= 0;
						$adminActionData					= array();
						$adminActionData[$i]['status']		= "Status Updation Failed";
						$adminActionData[$i]['response']	= "License Have Active Sub Domains, So Cannot Change its Status";
						$adminActionData[$i]['message']		= "No Changes Found For Licensed Domains: <b>".$licNameStr."</b>";
						$i++;
						$adminActionDataStr					= serialize($adminActionData);
						$params =array(
						'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'License', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
						);
						$ObjAdminlog->insertAdminlog($params);
						/* End Adminlog */
					}
					else
					{
						$ObjLicense->changeStatus($params);
						$this->setMessage('language.lblLicensestatusUpdatedSuccess','success');
						/* Adminlog */
						$adminAccessIP						= $this->ObjCommon->getClientIP();
						$i									= 0;
						$adminActionData					= array();
						$adminActionData[$i]['status']		= "Updated The Status";
						$adminActionData[$i]['response']	= "Domains Bulk Status Updated Successfully";
						$adminActionData[$i]['message']		= "Updated Status of Licensed Domains<br/>";
						$adminActionData[$i]['message']		.= "<div class='grid_table00'>
						<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>LicenceID</td><td width='50%' height='15%' align='left'>Domain Name</td><td width='30%' height='15%' align='left'>Domain Status</td></tr>";
						for($s=0;$s<count($licenceIDs);$s++)
						{
							$adminActionData[$i]['message']		.= "<tr><td align='left'><b>".$licenceIDs[$s]."</b></td><td align='left'><b>".$domainNames[$s]."</b></td><td align='left'><b>".$_POST['select_status']."</b></td></tr>";
						}
						$adminActionData[$i]['message']		.= "</table></div><br/>";
						$i++;
						
						$adminActionDataStr					= serialize($adminActionData);

						$params =array(
						'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'License', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
						);
						$ObjAdminlog->insertAdminlog($params);
						/* End Adminlog */
					}
				}
				else
				{
					$ObjLicense->changeStatus($params);
					$this->setMessage('language.lblLicensestatusUpdatedSuccess','success');
					/* Adminlog */
					$adminAccessIP						= $this->ObjCommon->getClientIP();
					$i									= 0;
					$adminActionData					= array();
					$adminActionData[$i]['status']		= "Updated The Status";
					$adminActionData[$i]['response']	= "Domains Bulk Status Updated Successfully";
					$adminActionData[$i]['message']		= "Updated Status of Licensed Domains<br/>";
					$adminActionData[$i]['message']		.= "<div class='grid_table00'>
					<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>LicenceID</td><td width='50%' height='15%' align='left'>Domain Name</td><td width='30%' height='15%' align='left'>Domain Status</td></tr>";
					for($s=0;$s<count($licenceIDs);$s++)
					{
						$adminActionData[$i]['message']		.= "<tr><td align='left'><b>".$licenceIDs[$s]."</b></td><td align='left'><b>".$domainNames[$s]."</b></td><td align='left'><b>".$_POST['select_status']."</b></td></tr>";
					}
					$adminActionData[$i]['message']		.= "</table></div><br/>";
					$i++;
					
					$adminActionDataStr					= serialize($adminActionData);

					$params =array(
					'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'License', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
					);
					$ObjAdminlog->insertAdminlog($params);
					/* End Adminlog */
				}
				$this->setRedirect();
			}
		}		
		$link	=	'license/index/';
		if (isset($_POST['search']))
		{		
			if ($_POST['customerID'] != ""){
				//$link .= "customerID/" . $this->encodeUrlString($_POST['customerID']) . "/";
				$link .= "customerID/" . ($_POST['customerID']) . "/";
			}			
			if ($_POST['domainName'] != ""){
				//$link .= "domainName/" . $this->encodeUrlString($_POST['domainName']) . "/";
				$link .= "domainName/" . ($_POST['domainName']) . "/";
			}			
			if ($_POST['licenceKey'] != ""){
				$link .= "licenceKey/" . $_POST['licenceKey'] . "/";
			}			
			if ($_POST['packageKey'] != ""){
				$link .= "packageKey/" . $this->encodeUrlString($_POST['packageKey']) . "/";
			}			
			if ($_POST['packageVersion'] != ""){
				$link .= "packageVersion/" . $_POST['packageVersion'] . "/";
			}					
			if ($_POST['packageName'] != ""){
				$link .= "packageName/" . $this->encodeUrlString($_POST['packageName']) . "/";
			}				
			if ($_POST['domainstatus1'] != ""){
				$link .= "domainstatus1/" . $this->encodeUrlString($_POST['domainstatus1']) . "/";
			}
			if ($_POST['multipleDom'] != ""){
				$link .= "multipleDom/" . $this->encodeUrlString($_POST['multipleDom']) . "/";
			}				
			if ($_POST['branchCode'] != ""){
				$link .= "branchCode/" . $_POST['branchCode'] . "/";
			}
			if ($_POST['createDate'] != ""){
				list($fromDate, $toDate) = split(' - ', $_POST['createDate']);
				$link .= (($fromDate != "") ? "from/" . $this->urlDate($fromDate, 'set', $settingsDateFormat) . "/" :"");
				$link .= (($toDate != "") ? "to/" . $this->urlDate($toDate, 'set', $settingsDateFormat) . "/" :"");
			}	
			$this->setRedirect($link);
		}
		else
		{
			$sortby		=	$this->getRequestValue("sortby");
			$orderby	=	($this->getRequestValue("orderby")=="")?"asc":$this->getRequestValue("orderby");
					
			if($this->getRequestValue('customerID')){
				$customerID		= 	$this->decodeUrlString($this->getRequestValue('customerID'));
				$link.="customerID/".$customerID. "/";
			}			
			if($this->getRequestValue('domainName')){
				$domainName		= 	$this->decodeUrlString($this->getRequestValue('domainName'));
				$link.="domainName/".$domainName. "/";
			}			
			if($this->getRequestValue('licenceKey')){
				$licenceKey		= 	$this->getRequestValue('licenceKey');
				$link.="licenceKey/".$licenceKey. "/";
			}			
			if($this->getRequestValue('packageKey')){
				$packageKey		= 	$this->decodeUrlString($this->getRequestValue('packageKey'));
				$link.="packageKey/".$packageKey. "/";
			}			
			if($this->getRequestValue('packageVersion')){
				$packageVersion		= 	$this->getRequestValue('packageVersion');
				$link.="packageVersion/".$packageVersion. "/";
			}						
			if($this->getRequestValue('packageName')){
				$packageName		= 	$this->decodeUrlString($this->getRequestValue('packageName'));
				$link.="packageName/".$packageName. "/";
			}						
			if($this->getRequestValue('domainstatus1')){
				$domainstatus1		= 	$this->decodeUrlString($this->getRequestValue('domainstatus1'));
				$link.="domainstatus1/".$domainstatus1. "/";
			}			
			if($this->getRequestValue('multipleDom')){
				$multipleDom		= 	$this->decodeUrlString($this->getRequestValue('multipleDom'));
				$link.="multipleDom/".$multipleDom. "/";
			}	
			if($this->getRequestValue('branchCode')){
				$branchCode		= 	$this->getRequestValue('branchCode');
				$link.="branchCode/".$branchCode. "/";
			}	
			if($this->getRequestValue('from')){
				$fromDate 		= $this->urlDate($this->getRequestValue('from'), 'get', $settingsDateFormat);
				$link .= (($fromDate != "") ? "from/" . $this->urlDate($fromDate, 'set', $settingsDateFormat) . "/" :"");
			}
			if($this->getRequestValue('to')){
				$toDate 		= $this->urlDate($this->getRequestValue('to'), 'get', $settingsDateFormat);
				$link .= (($toDate != "") ? "to/" . $this->urlDate($toDate, 'set', $settingsDateFormat) . "/" :	"");
			}
		}
		list($limitFrom, $limitTo) = $this->getPageSettings($key = 'page', $rows = 10); 
		
		/*assigning from and to values for search*/
		$assignFromDate =  $fromDate; 
        $assignToDate = $toDate;
        if (!$toDate && $fromDate){
           	 $toDate   = $fromDate; 
       	}
		$fromDate	= $this->convertDateForSQL($fromDate, $settingsDateFormat);
		$toDate		= $this->convertDateForSQL($toDate, $settingsDateFormat);
        /*assigning from and to values for search*/
		
		$params =array(
			'limitFrom'=>$limitFrom,
			'limitTo'=>$limitTo,
			'languageIDs'=>$languageIDs,
			'sortby'=>$sortby,
			'orderby'=>$orderby,
			'customerID'=>$customerID ,'domainName'=>$domainName ,'licenceKey'=>$licenceKey ,'packageKey'=>$packageKey ,'packageVersion'=>$packageVersion ,'packageName'=>$packageName ,'fromDate'=>$fromDate , 'toDate'=>$toDate ,'domainstatus1'=>$domainstatus1 ,'multipleDom'=>$multipleDom ,'branchCode'=>$branchCode, 'adminId'=>$adminId, 'branchCodeSes'=>$branchCodeSes 
		);
		$listParentSearch	= array();
		$listSubSearch		= array();
		$j					= 0;
		if ($link == 'license/index/')
		{	
			list($listParent, $listSub)    = $ObjLicense->listLicense($params);
		}
		else 
		{ 
			list($listParent, $listSub)    = $ObjLicense->listLicense($params);
			if(!empty($listParent))
			{
				for($k=0;$k<count($listParent);$k++)
				{
					$listParentSearch[$k]	= $listParent[$k]['licenceID'];
				}
				for($i=0;$i<count($listSub);$i++)
				{				
					if(!in_array($listSub[$i]['parentDomain'], $listParentSearch))
					{
						$listSubSearch[$j]	= $listSub[$i];
						$j++;
					}

				}
			}
		}
		$resPagesCount = $this->setPagesCount($key = 'page');
		$this->ObjView->assign("page", $page);	
		$this->ObjView->assign("sortby", $sortby); $this->ObjView->assign("orderby", ($orderby=="asc")?'desc':'asc'); $this->ObjView->assign("customerID", $customerID); $this->ObjView->assign("domainName", $domainName); $this->ObjView->assign("licenceKey", $licenceKey); $this->ObjView->assign("packageKey", $packageKey); $this->ObjView->assign("packageVersion", $packageVersion); $this->ObjView->assign("domainstatus1", $domainstatus1); $this->ObjView->assign("branchCode", $branchCode); $this->ObjView->assign("multipleDom", $multipleDom);
		if($assignFromDate && $assignToDate==''){
			$this->ObjView->assign('createDate', $assignFromDate);
		}else if($assignFromDate && $assignToDate){
			$this->ObjView->assign('createDate', $assignFromDate.' - '.$assignToDate);
		}else{
			$this->ObjView->assign('createDate','');
		}
		$this->ObjView->assign('listParent', $listParent);
		$this->ObjView->assign('listSub', $listSub);
		$this->ObjView->assign('listSubSearch', $listSubSearch);
		$editPrivilege	=	$this->ObjCommon->hasPrivilege('license/edit/');
		$this->ObjView->assign("editPrivilege", $editPrivilege);
		$deletePrivilege	=	$this->ObjCommon->hasPrivilege('license/destroy/');
		$this->ObjView->assign("deletePrivilege", $deletePrivilege);
		
		$this->ObjView->assign("link", $link);
		
		$this->ObjView->display('LicenseList.tpl');
	}
	
	/* List License Recently Installed */
	public function installAction()    
	{
		$ObjLicense    	= new LicenseModel();
		$languageIDs	= $this->ObjView->languageIDs;	
		$ObjPackage		= new PackageModel();
		$resPackage		= $ObjPackage->listPackageOptions();
		foreach($resPackage as $key=>$value) {
			$resPackage[$key][0] = $this->encryptDecrypt("decrypt",$value['packageKey']);
			$resPackage[$key][1] = $this->encryptDecrypt("decrypt",$value['packageName']);
		}
		$this->ObjView->assign('resPackage', $resPackage);	
		$ObjAdmin	 	= new AdminuserModel();
		$resBranches	= $ObjAdmin->listBranchCodes();
		$this->ObjView->assign('resBranches', $resBranches);
		$settingsDateFormat = $this->getSettingValue("site_settings", "date_format");
		$settingsTimeFormat = $this->getSettingValue("site_settings", "time_format");
		$adminId		= $this->ObjCommon->manageUserID; 
		$branchCodeSes	= $this->ObjCommon->manageBranchCode;
		$transID		= $this->ObjCommon->transSession;
		$ObjAdminlog	= new AdminlogModel();
		$editPrivilege		=	$this->ObjCommon->hasPrivilege('license/edit/');
		$deletePrivilege	=	$this->ObjCommon->hasPrivilege('license/destroy/');
		$installPrivilege	=	$this->ObjCommon->hasPrivilege('license/install/');
		if(!($installPrivilege))
		{
			 $this->setRedirect('license/index/');
		}
		if ((isset($_POST['select_status'])) && ($_POST['select_status']!=""))
		{
			if(($transID=="") || ($transID!=$adminId))
			{
				$this->setRedirect("adminuser/transPwd/urlback/ajax/ctrlpath/license/");
			}
			else
			{
				$domainNames		= array();
				$licenceIDs			= array();
				foreach($_POST['licenceID'] as $key=>$licenseValues)
				{
					$domainNames[]	= $key;
					$licenceIDs[]	= $licenseValues[0];
				}
				$ObjLicense			=	new LicenseModel();
				$params=array(
					'status'=>$_POST['select_status'],
					'licenceIDs'=>$licenceIDs
				);
				$licIDStr		= implode(",",$licenceIDs);
				$licNameStr		= implode(",",$domainNames);
				if(($_POST['select_status']=="Inactive") || ($_POST['select_status']=="Deleted"))
				{
					$licenseUsed	= $ObjLicense->checkLicenseParent($licenseIDs);
					if(count($licenseUsed)>0)
					{
						$this->setMessage('language.lblLicenseNotUpdate','message_info');
						/* Adminlog */
						$adminAccessIP		= $this->ObjCommon->getClientIP();
						$i									= 0;
						$adminActionData					= array();
						$adminActionData[$i]['status']		= "Status Updation Failed";
						$adminActionData[$i]['response']	= "License Have Active Sub Domains, So Cannot Change its Status";
						$adminActionData[$i]['message']		= "No Changes Found For Licensed Domains: <b>".$licNameStr."</b>";
						$i++;
						$adminActionDataStr					= serialize($adminActionData);
						$params =array(
						'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'License Install', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
						);
						$ObjAdminlog->insertAdminlog($params);
						/* End Adminlog */
					}
					else
					{
						$ObjLicense->changeStatus($params);
						$this->setMessage('language.lblLicensestatusUpdatedSuccess','success');
						/* Adminlog */
						$adminAccessIP						= $this->ObjCommon->getClientIP();
						$i									= 0;
						$adminActionData					= array();
						$adminActionData[$i]['status']		= "Updated The Status";
						$adminActionData[$i]['response']	= "Domains Bulk Status Updated Successfully";
						$adminActionData[$i]['message']		= "Updated Status of Licensed Domains<br/>";
						$adminActionData[$i]['message']		.= "<div class='grid_table00'>
						<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>LicenceID</td><td width='50%' height='15%' align='left'>Domain Name</td><td width='30%' height='15%' align='left'>Domain Status</td></tr>";
						for($s=0;$s<count($licenceIDs);$s++)
						{
							$adminActionData[$i]['message']		.= "<tr><td align='left'><b>".$licenceIDs[$s]."</b></td><td align='left'><b>".$domainNames[$s]."</b></td><td align='left'><b>".$_POST['select_status']."</b></td></tr>";
						}
						$adminActionData[$i]['message']		.= "</table></div><br/>";
						$i++;
						
						$adminActionDataStr					= serialize($adminActionData);

						$params =array(
						'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'License Install', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
						);
						$ObjAdminlog->insertAdminlog($params);
						/* End Adminlog */
					}
				}
				else
				{
					$ObjLicense->changeStatus($params);
					$this->setMessage('language.lblLicensestatusUpdatedSuccess','success');
					/* Adminlog */
					$adminAccessIP						= $this->ObjCommon->getClientIP();
					$i									= 0;
					$adminActionData					= array();
					$adminActionData[$i]['status']		= "Updated The Status";
					$adminActionData[$i]['response']	= "Domains Bulk Status Updated Successfully";
					$adminActionData[$i]['message']		= "Updated Status of Licensed Domains<br/>";
					$adminActionData[$i]['message']		.= "<div class='grid_table00'>
					<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>LicenceID</td><td width='50%' height='15%' align='left'>Domain Name</td><td width='30%' height='15%' align='left'>Domain Status</td></tr>";
					for($s=0;$s<count($licenceIDs);$s++)
					{
						$adminActionData[$i]['message']		.= "<tr><td align='left'><b>".$licenceIDs[$s]."</b></td><td align='left'><b>".$domainNames[$s]."</b></td><td align='left'><b>".$_POST['select_status']."</b></td></tr>";
					}
					$adminActionData[$i]['message']		.= "</table></div><br/>";
					$i++;
					
					$adminActionDataStr					= serialize($adminActionData);

					$params =array(
					'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'License Install', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
					);
					$ObjAdminlog->insertAdminlog($params);
					/* End Adminlog */
				}
				$this->setRedirect();
			}
		}	
		if(isset($_POST['cleanTracked']))
		{
			$status	= "Install";
			$ObjLicense->cleanTrackedAccess($status);
			$this->setMessage('language.lblLicenseAccessDeletedSuccess','success');
			/* Adminlog */
			$adminAccessIP		= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "Cleaned Access Track";
			$adminActionData[$i]['response']	= "License Tracked Access Deleted Successfully";
			$adminActionData[$i]['message']		= "Cleaned The Tracked Access Details In Recently Installed";
			$i++;
			$adminActionDataStr					= serialize($adminActionData);
			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'CleanTracked', 'adminActionObject'=>'License Install', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
		}
		$link	=	'license/install/';
		if (isset($_POST['search']))
		{		
			if ($_POST['customerID'] != ""){
				//$link .= "customerID/" . $this->encodeUrlString($_POST['customerID']) . "/";
				$link .= "customerID/" . ($_POST['customerID']) . "/";
			}			
			if ($_POST['domainName'] != ""){
				//$link .= "domainName/" . $this->encodeUrlString($_POST['domainName']) . "/";
				$link .= "domainName/" . ($_POST['domainName']) . "/";
			}			
			if ($_POST['licenceKey'] != ""){
				$link .= "licenceKey/" . $_POST['licenceKey'] . "/";
			}			
			if ($_POST['packageKey'] != ""){
				$link .= "packageKey/" . $this->encodeUrlString($_POST['packageKey']) . "/";
			}			
			if ($_POST['packageVersion'] != ""){
				$link .= "packageVersion/" . $_POST['packageVersion'] . "/";
			}					
			if ($_POST['packageName'] != ""){
				$link .= "packageName/" . $this->encodeUrlString($_POST['packageName']) . "/";
			}					
			if ($_POST['domainstatus1'] != ""){
				$link .= "domainstatus1/" . $this->encodeUrlString($_POST['domainstatus1']) . "/";
			}			
			if ($_POST['branchCode'] != ""){
				$link .= "branchCode/" . $_POST['branchCode'] . "/";
			}
			if ($_POST['createDate'] != ""){
				list($fromDate, $toDate) = split(' - ', $_POST['createDate']);
				$link .= (($fromDate != "") ? "from/" . $this->urlDate($fromDate, 'set', $settingsDateFormat) . "/" :"");
				$link .= (($toDate != "") ? "to/" . $this->urlDate($toDate, 'set', $settingsDateFormat) . "/" :"");
			}	
			if ($_POST['accessCount'] != ""){
				$link .= "accessCount/" . $_POST['accessCount'] . "/";
			}	
			if ($_POST['accessTime'] != ""){
				list($fromDate1, $toDate1) = split(' - ', $_POST['accessTime']);
				$link .= (($fromDate1 != "") ? "from1/" . $this->urlDate($fromDate1, 'set', $settingsDateFormat) . "/" :"");
				$link .= (($toDate1 != "") ? "to1/" . $this->urlDate($toDate1, 'set', $settingsDateFormat) . "/" :"");
			}	
			$this->setRedirect($link);
		}
		else
		{
			$sortby		=	$this->getRequestValue("sortby");
			$orderby	=	($this->getRequestValue("orderby")=="")?"asc":$this->getRequestValue("orderby");
					
			if($this->getRequestValue('customerID')){
				$customerID		= 	$this->decodeUrlString($this->getRequestValue('customerID'));
				$link.="customerID/".$customerID. "/";
			}			
			if($this->getRequestValue('domainName')){
				$domainName		= 	$this->decodeUrlString($this->getRequestValue('domainName'));
				$link.="domainName/".$domainName. "/";
			}			
			if($this->getRequestValue('licenceKey')){
				$licenceKey		= 	$this->getRequestValue('licenceKey');
				$link.="licenceKey/".$licenceKey. "/";
			}			
			if($this->getRequestValue('packageKey')){
				$packageKey		= 	$this->decodeUrlString($this->getRequestValue('packageKey'));
				$link.="packageKey/".$packageKey. "/";
			}			
			if($this->getRequestValue('packageVersion')){
				$packageVersion		= 	$this->getRequestValue('packageVersion');
				$link.="packageVersion/".$packageVersion. "/";
			}						
			if($this->getRequestValue('packageName')){
				$packageName		= 	$this->decodeUrlString($this->getRequestValue('packageName'));
				$link.="packageName/".$packageName. "/";
			}					
			if($this->getRequestValue('domainstatus1')){
				$domainstatus1		= 	$this->decodeUrlString($this->getRequestValue('domainstatus1'));
				$link.="domainstatus1/".$domainstatus1. "/";
			}			
			if($this->getRequestValue('branchCode')){
				$branchCode		= 	$this->getRequestValue('branchCode');
				$link.="branchCode/".$branchCode. "/";
			}	
			if($this->getRequestValue('from')){
				$fromDate 		= $this->urlDate($this->getRequestValue('from'), 'get', $settingsDateFormat);
				$link .= (($fromDate != "") ? "from/" . $this->urlDate($fromDate, 'set', $settingsDateFormat) . "/" :"");
			}
			if($this->getRequestValue('to')){
				$toDate 		= $this->urlDate($this->getRequestValue('to'), 'get', $settingsDateFormat);
				$link .= (($toDate != "") ? "to/" . $this->urlDate($toDate, 'set', $settingsDateFormat) . "/" :	"");
			}
			if($this->getRequestValue('accessCount')){
				$accessCount		= 	$this->getRequestValue('accessCount');
				$link.="accessCount/".$accessCount. "/";
			}	
			if($this->getRequestValue('from1')){
				$fromDate1 		= $this->urlDate($this->getRequestValue('from1'), 'get', $settingsDateFormat);
				$link .= (($fromDate1 != "") ? "from1/" . $this->urlDate($fromDate1, 'set', $settingsDateFormat) . "/" :"");
			}
			if($this->getRequestValue('to1')){
				$toDate1 		= $this->urlDate($this->getRequestValue('to1'), 'get', $settingsDateFormat);
				$link .= (($toDate1 != "") ? "to1/" . $this->urlDate($toDate1, 'set', $settingsDateFormat) . "/" :	"");
			}
		}
		list($limitFrom, $limitTo) = $this->getPageSettings($key = 'page', $rows = 10); 
		
		/*assigning from and to values for search*/
		$assignFromDate =  $fromDate; 
        $assignToDate = $toDate;
        if (!$toDate && $fromDate){
           	 $toDate   = $fromDate; 
       	}
		$fromDate	= $this->convertDateForSQL($fromDate, $settingsDateFormat);
		$toDate		= $this->convertDateForSQL($toDate, $settingsDateFormat);
        /*assigning from and to values for search*/
		
		/*assigning from1 and to1 values for search*/
		$assignFromDate1 =  $fromDate1; 
        $assignToDate1 = $toDate1;
        if (!$toDate1 && $fromDate1){
           	 $toDate1   = $fromDate1; 
       	}
		$fromDate1	= $this->convertDateForSQL($fromDate1, $settingsDateFormat);
		$toDate1	= $this->convertDateForSQL($toDate1, $settingsDateFormat);
        /*assigning from1 and to1 values for search*/
		
		$params =array(
			'limitFrom'=>$limitFrom,
			'limitTo'=>$limitTo,
			'languageIDs'=>$languageIDs,
			'sortby'=>$sortby,
			'orderby'=>$orderby,
			'customerID'=>$customerID ,'domainName'=>$domainName ,'licenceKey'=>$licenceKey ,'packageKey'=>$packageKey ,'packageVersion'=>$packageVersion ,'packageName'=>$packageName ,'fromDate'=>$fromDate , 'toDate'=>$toDate, 'fromDate1'=>$fromDate1, 'toDate1'=>$toDate1,'domainstatus1'=>$domainstatus1, 'branchCode'=>$branchCode, 'accessCount'=>$accessCount, 'adminId'=>$adminId, 'branchCodeSes'=>$branchCodeSes  
		);
		
		$status			= 'Install';
		$listLicense    = $ObjLicense->listLicenseInstUnauth($params,$status);
		
		$resPagesCount = $this->setPagesCount($key = 'page');
		$this->ObjView->assign("page", $page);	
		$this->ObjView->assign("sortby", $sortby); $this->ObjView->assign("orderby", ($orderby=="asc")?'desc':'asc'); $this->ObjView->assign("customerID", $customerID); $this->ObjView->assign("domainName", $domainName); $this->ObjView->assign("licenceKey", $licenceKey); $this->ObjView->assign("packageKey", $packageKey); $this->ObjView->assign("packageVersion", $packageVersion); $this->ObjView->assign("packageName", $packageName); $this->ObjView->assign("domainstatus1", $domainstatus1); $this->ObjView->assign("branchCode", $branchCode); $this->ObjView->assign("accessCount", $accessCount); 
		if($assignFromDate && $assignToDate==''){
			$this->ObjView->assign('createDate', $assignFromDate);
		}else if($assignFromDate && $assignToDate){
			$this->ObjView->assign('createDate', $assignFromDate.' - '.$assignToDate);
		}else{
			$this->ObjView->assign('createDate','');
		}
		
		if($assignFromDate1 && $assignToDate1==''){
			$this->ObjView->assign('accessTime', $assignFromDate1);
		}else if($assignFromDate1 && $assignToDate1){
			$this->ObjView->assign('accessTime', $assignFromDate1.' - '.$assignToDate1);
		}else{
			$this->ObjView->assign('accessTime','');
		}
		
		$this->ObjView->assign('listLicense', $listLicense);
		$this->ObjView->assign("editPrivilege", $editPrivilege);
		$this->ObjView->assign("deletePrivilege", $deletePrivilege);
		$this->ObjView->assign('settingsDateFormat', $settingsDateFormat);
		$this->ObjView->assign('settingsTimeFormat', $settingsTimeFormat);
		$this->ObjView->assign("link", $link);
		$this->ObjView->display('LicenseListInstall.tpl');
	}
	
	/* List License Unauthorized Access */
	public function unauthAction()    
	{
		$ObjLicense    	= new LicenseModel();
		$languageIDs	= $this->ObjView->languageIDs;	
		//$ObjCustomer	= new CustomerModel();
		//$resCustomer	= $ObjCustomer->listCustomerOptions();
		//$this->ObjView->assign('resCustomer', $resCustomer);
		$ObjPackage		= new PackageModel();
		$resPackage		= $ObjPackage->listPackageOptions();
		foreach($resPackage as $key=>$value) {
			$resPackage[$key][0] = $this->encryptDecrypt("decrypt",$value['packageKey']);
			$resPackage[$key][1] = $this->encryptDecrypt("decrypt",$value['packageName']);
		}
		$this->ObjView->assign('resPackage', $resPackage);	
		$ObjAdmin	 	= new AdminuserModel();
		$resBranches	= $ObjAdmin->listBranchCodes();
		$this->ObjView->assign('resBranches', $resBranches);
		$settingsDateFormat = $this->getSettingValue("site_settings", "date_format");
		$settingsTimeFormat = $this->getSettingValue("site_settings", "time_format");
		$adminId		= $this->ObjCommon->manageUserID; 
		$branchCodeSes	= $this->ObjCommon->manageBranchCode;
		$transID		= $this->ObjCommon->transSession;
		$ObjAdminlog	= new AdminlogModel();
		$unauthPrivilege	=	$this->ObjCommon->hasPrivilege('license/unauth/');
		if(!($unauthPrivilege))
		{
			 $this->setRedirect('license/index/');
		}
		if ((isset($_POST['select_status'])) && ($_POST['select_status']!=""))
		{
			if(($transID=="") || ($transID!=$adminId))
			{
				$this->setRedirect("adminuser/transPwd/urlback/ajax/ctrlpath/license/");
			}
			else
			{
				$domainNames		= array();
				$licenceIDs			= array();
				foreach($_POST['licenceID'] as $key=>$licenseValues)
				{
					$domainNames[]	= $key;
					$licenceIDs[]	= $licenseValues[0];
				}
				$ObjLicense			=	new LicenseModel();
				$params=array(
					'status'=>$_POST['select_status'],
					'licenceIDs'=>$licenceIDs
				);
				$licIDStr		= implode(",",$licenceIDs);
				$licNameStr		= implode(",",$domainNames);
				if(($_POST['select_status']=="Inactive") || ($_POST['select_status']=="Deleted"))
				{
					$licenseUsed	= $ObjLicense->checkLicenseParent($licenseIDs);
					if(count($licenseUsed)>0)
					{
						$this->setMessage('language.lblLicenseNotUpdate','message_info');
						/* Adminlog */
						$adminAccessIP		= $this->ObjCommon->getClientIP();
						$i									= 0;
						$adminActionData					= array();
						$adminActionData[$i]['status']		= "Status Updation Failed";
						$adminActionData[$i]['response']	= "License Have Active Sub Domains, So Cannot Change its Status";
						$adminActionData[$i]['message']		= "No Changes Found For Licensed Domains: <b>".$licNameStr."</b>";
						$i++;
						$adminActionDataStr					= serialize($adminActionData);
						$params =array(
						'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'License Unauth', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
						);
						$ObjAdminlog->insertAdminlog($params);
						/* End Adminlog */
					}
					else
					{
						$ObjLicense->changeStatus($params);
						$this->setMessage('language.lblLicensestatusUpdatedSuccess','success');
						/* Adminlog */
						$adminAccessIP						= $this->ObjCommon->getClientIP();
						$i									= 0;
						$adminActionData					= array();
						$adminActionData[$i]['status']		= "Updated The Status";
						$adminActionData[$i]['response']	= "Domains Bulk Status Updated Successfully";
						$adminActionData[$i]['message']		= "Updated Status of Licensed Domains<br/>";
						$adminActionData[$i]['message']		.= "<div class='grid_table00'>
						<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>LicenceID</td><td width='50%' height='15%' align='left'>Domain Name</td><td width='30%' height='15%' align='left'>Domain Status</td></tr>";
						for($s=0;$s<count($licenceIDs);$s++)
						{
							$adminActionData[$i]['message']		.= "<tr><td align='left'><b>".$licenceIDs[$s]."</b></td><td align='left'><b>".$domainNames[$s]."</b></td><td align='left'><b>".$_POST['select_status']."</b></td></tr>";
						}
						$adminActionData[$i]['message']		.= "</table></div><br/>";
						$i++;
						
						$adminActionDataStr					= serialize($adminActionData);

						$params =array(
						'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'License Unauth', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
						);
						$ObjAdminlog->insertAdminlog($params);
						/* End Adminlog */
					}
				}
				else
				{
					$ObjLicense->changeStatus($params);
					$this->setMessage('language.lblLicensestatusUpdatedSuccess','success');
					/* Adminlog */
					$adminAccessIP						= $this->ObjCommon->getClientIP();
					$i									= 0;
					$adminActionData					= array();
					$adminActionData[$i]['status']		= "Updated The Status";
					$adminActionData[$i]['response']	= "Domains Bulk Status Updated Successfully";
					$adminActionData[$i]['message']		= "Updated Status of Licensed Domains<br/>";
					$adminActionData[$i]['message']		.= "<div class='grid_table00'>
					<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>LicenceID</td><td width='50%' height='15%' align='left'>Domain Name</td><td width='30%' height='15%' align='left'>Domain Status</td></tr>";
					for($s=0;$s<count($licenceIDs);$s++)
					{
						$adminActionData[$i]['message']		.= "<tr><td align='left'><b>".$licenceIDs[$s]."</b></td><td align='left'><b>".$domainNames[$s]."</b></td><td align='left'><b>".$_POST['select_status']."</b></td></tr>";
					}
					$adminActionData[$i]['message']		.= "</table></div><br/>";
					$i++;
					
					$adminActionDataStr					= serialize($adminActionData);

					$params =array(
					'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'License Unauth', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
					);
					$ObjAdminlog->insertAdminlog($params);
					/* End Adminlog */
				}
				$this->setRedirect();
			}
		}	
		if(isset($_POST['cleanTracked']))
		{
			$status	= "Unauthorized";
			$ObjLicense->cleanTrackedAccess($status);
			$this->setMessage('language.lblLicenseAccessDeletedSuccess','success');
			/* Adminlog */
			$adminAccessIP		= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "Cleaned Access Track";
			$adminActionData[$i]['response']	= "License Tracked Access Deleted Successfully";
			$adminActionData[$i]['message']		= "Cleaned The Tracked Access Details In Unauthorized Section";
			$i++;
			$adminActionDataStr					= serialize($adminActionData);
			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'CleanTracked', 'adminActionObject'=>'License Unauthorized', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
		}
		$link	=	'license/unauth/';
		if (isset($_POST['search']))
		{		
			if ($_POST['customerID'] != ""){
				//$link .= "customerID/" . $this->encodeUrlString($_POST['customerID']) . "/";
				$link .= "customerID/" . ($_POST['customerID']) . "/";
			}			
			if ($_POST['domainName'] != ""){
				//$link .= "domainName/" . $this->encodeUrlString($_POST['domainName']) . "/";
				$link .= "domainName/" . ($_POST['domainName']) . "/";
			}			
			if ($_POST['licenceKey'] != ""){
				$link .= "licenceKey/" . $_POST['licenceKey'] . "/";
			}			
			if ($_POST['packageKey'] != ""){
				$link .= "packageKey/" . $this->encodeUrlString($_POST['packageKey']) . "/";
			}			
			if ($_POST['packageVersion'] != ""){
				$link .= "packageVersion/" . $_POST['packageVersion'] . "/";
			}					
			if ($_POST['packageName'] != ""){
				$link .= "packageName/" . $this->encodeUrlString($_POST['packageName']) . "/";
			}						
			if ($_POST['domainstatus1'] != ""){
				$link .= "domainstatus1/" . $this->encodeUrlString($_POST['domainstatus1']) . "/";
			}			
			if ($_POST['branchCode'] != ""){
				$link .= "branchCode/" . $_POST['branchCode'] . "/";
			}
			if ($_POST['createDate'] != ""){
				list($fromDate, $toDate) = split(' - ', $_POST['createDate']);
				$link .= (($fromDate != "") ? "from/" . $this->urlDate($fromDate, 'set', $settingsDateFormat) . "/" :"");
				$link .= (($toDate != "") ? "to/" . $this->urlDate($toDate, 'set', $settingsDateFormat) . "/" :"");
			}	
			if ($_POST['accessCount'] != ""){
				$link .= "accessCount/" . $_POST['accessCount'] . "/";
			}	
			if ($_POST['accessTime'] != ""){
				list($fromDate1, $toDate1) = split(' - ', $_POST['accessTime']);
				$link .= (($fromDate1 != "") ? "from1/" . $this->urlDate($fromDate1, 'set', $settingsDateFormat) . "/" :"");
				$link .= (($toDate1 != "") ? "to1/" . $this->urlDate($toDate1, 'set', $settingsDateFormat) . "/" :"");
			}	
			$this->setRedirect($link);
		}
		else
		{
			$sortby		=	$this->getRequestValue("sortby");
			$orderby	=	($this->getRequestValue("orderby")=="")?"asc":$this->getRequestValue("orderby");
					
			if($this->getRequestValue('customerID')){
				$customerID		= 	$this->decodeUrlString($this->getRequestValue('customerID'));
				$link.="customerID/".$customerID. "/";
			}			
			if($this->getRequestValue('domainName')){
				$domainName		= 	$this->decodeUrlString($this->getRequestValue('domainName'));
				$link.="domainName/".$domainName. "/";
			}			
			if($this->getRequestValue('licenceKey')){
				$licenceKey		= 	$this->getRequestValue('licenceKey');
				$link.="licenceKey/".$licenceKey. "/";
			}			
			if($this->getRequestValue('packageKey')){
				$packageKey		= 	$this->decodeUrlString($this->getRequestValue('packageKey'));
				$link.="packageKey/".$packageKey. "/";
			}			
			if($this->getRequestValue('packageVersion')){
				$packageVersion		= 	$this->getRequestValue('packageVersion');
				$link.="packageVersion/".$packageVersion. "/";
			}						
			if($this->getRequestValue('packageName')){
				$packageName		= 	$this->decodeUrlString($this->getRequestValue('packageName'));
				$link.="packageName/".$packageName. "/";
			}			
			if($this->getRequestValue('multipleDomainBackend')){
				$multipleDomainBackend		= 	$this->getRequestValue('multipleDomainBackend');
				$link.="multipleDomainBackend/".$multipleDomainBackend. "/";
			}			
			if($this->getRequestValue('domainstatus1')){
				$domainstatus1		= 	$this->decodeUrlString($this->getRequestValue('domainstatus1'));
				$link.="domainstatus1/".$domainstatus1. "/";
			}			
			if($this->getRequestValue('branchCode')){
				$branchCode		= 	$this->getRequestValue('branchCode');
				$link.="branchCode/".$branchCode. "/";
			}	
			if($this->getRequestValue('from')){
				$fromDate 		= $this->urlDate($this->getRequestValue('from'), 'get', $settingsDateFormat);
				$link .= (($fromDate != "") ? "from/" . $this->urlDate($fromDate, 'set', $settingsDateFormat) . "/" :"");
			}
			if($this->getRequestValue('to')){
				$toDate 		= $this->urlDate($this->getRequestValue('to'), 'get', $settingsDateFormat);
				$link .= (($toDate != "") ? "to/" . $this->urlDate($toDate, 'set', $settingsDateFormat) . "/" :	"");
			}
			if($this->getRequestValue('accessCount')){
				$accessCount		= 	$this->getRequestValue('accessCount');
				$link.="accessCount/".$accessCount. "/";
			}	
			if($this->getRequestValue('from1')){
				$fromDate1 		= $this->urlDate($this->getRequestValue('from1'), 'get', $settingsDateFormat);
				$link .= (($fromDate1 != "") ? "from1/" . $this->urlDate($fromDate1, 'set', $settingsDateFormat) . "/" :"");
			}
			if($this->getRequestValue('to1')){
				$toDate1 		= $this->urlDate($this->getRequestValue('to1'), 'get', $settingsDateFormat);
				$link .= (($toDate1 != "") ? "to1/" . $this->urlDate($toDate1, 'set', $settingsDateFormat) . "/" :	"");
			}
		}
		list($limitFrom, $limitTo) = $this->getPageSettings($key = 'page', $rows = 10); 
		
		/*assigning from and to values for search*/
		$assignFromDate =  $fromDate; 
        $assignToDate = $toDate;
        if (!$toDate && $fromDate){
           	 $toDate   = $fromDate; 
       	}
		$fromDate	= $this->convertDateForSQL($fromDate, $settingsDateFormat);
		$toDate		= $this->convertDateForSQL($toDate, $settingsDateFormat);
        /*assigning from and to values for search*/
		
		/*assigning from1 and to1 values for search*/
		$assignFromDate1 =  $fromDate1; 
        $assignToDate1 = $toDate1;
        if (!$toDate1 && $fromDate1){
           	 $toDate1   = $fromDate1; 
       	}
		$fromDate1	= $this->convertDateForSQL($fromDate1, $settingsDateFormat);
		$toDate1	= $this->convertDateForSQL($toDate1, $settingsDateFormat);
        /*assigning from1 and to1 values for search*/
		
		$params =array(
			'limitFrom'=>$limitFrom,
			'limitTo'=>$limitTo,
			'languageIDs'=>$languageIDs,
			'sortby'=>$sortby,
			'orderby'=>$orderby,
			'customerID'=>$customerID ,'domainName'=>$domainName ,'licenceKey'=>$licenceKey ,'packageKey'=>$packageKey ,'packageVersion'=>$packageVersion ,'packageName'=>$packageName ,'fromDate'=>$fromDate , 'toDate'=>$toDate, 'fromDate1'=>$fromDate1 , 'toDate1'=>$toDate1,'domainstatus1'=>$domainstatus1 ,'branchCode'=>$branchCode, 'accessCount'=>$accessCount, 'adminId'=>$adminId, 'branchCodeSes'=>$branchCodeSes  
		);
		
		$status			= 'Unauthorized';
		$listLicense    = $ObjLicense->listLicenseInstUnauth($params,$status);
		
		$resPagesCount = $this->setPagesCount($key = 'page');
		$this->ObjView->assign("page", $page);	
		$this->ObjView->assign("sortby", $sortby); $this->ObjView->assign("orderby", ($orderby=="asc")?'desc':'asc'); $this->ObjView->assign("customerID", $customerID); $this->ObjView->assign("domainName", $domainName); $this->ObjView->assign("licenceKey", $licenceKey); $this->ObjView->assign("packageKey", $packageKey); $this->ObjView->assign("packageVersion", $packageVersion); $this->ObjView->assign("multipleDomainFrontend", $multipleDomainFrontend); $this->ObjView->assign("multipleDomainBackend", $multipleDomainBackend); $this->ObjView->assign("domainstatus1", $domainstatus1); $this->ObjView->assign("branchCode", $branchCode); $this->ObjView->assign("accessCount", $accessCount); 
		if($assignFromDate && $assignToDate==''){
			$this->ObjView->assign('createDate', $assignFromDate);
		}else if($assignFromDate && $assignToDate){
			$this->ObjView->assign('createDate', $assignFromDate.' - '.$assignToDate);
		}else{
			$this->ObjView->assign('createDate','');
		}
		
		if($assignFromDate1 && $assignToDate1==''){
			$this->ObjView->assign('accessTime', $assignFromDate1);
		}else if($assignFromDate1 && $assignToDate1){
			$this->ObjView->assign('accessTime', $assignFromDate1.' - '.$assignToDate1);
		}else{
			$this->ObjView->assign('accessTime','');
		}
		
		$this->ObjView->assign('listLicense', $listLicense);
		$editPrivilege	=	$this->ObjCommon->hasPrivilege('license/edit/');
		$this->ObjView->assign("editPrivilege", $editPrivilege);
		$deletePrivilege	=	$this->ObjCommon->hasPrivilege('license/destroy/');
		$this->ObjView->assign("deletePrivilege", $deletePrivilege);
		$this->ObjView->assign('settingsDateFormat', $settingsDateFormat);
		$this->ObjView->assign('settingsTimeFormat', $settingsTimeFormat);
		
		$this->ObjView->assign("link", $link);
		$this->ObjView->display('LicenseListUnauth.tpl');
	}
	
	/* List License Expired */
	public function expiredAction()    
	{
		$ObjLicense    	= new LicenseModel();
		$languageIDs	= $this->ObjView->languageIDs;	
		$ObjPackage		= new PackageModel();
		$resPackage		= $ObjPackage->listPackageOptions();
		foreach($resPackage as $key=>$value) {
			$resPackage[$key][0] = $this->encryptDecrypt("decrypt",$value['packageKey']);
			$resPackage[$key][1] = $this->encryptDecrypt("decrypt",$value['packageName']);
		}
		$this->ObjView->assign('resPackage', $resPackage);	
		$ObjAdmin	 	= new AdminuserModel();
		$resBranches	= $ObjAdmin->listBranchCodes();
		$this->ObjView->assign('resBranches', $resBranches);
		$settingsDateFormat = $this->getSettingValue("site_settings", "date_format");
		$settingsTimeFormat = $this->getSettingValue("site_settings", "time_format");
		$adminId		= $this->ObjCommon->manageUserID; 
		$branchCodeSes	= $this->ObjCommon->manageBranchCode;
		$transID		= $this->ObjCommon->transSession;
		$ObjAdminlog	= new AdminlogModel();
		$editPrivilege		=	$this->ObjCommon->hasPrivilege('license/edit/');
		$deletePrivilege	=	$this->ObjCommon->hasPrivilege('license/destroy/');
		$expiredPrivilege	=	$this->ObjCommon->hasPrivilege('license/expired/');
		if(!($expiredPrivilege))
		{
			 $this->setRedirect('license/index/');
		}
		if ((isset($_POST['select_status'])) && ($_POST['select_status']!=""))
		{
			if(($transID=="") || ($transID!=$adminId))
			{
				$this->setRedirect("adminuser/transPwd/urlback/ajax/ctrlpath/license/");
			}
			else
			{
				$domainNames		= array();
				$licenceIDs			= array();
				foreach($_POST['licenceID'] as $key=>$licenseValues)
				{
					$domainNames[]	= $key;
					$licenceIDs[]	= $licenseValues[0];
				}
				$ObjLicense			=	new LicenseModel();
				$params=array(
					'status'=>$_POST['select_status'],
					'licenceIDs'=>$licenceIDs
				);
				$licIDStr		= implode(",",$licenceIDs);
				$licNameStr		= implode(",",$domainNames);
				if(($_POST['select_status']=="Inactive") || ($_POST['select_status']=="Deleted"))
				{
					$licenseUsed	= $ObjLicense->checkLicenseParent($licenseIDs);
					if(count($licenseUsed)>0)
					{
						$this->setMessage('language.lblLicenseNotUpdate','message_info');
						/* Adminlog */
						$adminAccessIP		= $this->ObjCommon->getClientIP();
						$i									= 0;
						$adminActionData					= array();
						$adminActionData[$i]['status']		= "Status Updation Failed";
						$adminActionData[$i]['response']	= "License Have Active Sub Domains, So Cannot Change its Status";
						$adminActionData[$i]['message']		= "No Changes Found For Licensed Domains: <b>".$licNameStr."</b>";
						$i++;
						$adminActionDataStr					= serialize($adminActionData);
						$params =array(
						'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'License Expired', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
						);
						$ObjAdminlog->insertAdminlog($params);
						/* End Adminlog */
					}
					else
					{
						$ObjLicense->changeStatus($params);
						$this->setMessage('language.lblLicensestatusUpdatedSuccess','success');
						/* Adminlog */
						$adminAccessIP						= $this->ObjCommon->getClientIP();
						$i									= 0;
						$adminActionData					= array();
						$adminActionData[$i]['status']		= "Updated The Status";
						$adminActionData[$i]['response']	= "Domains Bulk Status Updated Successfully";
						$adminActionData[$i]['message']		= "Updated Status of Licensed Domains<br/>";
						$adminActionData[$i]['message']		.= "<div class='grid_table00'>
						<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>LicenceID</td><td width='50%' height='15%' align='left'>Domain Name</td><td width='30%' height='15%' align='left'>Domain Status</td></tr>";
						for($s=0;$s<count($licenceIDs);$s++)
						{
							$adminActionData[$i]['message']		.= "<tr><td align='left'><b>".$licenceIDs[$s]."</b></td><td align='left'><b>".$domainNames[$s]."</b></td><td align='left'><b>".$_POST['select_status']."</b></td></tr>";
						}
						$adminActionData[$i]['message']		.= "</table></div><br/>";
						$i++;
						
						$adminActionDataStr					= serialize($adminActionData);

						$params =array(
						'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'License Expired', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
						);
						$ObjAdminlog->insertAdminlog($params);
						/* End Adminlog */
					}
				}
				else
				{
					$ObjLicense->changeStatus($params);
					$this->setMessage('language.lblLicensestatusUpdatedSuccess','success');
					/* Adminlog */
					$adminAccessIP						= $this->ObjCommon->getClientIP();
					$i									= 0;
					$adminActionData					= array();
					$adminActionData[$i]['status']		= "Updated The Status";
					$adminActionData[$i]['response']	= "Domains Bulk Status Updated Successfully";
					$adminActionData[$i]['message']		= "Updated Status of Licensed Domains<br/>";
					$adminActionData[$i]['message']		.= "<div class='grid_table00'>
					<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>LicenceID</td><td width='50%' height='15%' align='left'>Domain Name</td><td width='30%' height='15%' align='left'>Domain Status</td></tr>";
					for($s=0;$s<count($licenceIDs);$s++)
					{
						$adminActionData[$i]['message']		.= "<tr><td align='left'><b>".$licenceIDs[$s]."</b></td><td align='left'><b>".$domainNames[$s]."</b></td><td align='left'><b>".$_POST['select_status']."</b></td></tr>";
					}
					$adminActionData[$i]['message']		.= "</table></div><br/>";
					$i++;
					
					$adminActionDataStr					= serialize($adminActionData);

					$params =array(
					'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'License Expired', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
					);
					$ObjAdminlog->insertAdminlog($params);
					/* End Adminlog */
				}
				$this->setRedirect();
			}
		}	
		if(isset($_POST['cleanTracked']))
		{
			$status	= "Expired";
			$ObjLicense->cleanTrackedAccess($status);
			$this->setMessage('language.lblLicenseAccessDeletedSuccess','success');
			/* Adminlog */
			$adminAccessIP		= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "Cleaned Access Track";
			$adminActionData[$i]['response']	= "License Tracked Access Deleted Successfully";
			$adminActionData[$i]['message']		= "Cleaned The Tracked Access Details In License Expired";
			$i++;
			$adminActionDataStr					= serialize($adminActionData);
			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'CleanTracked', 'adminActionObject'=>'License Expired', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
		}
		$link	=	'license/expired/';
		if (isset($_POST['search']))
		{		
			if ($_POST['customerID'] != ""){
				//$link .= "customerID/" . $this->encodeUrlString($_POST['customerID']) . "/";
				$link .= "customerID/" . ($_POST['customerID']) . "/";
			}			
			if ($_POST['domainName'] != ""){
				//$link .= "domainName/" . $this->encodeUrlString($_POST['domainName']) . "/";
				$link .= "domainName/" . ($_POST['domainName']) . "/";
			}			
			if ($_POST['licenceKey'] != ""){
				$link .= "licenceKey/" . $_POST['licenceKey'] . "/";
			}			
			if ($_POST['packageKey'] != ""){
				$link .= "packageKey/" . $this->encodeUrlString($_POST['packageKey']) . "/";
			}			
			if ($_POST['packageVersion'] != ""){
				$link .= "packageVersion/" . $_POST['packageVersion'] . "/";
			}					
			if ($_POST['packageName'] != ""){
				$link .= "packageName/" . $this->encodeUrlString($_POST['packageName']) . "/";
			}					
			if ($_POST['domainstatus1'] != ""){
				$link .= "domainstatus1/" . $this->encodeUrlString($_POST['domainstatus1']) . "/";
			}			
			if ($_POST['branchCode'] != ""){
				$link .= "branchCode/" . $_POST['branchCode'] . "/";
			}
			if ($_POST['createDate'] != ""){
				list($fromDate, $toDate) = split(' - ', $_POST['createDate']);
				$link .= (($fromDate != "") ? "from/" . $this->urlDate($fromDate, 'set', $settingsDateFormat) . "/" :"");
				$link .= (($toDate != "") ? "to/" . $this->urlDate($toDate, 'set', $settingsDateFormat) . "/" :"");
			}	
			if ($_POST['accessCount'] != ""){
				$link .= "accessCount/" . $_POST['accessCount'] . "/";
			}	
			if ($_POST['accessTime'] != ""){
				list($fromDate1, $toDate1) = split(' - ', $_POST['accessTime']);
				$link .= (($fromDate1 != "") ? "from1/" . $this->urlDate($fromDate1, 'set', $settingsDateFormat) . "/" :"");
				$link .= (($toDate1 != "") ? "to1/" . $this->urlDate($toDate1, 'set', $settingsDateFormat) . "/" :"");
			}	
			$this->setRedirect($link);
		}
		else
		{
			$sortby		=	$this->getRequestValue("sortby");
			$orderby	=	($this->getRequestValue("orderby")=="")?"asc":$this->getRequestValue("orderby");
					
			if($this->getRequestValue('customerID')){
				$customerID		= 	$this->decodeUrlString($this->getRequestValue('customerID'));
				$link.="customerID/".$customerID. "/";
			}			
			if($this->getRequestValue('domainName')){
				$domainName		= 	$this->decodeUrlString($this->getRequestValue('domainName'));
				$link.="domainName/".$domainName. "/";
			}			
			if($this->getRequestValue('licenceKey')){
				$licenceKey		= 	$this->getRequestValue('licenceKey');
				$link.="licenceKey/".$licenceKey. "/";
			}			
			if($this->getRequestValue('packageKey')){
				$packageKey		= 	$this->decodeUrlString($this->getRequestValue('packageKey'));
				$link.="packageKey/".$packageKey. "/";
			}			
			if($this->getRequestValue('packageVersion')){
				$packageVersion		= 	$this->getRequestValue('packageVersion');
				$link.="packageVersion/".$packageVersion. "/";
			}						
			if($this->getRequestValue('packageName')){
				$packageName		= 	$this->decodeUrlString($this->getRequestValue('packageName'));
				$link.="packageName/".$packageName. "/";
			}					
			if($this->getRequestValue('domainstatus1')){
				$domainstatus1		= 	$this->decodeUrlString($this->getRequestValue('domainstatus1'));
				$link.="domainstatus1/".$domainstatus1. "/";
			}			
			if($this->getRequestValue('branchCode')){
				$branchCode		= 	$this->getRequestValue('branchCode');
				$link.="branchCode/".$branchCode. "/";
			}	
			if($this->getRequestValue('from')){
				$fromDate 		= $this->urlDate($this->getRequestValue('from'), 'get', $settingsDateFormat);
				$link .= (($fromDate != "") ? "from/" . $this->urlDate($fromDate, 'set', $settingsDateFormat) . "/" :"");
			}
			if($this->getRequestValue('to')){
				$toDate 		= $this->urlDate($this->getRequestValue('to'), 'get', $settingsDateFormat);
				$link .= (($toDate != "") ? "to/" . $this->urlDate($toDate, 'set', $settingsDateFormat) . "/" :	"");
			}
			if($this->getRequestValue('accessCount')){
				$accessCount		= 	$this->getRequestValue('accessCount');
				$link.="accessCount/".$accessCount. "/";
			}	
			if($this->getRequestValue('from1')){
				$fromDate1 		= $this->urlDate($this->getRequestValue('from1'), 'get', $settingsDateFormat);
				$link .= (($fromDate1 != "") ? "from1/" . $this->urlDate($fromDate1, 'set', $settingsDateFormat) . "/" :"");
			}
			if($this->getRequestValue('to1')){
				$toDate1 		= $this->urlDate($this->getRequestValue('to1'), 'get', $settingsDateFormat);
				$link .= (($toDate1 != "") ? "to1/" . $this->urlDate($toDate1, 'set', $settingsDateFormat) . "/" :	"");
			}
		}
		list($limitFrom, $limitTo) = $this->getPageSettings($key = 'page', $rows = 10); 
		
		/*assigning from and to values for search*/
		$assignFromDate =  $fromDate; 
        $assignToDate = $toDate;
        if (!$toDate && $fromDate){
           	 $toDate   = $fromDate; 
       	}
		$fromDate	= $this->convertDateForSQL($fromDate, $settingsDateFormat);
		$toDate		= $this->convertDateForSQL($toDate, $settingsDateFormat);
        /*assigning from and to values for search*/
		
		/*assigning from1 and to1 values for search*/
		$assignFromDate1 =  $fromDate1; 
        $assignToDate1 = $toDate1;
        if (!$toDate1 && $fromDate1){
           	 $toDate1   = $fromDate1; 
       	}
		$fromDate1	= $this->convertDateForSQL($fromDate1, $settingsDateFormat);
		$toDate1	= $this->convertDateForSQL($toDate1, $settingsDateFormat);
        /*assigning from1 and to1 values for search*/
		
		$params =array(
			'limitFrom'=>$limitFrom,
			'limitTo'=>$limitTo,
			'languageIDs'=>$languageIDs,
			'sortby'=>$sortby,
			'orderby'=>$orderby,
			'customerID'=>$customerID ,'domainName'=>$domainName ,'licenceKey'=>$licenceKey ,'packageKey'=>$packageKey ,'packageVersion'=>$packageVersion ,'packageName'=>$packageName ,'fromDate'=>$fromDate , 'toDate'=>$toDate, 'fromDate1'=>$fromDate1, 'toDate1'=>$toDate1,'domainstatus1'=>$domainstatus1, 'branchCode'=>$branchCode, 'accessCount'=>$accessCount, 'adminId'=>$adminId, 'branchCodeSes'=>$branchCodeSes  
		);
		
		$status			= 'Expired';
		$listLicense    = $ObjLicense->listLicenseInstUnauth($params,$status);
		
		$resPagesCount = $this->setPagesCount($key = 'page');
		$this->ObjView->assign("page", $page);	
		$this->ObjView->assign("sortby", $sortby); $this->ObjView->assign("orderby", ($orderby=="asc")?'desc':'asc'); $this->ObjView->assign("customerID", $customerID); $this->ObjView->assign("domainName", $domainName); $this->ObjView->assign("licenceKey", $licenceKey); $this->ObjView->assign("packageKey", $packageKey); $this->ObjView->assign("packageVersion", $packageVersion); $this->ObjView->assign("packageName", $packageName); $this->ObjView->assign("domainstatus1", $domainstatus1); $this->ObjView->assign("branchCode", $branchCode); $this->ObjView->assign("accessCount", $accessCount); 
		if($assignFromDate && $assignToDate==''){
			$this->ObjView->assign('createDate', $assignFromDate);
		}else if($assignFromDate && $assignToDate){
			$this->ObjView->assign('createDate', $assignFromDate.' - '.$assignToDate);
		}else{
			$this->ObjView->assign('createDate','');
		}
		
		if($assignFromDate1 && $assignToDate1==''){
			$this->ObjView->assign('accessTime', $assignFromDate1);
		}else if($assignFromDate1 && $assignToDate1){
			$this->ObjView->assign('accessTime', $assignFromDate1.' - '.$assignToDate1);
		}else{
			$this->ObjView->assign('accessTime','');
		}
		
		$this->ObjView->assign('listLicense', $listLicense);
		$this->ObjView->assign("editPrivilege", $editPrivilege);
		$this->ObjView->assign("deletePrivilege", $deletePrivilege);
		$this->ObjView->assign('settingsDateFormat', $settingsDateFormat);
		$this->ObjView->assign('settingsTimeFormat', $settingsTimeFormat);
		$this->ObjView->assign("link", $link);
		$this->ObjView->display('LicenseListExpired.tpl');
	}
	
	/* List License Unknown Unauthorized Access */
	public function unknunauthAction()    
	{
		$ObjLicense    	= new LicenseModel();
		$languageIDs	= $this->ObjView->languageIDs;	
		$ObjPackage		= new PackageModel();
		$resPackage		= $ObjPackage->listPackageOptions();
		foreach($resPackage as $key=>$value) {
			$resPackage[$key][0] = $this->encryptDecrypt("decrypt",$value['packageKey']);
			$resPackage[$key][1] = $this->encryptDecrypt("decrypt",$value['packageName']);
		}
		$this->ObjView->assign('resPackage', $resPackage);
		$adminId		= $this->ObjCommon->manageUserID; 
		$branchCodeSes	= $this->ObjCommon->manageBranchCode;
		$unknunauthPrivilege	=	$this->ObjCommon->hasPrivilege('license/unknunauth/');
		if(!($unknunauthPrivilege))
		{
			 $this->setRedirect('license/index/');
		}		
				
		$link	=	'license/unknunauth/';
		if (isset($_POST['search']))
		{				
			if ($_POST['domainName'] != ""){
				$link .= "domainName/" . $this->encodeUrlString($_POST['domainName']) . "/";
			}			
			if ($_POST['licenceKey'] != ""){
				$link .= "licenceKey/" . $_POST['licenceKey'] . "/";
			}	
			if ($_POST['section'] != ""){
				$link .= "section/" . $this->encodeUrlString($_POST['section']) . "/";
			}	
			if ($_POST['accessIP'] != ""){
				$link .= "accessIP/" . $this->encodeUrlString($_POST['accessIP']) . "/";
			}	
			if ($_POST['accessCount'] != ""){
				$link .= "accessCount/" . $_POST['accessCount'] . "/";
			}	
			if ($_POST['accessTime'] != ""){
				list($fromDate, $toDate) = split(' - ', $_POST['accessTime']);
				$link .= (($fromDate != "") ? "from/" . $this->urlDate($fromDate, 'set', $settingsDateFormat) . "/" :"");
				$link .= (($toDate != "") ? "to/" . $this->urlDate($toDate, 'set', $settingsDateFormat) . "/" :"");
			}	
			$this->setRedirect($link);
		}
		else
		{
			$sortby		=	$this->getRequestValue("sortby");
			$orderby	=	($this->getRequestValue("orderby")=="")?"asc":$this->getRequestValue("orderby");
							
			if($this->getRequestValue('domainName')){
				$domainName		= 	$this->decodeUrlString($this->getRequestValue('domainName'));
				$link.="domainName/".$domainName. "/";
			}			
			if($this->getRequestValue('licenceKey')){
				$licenceKey		= 	$this->getRequestValue('licenceKey');
				$link.="licenceKey/".$licenceKey. "/";
			}		
			if($this->getRequestValue('section')){
				$section		= 	$this->getRequestValue('section');
				$link.="section/".$section. "/";
			}	
			if($this->getRequestValue('accessIP')){
				$accessIP		= 	$this->decodeUrlString($this->getRequestValue('accessIP'));
				$link.="accessIP/".$accessIP. "/";
			}		
			if($this->getRequestValue('accessCount')){
				$accessCount		= 	$this->getRequestValue('accessCount');
				$link.="accessCount/".$accessCount. "/";
			}	
			if($this->getRequestValue('from')){
				$fromDate 		= $this->urlDate($this->getRequestValue('from'), 'get', $settingsDateFormat);
				$link .= (($fromDate != "") ? "from/" . $this->urlDate($fromDate, 'set', $settingsDateFormat) . "/" :"");
			}
			if($this->getRequestValue('to')){
				$toDate 		= $this->urlDate($this->getRequestValue('to'), 'get', $settingsDateFormat);
				$link .= (($toDate != "") ? "to/" . $this->urlDate($toDate, 'set', $settingsDateFormat) . "/" :	"");
			}
		}
		list($limitFrom, $limitTo) = $this->getPageSettings($key = 'page', $rows = 10); 
		
		/*assigning from and to values for search*/
		$assignFromDate =  $fromDate; 
        $assignToDate = $toDate;
        if (!$toDate && $fromDate){
           	 $toDate   = $fromDate; 
       	}
		$fromDate	= $this->convertDateForSQL($fromDate, $settingsDateFormat);
		$toDate		= $this->convertDateForSQL($toDate, $settingsDateFormat);
        /*assigning from and to values for search*/
		
		$params =array(
			'limitFrom'=>$limitFrom,
			'limitTo'=>$limitTo,
			'languageIDs'=>$languageIDs,
			'sortby'=>$sortby,
			'orderby'=>$orderby,
			'domainName'=>$domainName ,'licenceKey'=>$licenceKey ,'section'=>$section, 'accessIP'=>$accessIP, 'accessCount'=>$accessCount, 'fromDate'=>$fromDate, 'toDate'=>$toDate 
		);

		//$listLicense    = $ObjLicense->listLicenseUnknUnauth($params);
		list($listLicense, $keydomList)	= $ObjLicense->listLicenseUnknUnauth($params);
		for($i=0;$i<count($listLicense);$i++)
		{
			for($j=0;$j<count($keydomList);$j++)
			{	$keydomList[$j]['domainName'] = $keydomList[$j]['domainName'];
				if($listLicense[$i]['domainName']==$keydomList[$j]['domainName'])
				{
					$listLicense[$i]['domainNameTool']	= $keydomList[$j]['domainName']." ".base64_decode($keydomList[$j]['licenceKey']);
					$listLicense[$i]['licenceIDTool']	= $keydomList[$j]['licenceID'];
				}
				if($listLicense[$i]['licenceKey']==$keydomList[$j]['licenceKey'])
				{
					$listLicense[$i]['licenceKeyTool']	= $keydomList[$j]['domainName']." ".base64_decode($keydomList[$j]['licenceKey']);
					$listLicense[$i]['licenceIDTool']	= $keydomList[$j]['licenceID'];
				}
				if($listLicense[$i]['accessIP']==$keydomList[$j]['domainIP'])
				{
					$listLicense[$i]['accessIPTool']	= $keydomList[$j]['domainName']." ".base64_decode($keydomList[$j]['licenceKey']);
					$listLicense[$i]['licenceIDTool']	= $keydomList[$j]['licenceID'];
				}
			}
		}
		$resPagesCount = $this->setPagesCount($key = 'page');
		$this->ObjView->assign("page", $page);	
		$this->ObjView->assign("sortby", $sortby); $this->ObjView->assign("orderby", ($orderby=="asc")?'desc':'asc'); $this->ObjView->assign("domainName", $domainName); $this->ObjView->assign("licenceKey", $licenceKey); $this->ObjView->assign("section", $section); $this->ObjView->assign("accessIP", $accessIP); $this->ObjView->assign("accessCount", $accessCount); 
		if($assignFromDate && $assignToDate==''){
			$this->ObjView->assign('accessTime', $assignFromDate);
		}else if($assignFromDate && $assignToDate){
			$this->ObjView->assign('accessTime', $assignFromDate.' - '.$assignToDate);
		}else{
			$this->ObjView->assign('accessTime','');
		}
		$this->ObjView->assign('listLicense', $listLicense);
		$this->ObjView->assign('keydomList', $keydomList);
		$editPrivilege	=	$this->ObjCommon->hasPrivilege('license/edit/');
		$this->ObjView->assign("editPrivilege", $editPrivilege);
		$deletePrivilege	=	$this->ObjCommon->hasPrivilege('license/destroy/');
		$this->ObjView->assign("deletePrivilege", $deletePrivilege);
		$this->ObjView->assign('settingsDateFormat', $settingsDateFormat);
		$this->ObjView->assign('settingsTimeFormat', $settingsTimeFormat);
		
		$this->ObjView->assign("link", $link);
		$this->ObjView->display('LicenseListUnknUnauth.tpl');
	}
	
	/* List License Unknown Unauthorized Access Details */
	public function ajaxunknAction()    
	{
		$ObjLicense    	= new LicenseModel();
		$languageIDs	= $this->ObjView->languageIDs;		
		$licenceKey 	=   $this->getRequestValue('licenceKey');

		
		list($limitFrom, $limitTo) = $this->getPageSettings($key = 'page', $rows = 10); 
		
		$params =array(
			'limitFrom'=>$limitFrom,
			'limitTo'=>$limitTo,
			'languageIDs'=>$languageIDs,
			'licenceKey'=>$licenceKey
		);

		$listLicenseDetails	= $ObjLicense->listLicenseUnknDetail($params);		
		
		$resPagesCount = $this->setPagesCount($key = 'page');
		$this->ObjView->assign("page", $page);	
		$this->ObjView->assign('listLicenseDetails', $listLicenseDetails);
		$editPrivilege	=	$this->ObjCommon->hasPrivilege('license/edit/');
		$this->ObjView->assign("editPrivilege", $editPrivilege);
		$deletePrivilege	=	$this->ObjCommon->hasPrivilege('license/destroy/');
		$this->ObjView->assign("deletePrivilege", $deletePrivilege);
		
		//$this->ObjView->assign("link", $link);
		$this->ObjView->display('AjaxUnknDetail.tpl'); 
	}
	
	/* List License Unauthorized/Install Access Details Dashboard */
	public function ajaxunauthinstdetailAction()    
	{
		$ObjLicense    	= new LicenseModel();
		$languageIDs	= $this->ObjView->languageIDs;		
		$licenceKey 	=   $this->getRequestValue('licenceKey');
		$status		 	=   $this->getRequestValue('status');
		
		if($status=="Install")
		{
			$listLicenseDetails	= $ObjLicense->listInstallDashboardDetail($licenceKey);		
		}
		else if($status=="Expired")
		{
			$listLicenseDetails	= $ObjLicense->listExpiredDashboardDetail($licenceKey);		
		}
		else
		{
			$listLicenseDetails	= $ObjLicense->listUnauthDashboardDetail($licenceKey);	
		}
		
		$resPagesCount = $this->setPagesCount($key = 'page');
		$this->ObjView->assign("page", $page);	
		$this->ObjView->assign('listLicenseDetails', $listLicenseDetails);
		$editPrivilege	=	$this->ObjCommon->hasPrivilege('license/edit/');
		$this->ObjView->assign("editPrivilege", $editPrivilege);
		$deletePrivilege	=	$this->ObjCommon->hasPrivilege('license/destroy/');
		$this->ObjView->assign("deletePrivilege", $deletePrivilege);
		
		$this->ObjView->display('AjaxUnauthDetail.tpl'); 
	}
	
	/* List License Install Send Mail */
	public function ajaxSendMailPreviewAction()    
	{
		$ObjLicense    		= new LicenseModel();
		$ObjEmailtemplate	= new EmailtemplateModel();
		$languageIDs		= $this->ObjView->languageIDs;		
		$status 			= $this->getRequestValue('status');
		$licenceIDs 		= $this->getRequestValue('licenceIDs');
		$licenseIDar		= explode(',',$licenceIDs);
		$licenseCount		= count($licenseIDar);
		$emailTempDet     	= $ObjEmailtemplate->getEmailTemlateDetails($languageIDs, '', 'license-access-limit');
		$fromEmailName 		= $emailTempDet['emailFromName'];
        $fromEmailId   		= $emailTempDet['emailFromEmail'];
        $Subject       		= $emailTempDet['emailSubject'];
        $Body          		= $emailTempDet['emailHtml'];
		
		$this->ObjView->assign('licenseCount', $licenseCount);
		$this->ObjView->assign('Body', $Body);
		$this->ObjView->assign('licenceIDs', $licenceIDs);
		$this->ObjView->assign('status', $status);
		$this->ObjView->display('SendMailPreview.tpl');
	}
	
	/* List License Install Send Mail */
	public function ajaxSendMailAction()    
	{
		$ObjLicense    		= new LicenseModel();
		$ObjEmailtemplate	= new EmailtemplateModel();
		$languageIDs		= $this->ObjView->languageIDs;		
		$mail_settings   	= $this->getSettingValue('mail_settings');
        $ObjMail          	= new Mail($mail_settings);
		$status 			= $_POST['status'];
		$licenceIDs       	= $_POST['licenceIDs'];
		$licenseIDar		= explode(',',$licenceIDs);
		$licenseCount		= count($licenseIDar);
		$companyLogo   		= $this->getSettingValue('company_information', 'company_logo');
        $siteName      		= $this->getSettingValue('site_settings', 'site_name');
        $siteUrl       		= $this->getSettingValue('site_settings', 'global_http_url');
		$sendCount			= 0;
		$totalSendCount		= 0;
		$emailTempDet     	= $ObjEmailtemplate->getEmailTemlateDetails($languageIDs, '', 'license-access-limit');
		
		$listLicenseDetails	= $ObjLicense->getLicenseDetailsForMail($licenceIDs,$status);
		$mainCount			= $mainCount+count($listLicenseDetails);
		foreach ($listLicenseDetails as $license) 
		{
			$fromEmailName 		= $emailTempDet['emailFromName'];
			$fromEmailId   		= $emailTempDet['emailFromEmail'];
			$Subject       		= $emailTempDet['emailSubject'];
			$Subject       		.=  " - ".$status;
			$Body          		= $emailTempDet['emailHtml'];
			$this->ObjView->assign('emailBottom',$emailBottom);						
			$this->ObjView->assign('companyLogo', $companyLogo);
			$this->ObjView->assign('siteName', $siteName);
			$this->ObjView->assign('siteUrl', $siteUrl);
			$customerEmailID 	= $license['customerEmailID'];
			$customerName  		= $license['customerFirstName'] . ' ' . $license['customerLastName'];
			$Body         		= str_replace('{$customerName}', $license['customerFirstName'] . " " . $license['customerLastName'], $Body);
			$Body         		= str_replace('{$domainName}', $license['domainName'], $Body);
			$Body         		= str_replace('{$licenceKey}', base64_decode($license['licenceKey']), $Body);
			$Body         		= str_replace('{$packageName}', $license['packageName'], $Body);
			$Body         		= str_replace('{$packageVersion}', $license['packageVersion'], $Body);
			$Body         		= str_replace('{$accessCount}', $license['accessCount'], $Body);
			$Body				.= "<br/>".$_POST['mailContent'];
			
			$this->ObjView->assign('emailbody', $Body);
			$email_body = $this->ObjCommon->fetch("email_templates/Layout.tpl",$languageIDs);
			$ObjMail->IsHTML();
			$send      					= $ObjMail->sendMail(array(
																	$fromEmail,
																	$fromName
																	), 
															 array(
																	array(
																			$customerEmailID,
																			$customerName
																		 )
															
																  ),$Subject, $email_body);
			if (!$ObjMail->Send()) 
			{
				$message					.= '<br>Sending failed for '.$customerEmailID;	
			}
			else
			{
				$sendCount++;
				$totalSendCount ++;
				$sendEmails .= $customerName.',';
			}
			$ObjMail->clearAddresses();
		}
		
		if($mainCount == $totalSendCount) 
			$this->setMessage('Mails send to '.$mainCount.' Customer(s) ', 'success');
		else
			$this->setMessage('Mails send to '.$mainCount.' Customers '.$message, 'error');
		echo '<script type="text/javascript">parent.location.reload();parent.$.colorbox.close(); </script>';
		exit;
	}

	/**** Parameter Encode  ****/
	public function paramEncode($data)
	{
		$encfirst	= str_rot13($data);
		$encsecnd	= base64_encode(convert_uuencode($encfirst));
		$encdata	= urlencode($encsecnd);
		return $encdata;
	}
	/**** End Parameter Encode  ****/
	
	/**** Decode result with random key  ****/
	public function decodeDmhostip($resdata)
	{
		$decfirst	= urldecode($resdata);
		$decdata	= base64_decode(str_rot13($decfirst));
		return $decdata;
	}

	public function newAction()    
	{
		ini_set('soap.wsdl_cache_enabled', '0');
		ini_set('soap.wsdl_cache_ttl', '0'); 
		$ObjLicense    	= new LicenseModel();
		$languageIDs    = $this->ObjView->languageIDs;
		$adminId		= $this->ObjCommon->manageUserID; 
		$branchCodeSes	= $this->ObjCommon->manageBranchCode;
		$ObjCustomer	= new CustomerModel();
		$resCustomer	= $ObjCustomer->listCustomerOptions();
		foreach($resCustomer as $key=>$value) {
			$names = explode(' ',$value['customerName']);
			$names[0] = $this->encryptDecrypt("decrypt",$names[0]);
			$names[1] = $this->encryptDecrypt("decrypt",$names[1]);
			$names[2] = $this->encryptDecrypt("decrypt",$names[2]);
			$resCustomer[$key][1] = $resCustomer[$key]['customerName'] =  implode(' ',$names);
		}
		$this->ObjView->assign('resCustomer', $resCustomer);
		$ObjPackage		= new PackageModel();
		$resPackage		= $ObjPackage->listPackageOptions();
                foreach($resPackage as $key=>$value) {
                        $resPackage[$key][0] = $this->encryptDecrypt("decrypt",$value['packageKey']);    
			$resPackage[$key][1] = $this->encryptDecrypt("decrypt",$value['packageName']);
		}
		$this->ObjView->assign('resPackage', $resPackage); 
		$ObjAdmin	 	= new AdminuserModel();
		$resBranches	= $ObjAdmin->listBranchCodes();
		$this->ObjView->assign('resBranches', $resBranches);
		$resParent		= $ObjLicense->getParentLicense();
		foreach($resParent as $key=>$value) {
			$resParent[$key][1] = $value['domainName'];//$this->encryptDecrypt("decrypt",$value['domainName']);
		}
		$resParent = array_merge(array('0'=>array('0'=>'0','licenceID' => '0','1'=>'Root Level','domainName'=>'Root Level')), $resParent);
		$this->ObjView->assign('resParent', $resParent);
		$this->ObjView->assign('resParentJson', json_encode($resParent));
		$ObjAdminlog	= 	new AdminlogModel();
		if($this->ObjForm->isValid('formLicense','submitLicense'))
		{

			$wsdl="http://ssl.oorjit.com/createlic/createlickey.php?wsdl";
			//$wsdl="http://demo.oorjit.com/~ssloorji/createlic/createlickey.php?wsdl";
			$client=new soapclient($wsdl); 
			$dataparam		= $_POST['customerID'];
			$dataToken		= $this->paramEncode($dataparam);			
			$param=array('dataToken'=>$dataToken);
			try
			{
				//Calling web service
				$resultenc		= $client->__call('createLicense', $param);
				$resultlic		= $this->decodeDmhostip($resultenc);	
				$resultlicenc	= base64_encode($resultlic); 
			}
			catch(SoapFault $fault)
			{  
				echo "<div style=\"border:#900 1px solid;width:50%;margin:0 auto;background:#f06868;padding:30px 8px; text-align:center;font: bold 12px Arial, Helvetica, sans-serif;color:#fff;\">Sorry for the inconvenience, Please try later</div>";
				exit;
			}
                        
			$id	= $ObjLicense->insert($languageIDs,$resultlicenc,'',$adminId);
			$this->setMessage('language.lblLicenseaddSuccess','success');
			/* Adminlog */
			$adminAccessIP						= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "New";
			$adminActionData[$i]['response']	= "Successfully Added";
			$i++;
			
			if(isset($_POST['customerID']))
			{
				foreach ($resCustomer as $k => $val) 
				{
				   if ($val['customerID'] == $_POST['customerID']) 
				   {
					   $customerName	= $resCustomer[$k]['customerName'];
				   }
				}
			}
			if(isset($_POST['parentDomain']))
			{
				if($_POST['parentDomain']==0)
				{
					$parentName	= "Root Level";
				}
				else
				{
					foreach ($resParent as $key => $value) 
					{
					   if ($value['licenceID'] == $_POST['parentDomain']) 
					   {
						   $parentName	= $resCustomer[$key]['domainName'];
					   }
					}
				}
			}
			$adminActionData[$i]['field']	= "Customer";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $customerName;
			$i++;
			
			$adminActionData[$i]['field']	= "DomainName";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['domainName'];
			$i++;

			$adminActionData[$i]['field']	= "PackageKey";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['packageKey'];
			$i++;
			
			$adminActionData[$i]['field']	= "PackageVersion";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['packageVersion'];
			$i++;

			$adminActionData[$i]['field']	= "Domainstatus";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['domainstatus'];
			$i++;
			
			$adminActionData[$i]['field']	= "LicenseType";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['licenseType'];
			$i++;


			$adminActionData[$i]['field']	= "ParentDomain";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $parentName;
			$i++;
			
			if(isset($_POST['expiry']))
			{
				$adminActionData[$i]['field']	= "Expiry";
				$adminActionData[$i]['Old']		= "";
				$adminActionData[$i]['New']		= $_POST['expiry'];
				$i++;
			}
			if((isset($_POST['expiryDate'])) && ($_POST['expiryDate']!=""))
			{
				$adminActionData[$i]['field']	= "ExpiryDate";
				$adminActionData[$i]['Old']		= "";
				$adminActionData[$i]['New']		= $_POST['expiryDate'];
				$i++;
			}

			$adminActionDataStr				= serialize($adminActionData);

			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'New', 'adminActionObject'=>'License', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
			$this->setRedirect('license/view/id/'.$id.'/');
		}
		else
		{
			if(isset($_POST['submitLicense']))
			{
				if(!$this->ObjForm->isValid('formLicense','submitLicense'))
				{
					/* Adminlog */
					$adminAccessIP		= $this->ObjCommon->getClientIP();
					$i									= 0;
					$adminActionData					= array();
					$adminActionData[$i]['status']		= "Insert Failed";
					$adminActionData[$i]['response']	= "Error found in form element";
					$adminActionData[$i]['message']		= "Data Cannot Be Added";
					$i++;
					$adminActionDataStr					= serialize($adminActionData);
					$params =array(
					'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'New', 'adminActionObject'=>'License', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
					);
					$ObjAdminlog->insertAdminlog($params);
					/* End Adminlog */
				}
			}
		}
		$editPrivilege	=	$this->ObjCommon->hasPrivilege('license/edit/');
		$this->ObjView->assign("editPrivilege", $editPrivilege);
		$this->ObjView->assign("adminId", $adminId);
		$this->ObjView->display('LicenseAdd.tpl');
	}

	public function editAction()    
	{
		$licenceID 		= $this->getRequestValue('id');
		$ObjLicense    	= new LicenseModel();
		$languageIDs    = $this->ObjView->languageIDs;
		$adminId		= $this->ObjCommon->manageUserID; 
		$branchCodeSes	= $this->ObjCommon->manageBranchCode;
		$ObjCustomer	= new CustomerModel();
		$resCustomer	= $ObjCustomer->listCustomerOptions();
		foreach($resCustomer as $key=>$value) {
			$names = explode(' ',$value['customerName']);
			$names[0] = $this->encryptDecrypt("decrypt",$names[0]);
			$names[1] = $this->encryptDecrypt("decrypt",$names[1]);
			$names[2] = $this->encryptDecrypt("decrypt",$names[2]);
			$resCustomer[$key][1] = $resCustomer[$key]['customerName'] =  implode(' ',$names);
		}
		$this->ObjView->assign('resCustomer', $resCustomer);
		$ObjPackage		= new PackageModel();
		$resPackage		= $ObjPackage->listPackageOptions();
                foreach($resPackage as $key=>$value) {
                        $resPackage[$key][0] = $this->encryptDecrypt("decrypt",$value['packageKey']);  
			$resPackage[$key][1] = $this->encryptDecrypt("decrypt",$value['packageName']);
		}
		$this->ObjView->assign('resPackage', $resPackage);
		$ObjAdmin	 	= new AdminuserModel();
		$resBranches	= $ObjAdmin->listBranchCodes();
		$this->ObjView->assign('resBranches', $resBranches);
		$resParent		= $ObjLicense->getParentLicense();
		foreach($resParent as $key=>$value) {
			$resParent[$key][1] = $value['domainName'];
		}
		$resParent = array_merge(array('0'=>array('0'=>'0','licenceID' => '0','1'=>'Root Level','domainName'=>'Root Level')), $resParent);
		$this->ObjView->assign('resParent', $resParent);
		$this->ObjView->assign('resParentJson', json_encode($resParent));
		$params=array(
			'licenceID'=>$licenceID,
			'languageIDs'=>$languageIDs
		);
		$getLicense	= $ObjLicense->getLicenseDetails($params);
		if(empty($getLicense))
		{
			 $this->setRedirect('license');
		}
	
		$getLicense['domainName']	= ($getLicense['domainName']!="")?($getLicense['domainName']):'';
		$getLicense['packageVersion']= ($getLicense['packageVersion']!="")?($getLicense['packageVersion']):'';
		$getLicense['orderID']		= ($getLicense['orderID']!="")?$getLicense['orderID']:'';
		$getLicense['addons']		= ($getLicense['addons']!="")?$this->encryptDecrypt("decrypt",$getLicense['addons']):'';
		$getLicense['comments']		= ($getLicense['comments']!="")?($this->encryptDecrypt("decrypt",($getLicense['comments']))):'';
		
		
		$ObjAdminlog	= 	new AdminlogModel();
		if($this->ObjForm->isValid('formLicense','submitLicense'))
		{
					
			$ObjLicense->insert($languageIDs,'',$licenceID,$adminId);
			$this->setMessage('language.lblLicenseupdatedSuccess','success');
			/* Adminlog */
			$adminAccessIP						= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "Updated";
			$adminActionData[$i]['response']	= "Successfully Updated The Domain: <b>".$getLicense['domainName']."</b>";
			$i++;
			if(isset($_POST['customerID']))
			{
				foreach ($resCustomer as $k => $val) 
				{
					if ($val['customerID'] == $_POST['customerID']) 
					{
						$customerName	= $resCustomer[$k]['customerName'];
					}
					if ($val['customerID'] == $getLicense['customerID']) 
					{
						$oldcustomerName	= $resCustomer[$k]['customerName'];
					}
				}
			}
			if(isset($_POST['parentDomain']))
			{
				if(($_POST['parentDomain']!=0) || ($getLicense['parentDomain']!=0))
				{
					foreach ($resParent as $key => $value) 
					{
						if ($value['licenceID'] == $_POST['parentDomain']) 
						{
							$parentName	= $resCustomer[$key]['domainName'];
						}
						if($value['licenceID'] == $getLicense['parentDomain'])
						{
							$oldparentName	= $resCustomer[$key]['domainName'];
						}
					}
				}
				if($_POST['parentDomain']==0)
				{
					$parentName	= "Root Level";
				}
				if($getLicense['parentDomain']==0)
				{
					$parentName	= "Root Level";
				}

			}
			if($getLicense['customerID']!=$_POST['customerID'])
			{
				$adminActionData[$i]['field']	= "Customer";
				$adminActionData[$i]['Old']		= $oldcustomerName;
				$adminActionData[$i]['New']		= $customerName;
				$i++;
			}
			if($getLicense['domainName']!=$_POST['domainName'])
			{
				$adminActionData[$i]['field']	= "DomainName";
				$adminActionData[$i]['Old']		= $getLicense['domainName'];
				$adminActionData[$i]['New']		= $_POST['domainName'];
				$i++;
			}
			if($getLicense['packageKey']!=$_POST['packageKey'])
			{
				$adminActionData[$i]['field']	= "PackageKey";
				$adminActionData[$i]['Old']		= $getLicense['packageKey'];
				$adminActionData[$i]['New']		= $_POST['packageKey'];
				$i++;
			}
			if($getLicense['packageVersion']!=$_POST['packageVersion'])
			{
				$adminActionData[$i]['field']	= "PackageVersion";
				$adminActionData[$i]['Old']		= $getLicense['packageVersion'];
				$adminActionData[$i]['New']		= $_POST['packageVersion'];
				$i++;
			}
			if($getLicense['domainstatus']!=$_POST['domainstatus'])
			{
				$adminActionData[$i]['field']	= "Domainstatus";
				$adminActionData[$i]['Old']		= $getLicense['domainstatus'];
				$adminActionData[$i]['New']		= $_POST['domainstatus'];
				$i++;
			}
			if($getLicense['licenseType']!=$_POST['licenseType'])
			{
				$adminActionData[$i]['field']	= "LicenseType";
				$adminActionData[$i]['Old']		= $getLicense['licenseType'];
				$adminActionData[$i]['New']		= $_POST['licenseType'];
				$i++;
			}
			if($getLicense['parentDomain']!=$_POST['parentDomain'])
			{
				$adminActionData[$i]['field']	= "ParentDomain";
				$adminActionData[$i]['Old']		= $oldparentName;
				$adminActionData[$i]['New']		= $parentName;
				$i++;
			}
			
			if(isset($_POST['expiry']))
			{
				if($getLicense['expiry']!=$_POST['expiry'])
				{
					$adminActionData[$i]['field']	= "Expiry";
					$adminActionData[$i]['Old']		= $getLicense['expiry'];
					$adminActionData[$i]['New']		= $_POST['expiry'];
					$i++;
				
				}
			}
			if((isset($_POST['expiryDate'])) && ($_POST['expiryDate']!=""))
			{
				if($getLicense['expiryDate']!=$_POST['expiryDate'])
				{
					$adminActionData[$i]['field']	= "ExpiryDate";
					$adminActionData[$i]['Old']		= $getLicense['expiryDate'];
					$adminActionData[$i]['New']		= $_POST['expiryDate'];
					$i++;
				}
			}
			
			if(count($adminActionData)==1)
			{
				$adminActionData[0]['message']	= "No Changes With Form Elements OR Minor Changes For Domain: <b>".$getLicense['domainName']."</b>";
			}
			$adminActionDataStr					= serialize($adminActionData);

			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Edit', 'adminActionObject'=>'License', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
			$this->setRedirect('license/view/id/'.$licenceID.'/');
			
		} 
		else
		{
			if(isset($_POST['submitLicense']))
			{
				if(!$this->ObjForm->isValid('formLicense','submitLicense'))
				{
					/* Adminlog */
					$adminAccessIP		= $this->ObjCommon->getClientIP();
					$i									= 0;
					$adminActionData					= array();
					$adminActionData[$i]['status']		= "Update Failed";
					$adminActionData[$i]['response']	= "Error found in form element";
					$adminActionData[$i]['message']		= "No Changes Found For Domain: <b>".$getLicense['domainName']."</b>";
					$i++;
					$adminActionDataStr					= serialize($adminActionData);
					$params =array(
					'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Edit', 'adminActionObject'=>'License', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
					);
					$ObjAdminlog->insertAdminlog($params);
					/* End Adminlog */
				}
			}
		}
		$adminId		= $this->ObjCommon->manageUserID; 
		$branchCodeSes	= $this->ObjCommon->manageBranchCode;
		$editPrivilege	= $this->ObjCommon->hasPrivilege('license/edit/');
		$this->ObjView->assign("editPrivilege", $editPrivilege);
		$this->ObjView->assign("adminId", $adminId);
		$this->ObjView->assignValues($getLicense);
		$this->ObjView->assign('licenceID', $licenceID);
		$this->ObjView->display('LicenseAdd.tpl');
		
	}
	
	public function editbranchAction()    
	{
		$licenceID 		= $this->getRequestValue('id');
		$ObjLicense    	= new LicenseModel();
		$languageIDs    = $this->ObjView->languageIDs;
		$adminId		= $this->ObjCommon->manageUserID; 
		$branchCodeSes	= $this->ObjCommon->manageBranchCode;
		$ObjCustomer	= new CustomerModel();
		$resCustomer	= $ObjCustomer->listCustomerOptions();
		foreach($resCustomer as $key=>$value) {
			$names = explode(' ',$value['customerName']);
			$names[0] = $this->encryptDecrypt("decrypt",$names[0]);
			$names[1] = $this->encryptDecrypt("decrypt",$names[1]);
			$names[2] = $this->encryptDecrypt("decrypt",$names[2]);
			$resCustomer[$key][1] = $resCustomer[$key]['customerName'] =  implode(' ',$names);
		}
		$this->ObjView->assign('resCustomer', $resCustomer);
		$ObjPackage		= new PackageModel();
		$resPackage		= $ObjPackage->listPackageOptions();
                foreach($resPackage as $key=>$value) {
                        $resPackage[$key][0] = $this->encryptDecrypt("decrypt",$value['packageKey']);  
			$resPackage[$key][1] = $this->encryptDecrypt("decrypt",$value['packageName']);
		}
		$this->ObjView->assign('resPackage', $resPackage);
		$resParent		= $ObjLicense->getParentLicense();
		$resParent = array_merge(array('0'=>array('0'=>'0','licenceID' => '0','1'=>'Root Level','domainName'=>'Root Level')), $resParent);
		$this->ObjView->assign('resParent', $resParent);
		$params=array(
			'licenceID'=>$licenceID,
			'languageIDs'=>$languageIDs
		);
		$getLicense	= $ObjLicense->getLicenseDetails($params);
		if(empty($getLicense))
		{
			 $this->setRedirect('license');
		}
		
		$ObjAdminlog	= 	new AdminlogModel();
		if($this->ObjForm->isValid('formLicense','submitLicense'))
		{
					
			$ObjLicense->insert($languageIDs,'',$licenceID,$adminId);
			$this->setMessage('language.lblLicenseupdatedSuccess','success');
			/* Adminlog */
			$adminAccessIP						= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "Updated";
			$adminActionData[$i]['response']	= "Successfully Updated The Domain: <b>".$getLicense['domainName']."</b>";
			$i++;
			if(isset($_POST['expiry']))
			{
				if($getLicense['expiry']!=$_POST['expiry'])
				{
					$adminActionData[$i]['field']	= "Expiry";
					$adminActionData[$i]['Old']		= $getLicense['expiry'];
					$adminActionData[$i]['New']		= $_POST['expiry'];
					$i++;
				
				}
			}
			if((isset($_POST['expiryDate'])) && ($_POST['expiryDate']!=""))
			{
				if($getLicense['expiryDate']!=$_POST['expiryDate'])
				{
					$adminActionData[$i]['field']	= "ExpiryDate";
					$adminActionData[$i]['Old']		= $getLicense['expiryDate'];
					$adminActionData[$i]['New']		= $_POST['expiryDate'];
					$i++;
				}
			}
			
			if(count($adminActionData)==1)
			{
				$adminActionData[0]['message']	= "No Changes With Form Elements OR Minor Changes For Domain: <b>".$getLicense['domainName']."</b>";
			}
			$adminActionDataStr					= serialize($adminActionData);

			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'EditBranchAdmin', 'adminActionObject'=>'License', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
			$this->setRedirect('license/view/id/'.$licenceID.'/');
			
		} 
		else
		{
			if(isset($_POST['submitLicense']))
			{
				if(!$this->ObjForm->isValid('formLicense','submitLicense'))
				{
					/* Adminlog */
					$adminAccessIP		= $this->ObjCommon->getClientIP();
					$i									= 0;
					$adminActionData					= array();
					$adminActionData[$i]['status']		= "Update Failed";
					$adminActionData[$i]['response']	= "Error found in form element";
					$adminActionData[$i]['message']		= "No Changes Found For Domain: <b>".$getLicense['domainName']."</b>";
					$i++;
					$adminActionDataStr					= serialize($adminActionData);
					$params =array(
					'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'EditBranchAdmin', 'adminActionObject'=>'License', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
					);
					$ObjAdminlog->insertAdminlog($params);
					/* End Adminlog */
				}
			}
		}
		$editPrivilege	=	$this->ObjCommon->hasPrivilege('license/edit/');
		$this->ObjView->assign("editPrivilege", $editPrivilege);
		$this->ObjView->assign("adminId", $adminId);
		$this->ObjView->assignValues($getLicense);
		$this->ObjView->assign('licenceID', $licenceID);
		$this->ObjView->display('LicenseAdd.tpl');
		
	}

	public function encodeDm($input,$key='S1W')
	{
		$result = md5($input.$key);
		return $result;
	}
	public function viewAction()    
	{
		$licenceID  	= $this->getRequestValue('id');
		$ObjLicense    	= new LicenseModel();
		$languageIDs    = $this->ObjView->languageIDs;
		$adminId		= $this->ObjCommon->manageUserID; 
		$branchCodeSes	= $this->ObjCommon->manageBranchCode;
		$params=array(
			'licenceID'=>$licenceID,
			'languageIDs'=>$languageIDs, 
			'adminId'=>$adminId, 
			'branchCodeSes'=>$branchCodeSes 
		);
		$getLicense	= $ObjLicense->getLicenseDetails($params);
                
		$domainNameEnc	= $this->encodeDm($getLicense['domainName']);
		if(empty($getLicense)){
			 $this->setRedirect('license/index/');
		}
		$getLicenseSub	= $ObjLicense->getLicenseSub($params);
		$this->ObjView->assign('getLicense', $getLicense);
		$this->ObjView->assign('domainNameEnc', $domainNameEnc);
		$this->ObjView->assign('getLicenseSub', $getLicenseSub);
		$this->ObjView->assign('licenceID', $licenceID);
		$editPrivilege	=	$this->ObjCommon->hasPrivilege('license/edit/');
		$this->ObjView->assign("editPrivilege", $editPrivilege);
		$editbranchPriv	=	$this->ObjCommon->hasPrivilege('license/editbranch/');
		$this->ObjView->assign("editbranchPriv", $editbranchPriv);
		$this->ObjView->assign("previousURl", $this->getPreviousURL());
		$this->ObjView->display('LicenseView.tpl');
		
	}
	
	/* To show install details */
	public function viewinstallAction()    
	{
		$licenceID  	= $this->getRequestValue('id');
		$ObjLicense    	= new LicenseModel();
		$languageIDs    = $this->ObjView->languageIDs;
		$adminId		= $this->ObjCommon->manageUserID; 
		$branchCodeSes	= $this->ObjCommon->manageBranchCode;
		$params=array(
			'licenceID'=>$licenceID,
			'languageIDs'=>$languageIDs, 
			'adminId'=>$adminId, 
			'branchCodeSes'=>$branchCodeSes 
		);
		$getLicense	= $ObjLicense->getLicenseDetails($params);
		if(empty($getLicense)){
			 $this->setRedirect('license/install/');
		}
		$status	= "Install";
		$getLicenseAccess	= $ObjLicense->getLicenseAccessDetails($params,$status);
		$this->ObjView->assign('getLicense', $getLicense);
		$this->ObjView->assign('getLicenseAccess', $getLicenseAccess);
		$this->ObjView->assign('licenceID', $licenceID);
		$editPrivilege	=	$this->ObjCommon->hasPrivilege('license/edit/');
		$this->ObjView->assign("editPrivilege", $editPrivilege);
		$editbranchPriv	=	$this->ObjCommon->hasPrivilege('license/editbranch/');
		$this->ObjView->assign("editbranchPriv", $editbranchPriv);
		$this->ObjView->assign("previousURl", $this->getPreviousURL());
		$this->ObjView->display('LicenseViewInstall.tpl');
		
	}
	
	/* To show Unauthorized details */
	public function viewunauthAction()    
	{
		$licenceID  	= $this->getRequestValue('id');
		$ObjLicense    	= new LicenseModel();
		$languageIDs    = $this->ObjView->languageIDs;
		$adminId		= $this->ObjCommon->manageUserID; 
		$branchCodeSes	= $this->ObjCommon->manageBranchCode;
		$params=array(
			'licenceID'=>$licenceID,
			'languageIDs'=>$languageIDs, 
			'adminId'=>$adminId, 
			'branchCodeSes'=>$branchCodeSes 
		);
		$getLicense	= $ObjLicense->getLicenseDetails($params);
		if(empty($getLicense)){
			 $this->setRedirect('license/install/');
		}
		$status	= "Unauthorized";
		$getLicenseAccess	= $ObjLicense->getLicenseAccessDetails($params,$status);
		$this->ObjView->assign('getLicense', $getLicense);
		$this->ObjView->assign('getLicenseAccess', $getLicenseAccess);
		$this->ObjView->assign('licenceID', $licenceID);
		$editPrivilege	=	$this->ObjCommon->hasPrivilege('license/edit/');
		$this->ObjView->assign("editPrivilege", $editPrivilege);
		$editbranchPriv	=	$this->ObjCommon->hasPrivilege('license/editbranch/');
		$this->ObjView->assign("editbranchPriv", $editbranchPriv);
		$this->ObjView->assign("previousURl", $this->getPreviousURL());
		$this->ObjView->display('LicenseViewUnauth.tpl');
		
	}
	
	/* To show expired details */
	public function viewexpiredAction()    
	{
		$licenceID  	= $this->getRequestValue('id');
		$ObjLicense    	= new LicenseModel();
		$languageIDs    = $this->ObjView->languageIDs;
		$adminId		= $this->ObjCommon->manageUserID; 
		$branchCodeSes	= $this->ObjCommon->manageBranchCode;
		$params=array(
			'licenceID'=>$licenceID,
			'languageIDs'=>$languageIDs, 
			'adminId'=>$adminId, 
			'branchCodeSes'=>$branchCodeSes 
		);
		$getLicense	= $ObjLicense->getLicenseDetails($params);
		if(empty($getLicense)){
			 $this->setRedirect('license/expired/');
		}
		$status	= "Expired";
		$getLicenseAccess	= $ObjLicense->getLicenseAccessDetails($params,$status);
		$this->ObjView->assign('getLicense', $getLicense);
		$this->ObjView->assign('getLicenseAccess', $getLicenseAccess);
		$this->ObjView->assign('licenceID', $licenceID);
		$editPrivilege	=	$this->ObjCommon->hasPrivilege('license/edit/');
		$this->ObjView->assign("editPrivilege", $editPrivilege);
		$editbranchPriv	=	$this->ObjCommon->hasPrivilege('license/editbranch/');
		$this->ObjView->assign("editbranchPriv", $editbranchPriv);
		$this->ObjView->assign("previousURl", $this->getPreviousURL());
		$this->ObjView->display('LicenseViewExpired.tpl');
		
	}

	public function ajaxstatusAction()    
	{
		$licenceID 	=   $this->getRequestValue('id');
		$domName 	=   $this->getRequestValue('domName');
		$licenseIDs	= 	array($licenceID);
		$status		=   $this->getRequestValue('status');
		$ObjLicense = 	new LicenseModel();
		$ObjAdminlog= 	new AdminlogModel();
		$adminId	=	$this->ObjCommon->manageUserID; 
		$params=array(
			'status'=>$status,
			'licenceIDs'=>array($licenceID)
		);
		if(($status=="Inactive") || ($status=="Deleted"))
		{
			$licenseUsed	= $ObjLicense->checkLicenseParent($licenseIDs);
			if(count($licenseUsed)>0)
			{
				$this->setMessage('language.lblLicenseNotUpdate','message_info');
				/* Adminlog */
				$adminAccessIP		= $this->ObjCommon->getClientIP();
				$i									= 0;
				$adminActionData					= array();
				$adminActionData[$i]['status']		= "Status Updation Failed";
				$adminActionData[$i]['response']	= "License Have Active Sub Domains, So Cannot Change its Status";
				$adminActionData[$i]['message']		= "No Changes Found For Domain: <b>".$domName."</b>";
				$i++;
				$adminActionDataStr					= serialize($adminActionData);
				$params =array(
				'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Status', 'adminActionObject'=>'License', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
				);
				$ObjAdminlog->insertAdminlog($params);
				/* End Adminlog */
			}
			else
			{
				$changeStatus = $ObjLicense->changeStatus($params);
				$this->setMessage('language.lblLicensestatusUpdatedSuccess','success');
				/* Adminlog */
				$adminAccessIP						= $this->ObjCommon->getClientIP();
				$i									= 0;
				$adminActionData					= array();
				$adminActionData[$i]['status']		= "Updated The Status";
				$adminActionData[$i]['response']	= "Licensed Domain Status Updated Successfully";
				$adminActionData[$i]['message']		= "Updated Status of Licensed Domain<br/>";
				$adminActionData[$i]['message']		.= "<div class='grid_table00'>
				<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>LicenceID</td><td width='50%' height='15%' align='left'>Domain Name</td><td width='30%' height='15%' align='left'>Domain Status</td></tr><tr><td align='left'><b>".$licenceID."</b></td><td align='left'><b>".$domName."</b></td><td align='left'><b>".$status."</b></td></tr></table></div><br/>";
				$i++;
				
				$adminActionDataStr					= serialize($adminActionData);

				$params =array(
				'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Status', 'adminActionObject'=>'License', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
				);
				$ObjAdminlog->insertAdminlog($params);
				/* End Adminlog */
			}
		}
		else
		{
			$changeStatus = $ObjLicense->changeStatus($params);
			$this->setMessage('language.lblLicensestatusUpdatedSuccess','success');
			/* Adminlog */
			$adminAccessIP						= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "Updated The Status";
			$adminActionData[$i]['response']	= "Licensed Domain Status Updated Successfully";
			$adminActionData[$i]['message']		= "Updated Status of Licensed Domain<br/>";
			$adminActionData[$i]['message']		.= "<div class='grid_table00'>
			<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>LicenceID</td><td width='50%' height='15%' align='left'>Domain Name</td><td width='30%' height='15%' align='left'>Domain Status</td></tr><tr><td align='left'><b>".$licenceID."</b></td><td align='left'><b>".$domName."</b></td><td align='left'><b>".$status."</b></td></tr></table></div><br/>";
			$i++;
			
			$adminActionDataStr					= serialize($adminActionData);

			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Status', 'adminActionObject'=>'License', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
		}

	}

	public function destroyAction()    
	{
		$licenceID  	=   $this->getRequestValue('id');
		$licenseIDs		=	array($licenceID);
		$name			= 	$this->getRequestValue('name');
		$adminId		= 	$this->ObjCommon->manageUserID; 
		$ObjAdminlog	= 	new AdminlogModel();
		if(isset($licenceID)){
			$ObjLicense    	= 	new LicenseModel();
			$params=array(
				'status'=>'Deleted',
				'licenceIDs'=>array($licenceID)
			);
			$licenseUsed	= $ObjLicense->checkLicenseParent($licenseIDs);
			if(count($licenseUsed)>0)
			{
				$this->setMessage('language.lblLicenseNotUpdate','message_info');
				/* Adminlog */
				$adminAccessIP		= $this->ObjCommon->getClientIP();
				$i									= 0;
				$adminActionData					= array();
				$adminActionData[$i]['status']		= "Delete Failed";
				$adminActionData[$i]['response']	= "License Have Active Sub Domains, So Cannot Change its Status";
				$adminActionData[$i]['message']		= "No Changes Found For Domain: <b>".$name."</b>";
				$i++;
				$adminActionDataStr					= serialize($adminActionData);
				$params =array(
				'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Delete', 'adminActionObject'=>'License', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
				);
				$ObjAdminlog->insertAdminlog($params);
				/* End Adminlog */
			}
			else
			{
				$changeStatus = $ObjLicense->changeStatus($params);
				$this->setMessage('language.lblLicensedeletedSuccess','success');
				/* Adminlog */
				$adminAccessIP						= $this->ObjCommon->getClientIP();
				$i									= 0;
				$adminActionData					= array();
				$adminActionData[$i]['status']		= "Deleted";
				$adminActionData[$i]['response']	= "Licensed Domain  Deleted Successfully";
				$adminActionData[$i]['message']		= "Deleted Licensed Domain<br/>";
				$adminActionData[$i]['message']		.= "<div class='grid_table00'>
				<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>LicenceID</td><td width='50%' height='15%' align='left'>Domain Name</td><td width='30%' height='15%' align='left'>Domain Status</td></tr><tr><td align='left'><b>".$licenceID."</b></td><td align='left'><b>".$name."</b></td><td align='left'><b>Deleted</b></td></tr></table></div><br/>";
				$i++;
				
				$adminActionDataStr					= serialize($adminActionData);

				$params =array(
				'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Delete', 'adminActionObject'=>'License', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
				);
				$ObjAdminlog->insertAdminlog($params);
				/* End Adminlog */
			}
			$this->setRedirect('license/index/');
			
		}
	}
	
	/* PDF Download */
	public function ajaxDownloadAction()
	{
		 $licenseFile	= 'licensedetail.pdf';
		 $licenceID		= $this->getRequestValue('id');	
		 $content		= $this->generatePdfContent($licenceID);
         return $this->createpdfAction($content, $licenseFile, $stream, true);		
	}
	
	 /* CREATE PDF FUNCTION */
    public function createpdfAction($content, $fileName = 'licensedetail.pdf', $stream = true, $attachment = false) 
	{
		$pdfLib = new Pdf();
		ob_end_clean();
		$pdf = new TCPDF('L', PDF_UNIT, 'A4', true, 'UTF-8', false);
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor('');
		$pdf->SetTitle('');
		$pdf->SetSubject('');
		$pdf->SetKeywords('');
		$pdf->setPrintHeader(false);
		$pdf->setPrintFooter(false);
		//set margins
		$pdf->SetMargins(PDF_MARGIN_LEFT, 10, PDF_MARGIN_RIGHT);
		$pdf->setLanguageArray($l);
		// add a page
		$pdf->AddPage();		
		$pdf->SetFont('dejavusans', '', 10);
		// output the HTML content			
  		$pdf->WriteHTML('<style> h1{font:bold 15pt Arial, Helvetica, sans-serif;color: #333333;margin:0;}</style>'.$content);
	  	$pdf->Output($fileName, 'D');
		exit;
    }
    //END OF FUNCTION
	
	/* Generate pdf content */ 
	public function generatePdfContent($licenceID) 
	{
		$ObjLicense    	= new LicenseModel();
		$languageIDs    = $this->ObjView->languageIDs;
		$params=array(
			'licenceID'=>$licenceID,
			'languageIDs'=>$languageIDs
		);
		$getLicense		= $ObjLicense->getLicenseDetails($params);	
		$getLicenseSub	= $ObjLicense->getLicenseSub($params);
    $content	= '<table border="0" cellpadding="0" cellspacing="10" style="border:1px solid #666666;text-align:left;" width="100%">
	<tbody>
		<tr>
			<td align="center" valign="top"><img src="http://www.oorjit.com/signature-logo.jpg" alt="LOGO" height="70" /></td>
		</tr>
		<tr>
			<td>
			<table align="center" border="0" cellpadding="0" cellspacing="0"  width="96%">
				<tbody>
					
					<tr>
						<td align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">Thank you for purchasing Oorjit '.$this->encryptDecrypt("decrypt",$getLicense['packageName']).' package. To get started, see the license details of your package below:<br/></td>
					</tr>
					
						
					<tr>
						<td align="left" valign="top">
                        	<table width="100%" border="0" cellspacing="2" cellpadding="2" >
										  <tr>
											<td colspan="2" align="left" valign="top" bgcolor="#F5F5F5" style="font-family:Arial, Helvetica, sans-serif; font-size:13pt; color:#666666;padding:5pt;"><strong>Customer Info:</strong></td>
										  </tr>
										  <tr>
											<td width="23%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">Name</td>
											<td width="77%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:12pt; color:#666666;">'.$this->encryptDecrypt("decrypt",$getLicense['customerFirstName']).' '.$this->encryptDecrypt("decrypt",$getLicense['customerLastName']).'</td>
										  </tr>
										  <tr>
											<td width="23%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">Address</td>
											<td width="77%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:12pt; color:#666666;">'.
											$getLicense['customerAddress1'].', '.$getLicense['customerAddress2'].', <br/>'.$getLicense['customerCity'].', '.$getLicense['stateName'].' '.$getLicense['countryName'].' - '.$getLicense['customerPincode']
											.'</td>
										  </tr>
										  <tr>
											<td width="23%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">Email</td>
											<td width="77%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:12pt; color:#666666;">'.$this->encryptDecrypt("decrypt",$getLicense['customerEmailID']).'</td>
										  </tr>
										  <tr>
											<td width="23%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">Phone</td>
											<td width="77%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:12pt; color:#666666;">'.$this->encryptDecrypt("decrypt",$getLicense['customerPhone']).'</td>
										  </tr>
										</table>
                        </td>
					</tr>
					<tr>
						<td height="5" align="left" valign="top"></td>
					</tr>
					<tr>
						<td height="5" align="left" valign="top" style="border-top:1px dashed #666666;"></td>
					</tr>
					<tr>
						<td align="left" valign="top"><table width="100%" border="0" cellspacing="2" cellpadding="2" >
						  <tr>
						   <td colspan="2" align="left" valign="top" bgcolor="#F5F5F5" style="font-family:Arial, Helvetica, sans-serif; font-size:13pt; color:#666666;padding:5pt;"><strong>Order Info:</strong></td>
					      </tr>
						  <tr>
						    <td width="23%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">Package Name</td>
						    <td width="77%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:12pt; color:#666666;">'.$this->encryptDecrypt("decrypt",$getLicense['packageName']).' '.$getLicense['packageVersion'].'</td>
					      </tr>
						  <tr>
						    <td width="23%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">Order Date</td>
						    <td width="77%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:12pt; color:#666666;">'.$getLicense['createDate'].'</td>
					      </tr>
						  <tr>
						    <td width="23%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">Order ID/Project ID</td>
						    <td width="77%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:12pt; color:#666666;">'.$getLicense['orderID'].'</td>
					      </tr>
					    </table></td>
					</tr>
					<tr>
						<td height="5" align="left" valign="top"></td>
					</tr>
					<tr>
						<td height="5" align="left" valign="top" style="border-top:1px dashed #666666;"></td>
					</tr>
					<tr>
						<td align="left" valign="top"><table width="100%" border="0" cellspacing="2" cellpadding="2" >
						  <tr>
						    <td colspan="2" align="left" valign="top" bgcolor="#F5F5F5" style="font-family:Arial, Helvetica, sans-serif; font-size:13pt; color:#666666;padding:5pt;"><strong>License Info:</strong></td>
					      </tr>
						  <tr>
						    <td width="23%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">Domain name</td>
						    <td width="77%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:12pt; color:#666666;">'.$getLicense['domainName'].'</td>
					      </tr>
						  <tr>
						    <td width="23%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">License Key</td>
						    <td width="77%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:12pt; color:#666666;">'.base64_decode($getLicense['licenceKey']).'</td>
					      </tr>
						  <tr>
						    <td width="23%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">Domain Key</td>
						    <td width="77%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:12pt; color:#666666;">'.$this->encodeDm($getLicense['domainName']).'</td>
					      </tr>
					    </table></td>
					</tr>';
        if($getLicenseSub!="")
		{
			for($i=0;$i<count($getLicenseSub);$i++)
			{
				$content.= 	'<tr>
						<td align="left" valign="top"><table width="100%" border="0" cellspacing="2" cellpadding="2" >
						  <tr>
						    <td colspan="2" align="left" valign="top" bgcolor="#F5F5F5" style="font-family:Arial, Helvetica, sans-serif; font-size:13pt; color:#666666;padding:5pt;"><strong>License Info [Dev]:</strong></td>
					      </tr>
						  <tr>
						    <td width="23%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">Domain name</td>
						    <td width="77%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:12pt; color:#666666;">'.$getLicenseSub[$i]['domainName'].'</td>
					      </tr>
						  <tr>
						    <td width="23%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">License Key</td>
						    <td width="77%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:12pt; color:#666666;">'.base64_decode($getLicenseSub[$i]['licenceKey']).'</td>
					      </tr>
						  <tr>
						    <td width="23%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">Domain Key</td>
						    <td width="77%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:12pt; color:#666666;">'.$this->encodeDm($getLicenseSub[$i]['domainName']).'</td>
					      </tr>
						</table></td>
					</tr>';
			}
		}
		if($getLicense['parentDomain']>0)
		{
			$params2=array(
				'licenceID'=>$getLicense['parentDomain'],
				'languageIDs'=>$languageIDs
			);
			$getLicense2	= $ObjLicense->getLicenseDetails($params2);	
			$content.= 	'<tr>
						<td align="left" valign="top"><table width="100%" border="0" cellspacing="2" cellpadding="2" >
						  <tr>
						    <td colspan="2" align="left" valign="top" bgcolor="#F5F5F5" style="font-family:Arial, Helvetica, sans-serif; font-size:13pt; color:#666666;padding:5pt;"><strong>License Info [Main]:</strong></td>
					      </tr>
						  <tr>
						    <td width="23%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">Domain name</td>
						    <td width="77%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:12pt; color:#666666;">'.$getLicense2['domainName'].'</td>
					      </tr>
						  <tr>
						    <td width="23%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">License Key</td>
						    <td width="77%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:12pt; color:#666666;">'.base64_decode($getLicense2['licenceKey']).'</td>
					      </tr>
						  <tr>
						    <td width="23%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">Domain Key</td>
						    <td width="77%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:12pt; color:#666666;">'.$this->encodeDm($getLicense2['domainName']).'</td>
					      </tr>
						</table></td>
					</tr>';
			$getLicenseSub2	= $ObjLicense->getLicenseSub($params2);
			if($getLicenseSub2!="")
			{
				for($j=0;$j<count($getLicenseSub2);$j++)
				{
					if($getLicenseSub2[$j]['domainName']!=$getLicense['domainName'])
					{
						$content.= 	'<tr>
								<td align="left" valign="top"><table width="100%" border="0" cellspacing="2" cellpadding="2" >
								  <tr>
									<td colspan="2" align="left" valign="top" bgcolor="#F5F5F5" style="font-family:Arial, Helvetica, sans-serif; font-size:13pt; color:#666666;padding:5pt;"><strong>License Info [Dev]:</strong></td>
								  </tr>
								  <tr>
									<td width="23%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">Domain name</td>
									<td width="77%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:12pt; color:#666666;">'.$getLicenseSub2[$j]['domainName'].'</td>
								  </tr>
								  <tr>
									<td width="23%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">License Key</td>
									<td width="77%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:12pt; color:#666666;">'.base64_decode($getLicenseSub2[$j]['licenceKey']).'</td>
								  </tr>
								  <tr>
									<td width="23%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">Domain Key</td>
									<td width="77%" align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:12pt; color:#666666;">'.$this->encodeDm($getLicenseSub2[$j]['domainName']).'</td>
								  </tr>
								</table></td>
							</tr>';
					}
				}
			}
		}
		$content.= 	'<tr>
						<td height="5" align="left" valign="top" style="border-top:1px dashed #666666;"></td>
					</tr>
					<tr>
						<td align="left" valign="top" style="font-family:Arial, Helvetica, sans-serif; font-size:11pt; color:#666666;">
						Sincerely,<br />
										  <strong>Oorjit Customer Support Team </strong>
						</td>
					</tr>
                   
				</tbody>
			</table>
			</td>
		</tr>
	</tbody>
</table>';
		return $content;
	}
	
	/* Check Domain name Already Exist Before License Add */
	public function licenseExist()
	{
		$licenseID 	= $this->getRequestValue('id');
		$ObjLicense    	= new LicenseModel();
		$licenseExist	= $ObjLicense->checkLicenseExist($licenseID);
		if(count($licenseExist)>0)
		{
			return false;
		}
		return true;
	}
	
	/* Tracked Site Access Updation */
	public function ajaxtrackedAction()    
	{
		$ObjLicense    		= new LicenseModel();
		$ObjAdminlog		= new AdminlogModel();
		$adminId			= $this->ObjCommon->manageUserID; 
		$languageIDs		= $this->ObjView->languageIDs;		
		$status 			= $_POST['status'];
		$licenceIDs 		= $_POST['licenceIDs'];
		$updateAccessTrack	= $ObjLicense->updateAccessTrack($licenceIDs,$status);
		$this->setMessage('language.lblLicenseAccessUpdatedSuccess','success');
		/* Adminlog */
		$adminAccessIP						= $this->ObjCommon->getClientIP();
		$i									= 0;
		$adminActionData					= array();
		$adminActionData[$i]['status']		= "Updated The Site Access";
		$adminActionData[$i]['response']	= "Tracked Install Access Updated Successfully";
		$adminActionData[$i]['message']		= "Updated Tracked Access Details of Licensed Domains<br/>";
		$adminActionData[$i]['message']		.= "<div class='grid_table00'>
		<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>LicenceID</td><td width='50%' height='15%' align='left'>Domain Name</td><td width='30%' height='15%' align='left'>Access Status</td></tr>";
		for($s=0;$s<count($licenceIDs);$s++)
		{
			$adminActionData[$i]['message']		.= "<tr><td align='left'><b>".$licenceIDs[$s]."</b></td><td align='left'><b>".$_POST['domName'][$s]."</b></td><td align='left'><b>Yes</b></td></tr>";
		}
		$adminActionData[$i]['message']		.= "</table></div><br/>";
		$i++;
		
		$adminActionDataStr					= serialize($adminActionData);
		$actionObject	= "License ".$status;
		$params =array(
		'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Access Track', 'adminActionObject'=>$actionObject, 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
		);
		$ObjAdminlog->insertAdminlog($params);
		/* End Adminlog */
	}
	public function cronLicensesAction()    
	{
		$ObjLicense    	= new LicenseModel();
		$languageIDs	= $this->ObjView->languageIDs;
		$ObjLicense->encodeSiteLicenses();
		
	}
}
