<?php
/***************************************************************************
 *                                                                          *
 * Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
 *                                                                          *
 * This  is  commercial  software,  only  users  who have purchased a valid *
 * license  and  accept  to the terms of the  License Agreement can install *
 * and use this program.                                                    *
 *                                                                          *
 ****************************************************************************
 * PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
 * "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
 ****************************************************************************/
//
//$Id: CustomerController, v 1.0 2014/05/02 12:11:15
//
class LicenserequestController extends Controller 
{
	/* License Request List Index Action */
	public function indexAction()    
	{
		$ObjLicenseReq 	= new LicenserequestModel();
		$languageIDs	= $this->ObjView->languageIDs;	
		$adminId		= $this->ObjCommon->manageUserID; 
		$branchCodeSes	= $this->ObjCommon->manageBranchCode;
		$transID		= $this->ObjCommon->transSession;
		$ObjAdmin	 	= new AdminuserModel();
		$resBranches	= $ObjAdmin->listBranchCodes();
		$this->ObjView->assign('resBranches', $resBranches);
		$ObjAdminlog	= new AdminlogModel();		
		if (isset($_POST['select_status']))
		{
			if(($transID=="") || ($transID!=$adminId))
			{
				$this->setRedirect("adminuser/transPwd/urlback/ajax/ctrlpath/licenserequest/");
			}
			else
			{
				$domainNames		= array();
				$requestIDs			= array();
				foreach($_POST['requestID'] as $key=>$licenseValues)
				{
					$domainNames[]	= $key;
					$requestIDs[]	= $licenseValues[0];
				}
				$ObjLicense			=	new LicenseModel();
				$params=array(
					'status'=>$_POST['select_status'],
					'requestIDs'=>$requestIDs
				);
				$ObjLicenseReq->changeStatus($params);
				$this->setMessage('language.lblLicensestatusUpdatedSuccess','success');
				$reqIDStr		= implode(",",$requestIDs);
				$licNameStr		= implode(",",$domainNames);
				/* Adminlog */
				$adminAccessIP						= $this->ObjCommon->getClientIP();
				$i									= 0;
				$adminActionData					= array();
				$adminActionData[$i]['status']		= "Updated The Status";
				$adminActionData[$i]['response']	= "License Request Bulk Status Updated Successfully";
				$adminActionData[$i]['message']		= "Updated Status of requestIDs: ".$reqIDStr." With DomainNames ".$licNameStr." Respectively To ".$_POST['select_status'];
				$i++;
				
				$adminActionDataStr					= serialize($adminActionData);

				$params =array(
				'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'LicenseRequest', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
				);
				$ObjAdminlog->insertAdminlog($params);
				/* End Adminlog */
				$this->setRedirect();
			}
		}
		$link	=	'licenserequest/index/';
		if (isset($_POST['search']))
		{		
			if ($_POST['customerID'] != ""){
				$link .= "customerID/" . $_POST['customerID'] . "/";
			}			
			if ($_POST['domainName'] != ""){
				$link .= "domainName/" . $this->encodeUrlString($_POST['domainName']) . "/";
			}						
			if ($_POST['packageKey'] != ""){
				$link .= "packageKey/" . $this->encodeUrlString($_POST['packageKey']) . "/";
			}			
			if ($_POST['packageVersion'] != ""){
				$link .= "packageVersion/" . $_POST['packageVersion'] . "/";
			}					
			if ($_POST['packageName'] != ""){
				$link .= "packageName/" . $this->encodeUrlString($_POST['packageName']) . "/";
			}				
			if ($_POST['requeststatus1'] != ""){
				$link .= "requeststatus1/" . $this->encodeUrlString($_POST['requeststatus1']) . "/";
			}			
			if ($_POST['branchCode'] != ""){
				$link .= "branchCode/" . $_POST['branchCode'] . "/";
			}
			if ($_POST['requestDate'] != ""){
				list($fromDate, $toDate) = split(' - ', $_POST['requestDate']);
				$link .= (($fromDate != "") ? "from/" . $this->urlDate($fromDate, 'set', $settingsDateFormat) . "/" :"");
				$link .= (($toDate != "") ? "to/" . $this->urlDate($toDate, 'set', $settingsDateFormat) . "/" :"");
			}	
			$this->setRedirect($link);
		}
		else
		{
			$sortby		=	$this->getRequestValue("sortby");
			$orderby	=	($this->getRequestValue("orderby")=="")?"asc":$this->getRequestValue("orderby");
					
			if($this->getRequestValue('customerID')){
				$customerID		= 	$this->getRequestValue('customerID');
				$link.="customerID/".$customerID. "/";
			}			
			if($this->getRequestValue('domainName')){
				$domainName		= 	$this->decodeUrlString($this->getRequestValue('domainName'));
				$link.="domainName/".$domainName. "/";
			}						
			if($this->getRequestValue('packageKey')){
				$packageKey		= 	$this->decodeUrlString($this->getRequestValue('packageKey'));
				$link.="packageKey/".$packageKey. "/";
			}			
			if($this->getRequestValue('packageVersion')){
				$packageVersion		= 	$this->getRequestValue('packageVersion');
				$link.="packageVersion/".$packageVersion. "/";
			}						
			if($this->getRequestValue('packageName')){
				$packageName		= 	$this->decodeUrlString($this->getRequestValue('packageName'));
				$link.="packageName/".$packageName. "/";
			}							
			if($this->getRequestValue('requeststatus1')){
				$requeststatus1		= 	$this->decodeUrlString($this->getRequestValue('requeststatus1'));
				$link.="requeststatus1/".$requeststatus1. "/";
			}			
			if($this->getRequestValue('branchCode')){
				$branchCode		= 	$this->getRequestValue('branchCode');
				$link.="branchCode/".$branchCode. "/";
			}	
			if($this->getRequestValue('from')){
				$fromDate 		= $this->urlDate($this->getRequestValue('from'), 'get', $settingsDateFormat);
				$link .= (($fromDate != "") ? "from/" . $this->urlDate($fromDate, 'set', $settingsDateFormat) . "/" :"");
			}
			if($this->getRequestValue('to')){
				$toDate 		= $this->urlDate($this->getRequestValue('to'), 'get', $settingsDateFormat);
				$link .= (($toDate != "") ? "to/" . $this->urlDate($toDate, 'set', $settingsDateFormat) . "/" :	"");
			}
		}
		list($limitFrom, $limitTo) = $this->getPageSettings($key = 'page', $rows = 10); 
		
		/*assigning from and to values for search*/
		$assignFromDate =  $fromDate; 
        $assignToDate = $toDate;
        if (!$toDate && $fromDate){
           	 $toDate   = $fromDate; 
       	}
		$fromDate	= $this->convertDateForSQL($fromDate, $settingsDateFormat);
		$toDate		= $this->convertDateForSQL($toDate, $settingsDateFormat);
        /*assigning from and to values for search*/
		
		$params =array(
			'limitFrom'=>$limitFrom,
			'limitTo'=>$limitTo,
			'languageIDs'=>$languageIDs,
			'sortby'=>$sortby,
			'orderby'=>$orderby,
			'customerID'=>$customerID ,'domainName'=>$domainName ,'packageKey'=>$packageKey ,'packageVersion'=>$packageVersion ,'packageName'=>$packageName ,'fromDate'=>$fromDate , 'toDate'=>$toDate ,'requeststatus1'=>$requeststatus1 ,'branchCode'=>$branchCode, 'adminId'=>$adminId, 'branchCodeSes'=>$branchCodeSes  
		);
		
		$resPagesCount = $this->setPagesCount($key = 'page');
		$this->ObjView->assign("page", $page);	
		$this->ObjView->assign("sortby", $sortby); $this->ObjView->assign("orderby", ($orderby=="asc")?'desc':'asc'); $this->ObjView->assign("customerID", $customerID); $this->ObjView->assign("domainName", $domainName); $this->ObjView->assign("packageKey", $packageKey); $this->ObjView->assign("packageVersion", $packageVersion); $this->ObjView->assign("requeststatus1", $requeststatus1); $this->ObjView->assign("branchCode", $branchCode);
		if($assignFromDate && $assignToDate==''){
			$this->ObjView->assign('requestDate', $assignFromDate);
		}else if($assignFromDate && $assignToDate){
			$this->ObjView->assign('requestDate', $assignFromDate.' - '.$assignToDate);
		}else{
			$this->ObjView->assign('requestDate','');
		}
		
		$listRequest    = $ObjLicenseReq->listLicenseRequest($params);
		$this->ObjView->assign('listRequest', $listRequest);
		$editPrivilege	=	$this->ObjCommon->hasPrivilege('license/edit/');
		$this->ObjView->assign("editPrivilege", $editPrivilege);
		$deletePrivilege	=	$this->ObjCommon->hasPrivilege('license/destroy/');
		$this->ObjView->assign("deletePrivilege", $deletePrivilege);
		
		$this->ObjView->assign("link", $link);
		$this->ObjView->display('LicenseRequestList.tpl');
	}
	
	/* To List Customer in ajax search */
	public function ajaxListUserAction()
	{	
		$customerName 		= $this->getRequestValue('customerName');
		$customerEmail 		= $this->getRequestValue('customerEmail');
		$this->ObjView->assign("customerName", $customerName);
		$this->ObjView->assign("customerEmail", $customerEmail);
		$this->ObjView->assign("editprivilage", $editprivilage);
        $this->ObjView->display('ListCustomerAjax.tpl');
	}
	
	/* Ajax Search Customer */
	public function ajaxSearchCustomerAction()
	{
		$ObjLicenseReq 	= new LicenserequestModel();
		$languageIDs	= $this->ObjView->languageIDs;	
		$customerEmail			= $_POST['customerEmail'];
		$name			= $_POST['Name'];
		$domainName		= $_POST['domainName1'];
		$packageKey		= $_POST['packageName1'];
		$packageName	= $_POST['packageName1'];
		$params =array(
			'languageIDs'=>$languageIDs,
			'customerID'=>$name ,'domainName'=>$domainName ,'packageKey'=>$packageKey ,'packageVersion'=>$packageVersion ,'packageName'=>$packageName ,'customerEmailID'=>$customerEmail
		);
		$customer		= $ObjLicenseReq->listLicense($params);
		$dateFormat     = $this->getSettingValue('site_settings', 'date_format');
		$this->ObjView->assign('date_format', $dateFormat);
		$this->ObjView->assign('customer', $customer);
		$this->ObjView->assign('type', 'list');
		$html 			= $this->ObjView->fetch('ListCustomerAjax.tpl');
		$returnData['html'] = $html;
		echo json_encode($returnData);
		exit;
	}
	
	/* Ajax update Customer to request form */
	public function ajaxUpdateCustomerAction()
	{
		$ObjCustomer 	= new CustomerModel();
		$customerID		= $_POST['customerID'];
		$params =array(
			'languageIDs'=>$languageIDs,
			'customerID'=>$customerID
		);
		$custDetails	= $ObjCustomer->getCustomer($params);
		if($custDetails['customerID']>0)
		{
			$custDetails['isError']='No';
			$custDetails['message']=$this->getLanguageValue('lblUserFound');
			echo json_encode($custDetails);
			exit;
		}
	}
	
	/* Ajax Search Customer AutoComplete */
	public function ajaxCustomerAutoAction()
	{
		$ObjLicenseReq 	= new LicenserequestModel();
		$languageIDs	= $this->ObjView->languageIDs;	
		// no term passed - just exit early with no response
		if (empty($_GET['term'])) exit ;
		//$q = strtolower($_GET["term"]);
		// remove slashes if they were magically added
		//if (get_magic_quotes_gpc()) $q = stripslashes($q);
		$term			= $this->escape($_GET['term']);
		$type			= $this->escape($_GET['type']);
		$params =array(
			'languageIDs'=>$languageIDs,'term'=>$term ,'type'=>$type
		);
		$customer		= $ObjLicenseReq->listLicense($params);

		$result = array();
		foreach ($customer as $key=>$value) 
		{
			
			$label	= $value['customerFirstName']." ".$value['customerLastName']." ".$value['customerEmailID']." ".$value['customerPhone'];
			//if (strpos(strtolower($value['customerFirstName']), $q) !== false) {
			if($type=="customerName")
			{
				array_push($result, array("id"=>$value['customerID'], "label"=>$label, "value" => $value['customerFirstName'], "data" => $value));
			}
			else if($type=="customerEmailID")
			{
				array_push($result, array("id"=>$value['customerID'], "label"=>$label, "value" => $value['customerEmailID'], "data" => $value));
			}
			else if($type=="customerPhone")
			{
				array_push($result, array("id"=>$value['customerID'], "label"=>$label, "value" => $value['customerPhone'], "data" => $value));
			}
			//}
			/* if (count($result) > 11)
				break; */
		}
		echo json_encode($result);
		exit;
	}
	
	/* License Request Add */
	public function newAction()    
	{
		$ObjCustomer    		= new CustomerModel();
		$ObjCountry     		= new CountryModel();
		$ObjLicense    			= new LicenseModel();
		$languageIDs        	= $this->ObjView->languageIDs;
		$adminId				= $this->ObjCommon->manageUserID; 
		$branchCodeSes			= $this->ObjCommon->manageBranchCode;
		$ObjLicensereq    		= new LicenserequestModel();
		$resListCountryOptions  = $ObjCountry->listCountries($languageIDs,'');
		$ObjPackage		= new PackageModel();
		$resPackage		= $ObjPackage->listPackageOptions();
                foreach($resPackage as $key=>$value) {
			$resPackage[$key][1] = $this->encryptDecrypt("decrypt",$value['packageName']);
		}
		$this->ObjView->assign('resPackage', $resPackage); 
		$resParent		= $ObjLicense->getParentLicense();
		$resParent = array_merge(array('0'=>array('0'=>'0','licenceID' => '0','1'=>'Root Level','domainName'=>'Root Level')), $resParent);
		foreach($resParent as $key=>$value) {
			$resParent[$key]['domainName'] = $this->encryptDecrypt("decrypt",$value['domainName']);
                        $resParent[$key]['1'] = $this->encryptDecrypt("decrypt",$value['1']);
		}
                $this->ObjView->assign('resParent', $resParent);
		$ObjAdminlog	= new AdminlogModel();
		if($this->ObjForm->isValid('formLicenseReq','submitLicenseReq'))
		{ 
			$ObjLicensereq->insert($languageIDs,$adminId,$branchCodeSes);
			$this->setMessage('language.lblLicensereqaddedSuccess','success');
			/* Adminlog */
			$adminAccessIP						= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "New";
			$adminActionData[$i]['response']	= "Successfully Added";
			$i++;
			
			if(isset($_POST['parentDomain']))
			{
				if($_POST['parentDomain']==0)
				{
					$parentName	= "Root Level";
				}
				else
				{
					foreach ($resParent as $key => $value) 
					{
					   if ($value['licenceID'] == $_POST['parentDomain']) 
					   {
						   $parentName	= $resCustomer[$key]['domainName'];
					   }
					}
				}
			}
			
			$adminActionData[$i]['field']	= "CustomerFirstName";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['customerFirstName'];
			$i++;

			$adminActionData[$i]['field']	= "CustomerLastName";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['customerLastName'];
			$i++;
			
			$adminActionData[$i]['field']	= "CustomerEmailID";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['customerEmailID'];
			$i++;

			$adminActionData[$i]['field']	= "CustomerPhone";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['customerPhone'];
			$i++;
			
			$adminActionData[$i]['field']	= "CustomerAddress1";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['customerAddress1'];
			$i++;


			$adminActionData[$i]['field']	= "CustomerStatus";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['customerStatus'];
			$i++;
			
			$adminActionData[$i]['field']	= "DomainName";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['domainName'];
			$i++;

			$adminActionData[$i]['field']	= "PackageKey";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['packageKey'];
			$i++;
			
			$adminActionData[$i]['field']	= "PackageVersion";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['packageVersion'];
			$i++;
			
			$adminActionData[$i]['field']	= "LicenseType";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['licenseType'];
			$i++;

			$adminActionData[$i]['field']	= "ParentDomain";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $parentName;
			$i++;
			
			if($_POST['licenseType']=="Developer")
			{
				$adminActionData[$i]['field']	= "Expiry";
				$adminActionData[$i]['Old']		= "";
				$adminActionData[$i]['New']		= $_POST['expiry'];
				$i++;
			}

			$adminActionDataStr				= serialize($adminActionData);

			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'New', 'adminActionObject'=>'LicenseRequest', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
			
			$ObjEmailtemplate	= new EmailtemplateModel();
			$languageIDs		= $this->ObjView->languageIDs;		
			$mail_settings   	= $this->getSettingValue('mail_settings');
			$ObjMail          	= new Mail($mail_settings);
			$companyLogo   		= $this->getSettingValue('company_information', 'company_logo');
			$siteName      		= $this->getSettingValue('site_settings', 'site_name');
			$siteUrl       		= $this->getSettingValue('site_settings', 'global_http_url');
			$emailTempDet     	= $ObjEmailtemplate->getEmailTemlateDetails($languageIDs, '', 'deal-request-received');
			$fromEmailName 		= $emailTempDet['emailFromName'];
			$fromEmailId   		= $emailTempDet['emailFromEmail'];
			$Subject       		= $emailTempDet['emailSubject'];
			$Body          		= $emailTempDet['emailHtml'];
			$this->ObjView->assign('emailBottom',$emailBottom);						
			$this->ObjView->assign('companyLogo', $companyLogo);
			$this->ObjView->assign('siteName', $siteName);
			$this->ObjView->assign('siteUrl', $siteUrl);
			$ObjAdminuser		= new AdminuserModel();
			$resAdminDetails   	= $ObjAdminuser->getAdminDetails('1','','','','','');
			$adminEmailID		= $resAdminDetails['adminUserEmail'];
			$adminName			= $resAdminDetails['adminUserFirstName'].''.$resAdminDetails['adminUserLastName'];
			$customerName  		= $_POST['customerFirstName'].' '.$_POST['customerLastName'];
			$Body         		= str_replace('{$domainName}', $_POST['domainName'], $Body);
			$Body         		= str_replace('{$customerFirstName}', $_POST['customerFirstName'], $Body);
                        $Body         		= str_replace('{$customerLastName}', $_POST['customerLastName'], $Body);
			$Body         		= str_replace('{$customerEmail}', $_POST['customerEmailID'], $Body);
			$Body         		= str_replace('{$customerPhone}', $_POST['customerPhone'], $Body);
			$Body         		= str_replace('{$orderID}', $_POST['orderID'], $Body); 	
                        $Body         		= str_replace('{$customerAddress}', $_POST['customerAddress1'].' '.$_POST['customerAddress2'], $Body);
                        $Body         		= str_replace('{$orderDate}', date('d/m/Y'), $Body);
			$Body         		= str_replace('{$licenseType}', $_POST['licenseType'], $Body);
			$Body				.= "<br/>".$_POST['mailContent'];
			
			$this->ObjView->assign('emailbody', $Body);
			$email_body = $this->ObjCommon->fetch("email_templates/Layout.tpl",$languageIDs);
			$ObjMail->IsHTML();
			$send      					= $ObjMail->sendMail(array(
																	$fromEmail,
																	$fromName
																	), 
															 array(
																	array(
																			$adminEmailID,
																			$adminName
																		 )
															
																  ),$Subject, $email_body);
			if (!$ObjMail->Send()) 
			{
				$message					.= '<br>Sending failed for '.$adminEmailID;	
			}

			$ObjMail->clearAddresses();
		
			$this->setRedirect('licenserequest/index/');
		} 
		else
		{
			if(isset($_POST['submitLicense']))
			{
				if(!$this->ObjForm->isValid('formLicense','submitLicense'))
				{
					/* Adminlog */
					$adminAccessIP		= $this->ObjCommon->getClientIP();
					$i									= 0;
					$adminActionData					= array();
					$adminActionData[$i]['status']		= "Insert Failed";
					$adminActionData[$i]['response']	= "Error found in form element";
					$adminActionData[$i]['message']		= "Data Cannot Be Added";
					$i++;
					$adminActionDataStr					= serialize($adminActionData);
					$params =array(
					'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'New', 'adminActionObject'=>'LicenseRequest', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
					);
					$ObjAdminlog->insertAdminlog($params);
					/* End Adminlog */
				}
			}
		}
		$this->ObjView->assign('resParentJson', json_encode($resParent));
		$this->ObjView->assign('resCountry', $resListCountryOptions);
		$this->ObjView->display('LicenseRequestForm.tpl');
	}
	
	public function ajaxstatusAction()    
	{
		$requestID 		= $this->getRequestValue('id');
		$status			= $this->getRequestValue('status');
		$domName		= $this->getRequestValue('domName');
		$ObjLicensereq	= new LicenserequestModel(); 
		$ObjAdminlog	= new AdminlogModel();
		$params=array(
			'status'=>$status,
			'requestIDs'=>array($requestID)
		);
		$changeStatus = $ObjLicensereq->changeStatus($params);
		$this->setMessage('language.lblLicensestatusUpdatedSuccess','success');
		/* Adminlog */
		$adminAccessIP						= $this->ObjCommon->getClientIP();
		$i									= 0;
		$adminActionData					= array();
		$adminActionData[$i]['status']		= "Updated The Status";
		$adminActionData[$i]['response']	= "License Request Status Updated Successfully";
		$adminActionData[$i]['message']		= "Updated The Status Of, RequestID: ".$requestID." With Domain Name: ".$domName." To The Status ".$status;
		$i++;
		
		$adminActionDataStr					= serialize($adminActionData);

		$params =array(
		'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Status', 'adminActionObject'=>'License', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
		);
		$ObjAdminlog->insertAdminlog($params);
		/* End Adminlog */

	}

	public function destroyAction()    
	{
		$requestID  =   $this->getRequestValue('id');
		$domName	=   $this->getRequestValue('domName');
		$ObjAdminlog	= new AdminlogModel();
		if(isset($requestID))
		{
			$ObjLicensereq	= new LicenserequestModel();
			$params=array(
				'status'=>'Deleted',
				'requestIDs'=>array($requestID)
			);
			$changeStatus = $ObjLicensereq->changeStatus($params);
			$this->setMessage('language.lblLicensedeletedSuccess','success');
			/* Adminlog */
			$adminAccessIP						= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "Deleted";
			$adminActionData[$i]['response']	= "License Request  Deleted Successfully";
			$adminActionData[$i]['message']		= "Changes Found, License Request With RequestID: ".$requestID." With Domain Name: ".$domName." Deleted";
			$i++;
			
			$adminActionDataStr					= serialize($adminActionData);

			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Delete', 'adminActionObject'=>'LicenseRequest', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
			$this->setRedirect('licenserequest/index/');
			
		}
	}
	
	public function viewAction()    
	{
		$requestID  		= $this->getRequestValue('id');
		$ObjLicenseReq    	= new LicenserequestModel();
		$languageIDs        = $this->ObjView->languageIDs;
		$adminId		= $this->ObjCommon->manageUserID; 
		$branchCodeSes	= $this->ObjCommon->manageBranchCode;
		$params=array(
			'requestID'=>$requestID,
			'languageIDs'=>$languageIDs, 
			'adminId'=>$adminId, 
			'branchCodeSes'=>$branchCodeSes 
		);
		$getLicenseReq	= $ObjLicenseReq->getLicenseReqDetails($params);
		if(empty($getLicenseReq)){
			 $this->setRedirect('licenserequest/index/');
		}
		$this->ObjView->assign('getLicenseReq', $getLicenseReq);
		$this->ObjView->assign('requestID', $requestID);
		$editreqPrivilege	=	$this->ObjCommon->hasPrivilege('licenserequest/edit/');
		$this->ObjView->assign("editreqPrivilege", $editreqPrivilege);
		$this->ObjView->assign("previousURl", $this->getPreviousURL());
		$this->ObjView->display('LicenseRequestView.tpl');
		
	}
	
	public function editAction()    
	{
		ini_set('soap.wsdl_cache_enabled', '0');
		ini_set('soap.wsdl_cache_ttl', '0'); 
		$requestID		= $this->getRequestValue('id');
		$ObjLicense    	= new LicenseModel();
		$ObjLicenseReq 	= new LicenserequestModel();
		$ObjCountry     = new CountryModel();
		$adminId		= $this->ObjCommon->manageUserID; 
		$branchCodeSes	= $this->ObjCommon->manageBranchCode;
		$languageIDs    = $this->ObjView->languageIDs;
		$ObjPackage		= new PackageModel();
		$resPackage		= $ObjPackage->listPackageOptions();
                foreach($resPackage as $key=>$value) {
			$resPackage[$key][1] = $this->encryptDecrypt("decrypt",$value['packageName']);
		}
		$this->ObjView->assign('resPackage', $resPackage);
		$resParent		= $ObjLicense->getParentLicense();
		$resParent		= array_merge(array('0'=>array('0'=>'0','licenceID' => '0','1'=>'Root Level','domainName'=>'Root Level')), $resParent);
                
                foreach($resParent as $key=>$value) {
			$resParent[$key]['domainName'] = $this->encryptDecrypt("decrypt",$value['domainName']);
                        $resParent[$key]['1'] = $this->encryptDecrypt("decrypt",$value['1']);
		}//
		$this->ObjView->assign('resParent', $resParent);
		$this->ObjView->assign('resParentJson', json_encode($resParent));
		$ObjAdminlog	= new AdminlogModel();
		$params=array(
			'requestID'=>$requestID,
			'languageIDs'=>$languageIDs
		);
		$getLicenseReq	= $ObjLicenseReq->getLicenseReqDetails($params);//echo    "<pre>";print_r($getLicenseReq);exit;
		if(empty($getLicenseReq))
		{
			 $this->setRedirect('licenserequest');
		}
		
		$stateValue = (($getLicenseReq['stateID'] > 0) ? $getLicenseReq['stateID'] : $getLicenseReq['province']);
		if($this->ObjForm->isValid('formLicenseReq','submitLicenseReq'))
		{
			if($_POST['requeststatus']=="approved")
			{
				$wsdl="http://demo.oorjit.com/~ssloorji/createlic/createlickey.php?wsdl";
				$client=new soapclient($wsdl); 
				$dataparam		= $_POST['customerID'];
				$dataToken		= $this->paramEncode($dataparam);			
				$param=array('dataToken'=>$dataToken);
				try
				{
					//Calling web service
					$resultenc		= $client->__call('createLicense', $param);
					$resultlic		= $this->decodeDmhostip($resultenc);	
					$resultlicenc	= base64_encode($resultlic); 
				}
				catch(SoapFault $fault)
				{  
					echo "<div style=\"border:#900 1px solid;width:50%;margin:0 auto;background:#f06868;padding:30px 8px; text-align:center;font: bold 12px Arial, Helvetica, sans-serif;color:#fff;\">Sorry for the inconvenience, Please try later</div>";
					exit;
				}	
				$licID	= $ObjLicenseReq->insert($languageIDs,$adminId,$branchCodeSes,$requestID,$resultlicenc);
				$this->setMessage('language.lblLicenseaddSuccess','success');
				/* Adminlog */
				$adminAccessIP						= $this->ObjCommon->getClientIP();
				$i									= 0;
				$adminActionData					= array();
				$adminActionData[$i]['status']		= "Updated";
				$adminActionData[$i]['response']	= "Successfully Updated And Approved The License";
				$i++;
				if(isset($_POST['parentDomain']))
				{
					if(($_POST['parentDomain']!=0) || ($getLicenseReq['parentDomain']!=0))
					{
						foreach ($resParent as $key => $value) 
						{
							if ($value['licenceID'] == $_POST['parentDomain']) 
							{
								$parentName	= $resCustomer[$key]['domainName'];
							}
							if($value['licenceID'] == $getLicenseReq['parentDomain'])
							{
								$oldparentName	= $resCustomer[$key]['domainName'];
							}
						}
					}
					if($_POST['parentDomain']==0)
					{
						$parentName	= "Root Level";
					}
					if($getLicenseReq['parentDomain']==0)
					{
						$parentName	= "Root Level";
					}

				}
				if($this->encryptDecrypt("decrypt",$getLicenseReq['customerFirstName'])!=$_POST['customerFirstName'])
				{
					$adminActionData[$i]['field']	= "CustomerFirstName";
					$adminActionData[$i]['Old']		= $this->encryptDecrypt("decrypt",$getLicenseReq['customerFirstName']);
					$adminActionData[$i]['New']		= $_POST['customerFirstName'];
					$i++;
				}
				if($this->encryptDecrypt("decrypt",$getLicenseReq['customerLastName'])!=$_POST['customerLastName'])
				{
					$adminActionData[$i]['field']	= "CustomerLastName";
					$adminActionData[$i]['Old']		= $this->encryptDecrypt("decrypt",$getLicenseReq['customerLastName']);
					$adminActionData[$i]['New']		= $_POST['customerLastName'];
					$i++;
				}
				if($this->encryptDecrypt("decrypt",$getLicenseReq['customerEmailID'])!=$_POST['customerEmailID'])
				{
					$adminActionData[$i]['field']	= "CustomerEmailID";
					$adminActionData[$i]['Old']		= $this->encryptDecrypt("decrypt",$getLicenseReq['customerEmailID']);
					$adminActionData[$i]['New']		= $_POST['customerEmailID'];
					$i++;
				}
				if($this->encryptDecrypt("decrypt",$getLicenseReq['customerPhone'])!=$_POST['customerPhone'])
				{
					$adminActionData[$i]['field']	= "CustomerPhone";
					$adminActionData[$i]['Old']		= $this->encryptDecrypt("decrypt",$getLicenseReq['customerPhone']);
					$adminActionData[$i]['New']		= $_POST['customerPhone'];
					$i++;
				}
				if($getLicenseReq['customerAddress1']!=$_POST['customerAddress1'])
				{
					$adminActionData[$i]['field']	= "CustomerAddress1";
					$adminActionData[$i]['Old']		= $getLicenseReq['customerAddress1'];
					$adminActionData[$i]['New']		= $_POST['customerAddress1'];
					$i++;
				}
				if($getLicenseReq['customerStatus']!=$_POST['customerStatus'])
				{
					$adminActionData[$i]['field']	= "CustomerStatus";
					$adminActionData[$i]['Old']		= $getLicenseReq['customerStatus'];
					$adminActionData[$i]['New']		= $_POST['customerStatus'];
					$i++;
				}
				if($getLicenseReq['domainName']!=$_POST['domainName'])
				{
					$adminActionData[$i]['field']	= "DomainName";
					$adminActionData[$i]['Old']		= $getLicenseReq['domainName'];
					$adminActionData[$i]['New']		= $_POST['domainName'];
					$i++;
				}
				if($this->encryptDecrypt("decrypt",$getLicenseReq['packageKey'])!=$_POST['packageKey'])
				{
					$adminActionData[$i]['field']	= "PackageKey";
					$adminActionData[$i]['Old']		= $this->encryptDecrypt("decrypt",$getLicenseReq['packageKey']);
					$adminActionData[$i]['New']		= $this->encryptDecrypt("decrypt",$_POST['packageKey']);
					$i++;
				}
				if($getLicenseReq['packageVersion']!=$_POST['packageVersion'])
				{
					$adminActionData[$i]['field']	= "PackageVersion";
					$adminActionData[$i]['Old']		= $getLicenseReq['packageVersion'];
					$adminActionData[$i]['New']		= $_POST['packageVersion'];
					$i++;
				}
				if($getLicenseReq['requeststatus']!=$_POST['requeststatus'])
				{
					$adminActionData[$i]['field']	= "RequestStatus";
					$adminActionData[$i]['Old']		= $getLicenseReq['requeststatus'];
					$adminActionData[$i]['New']		= $_POST['requeststatus'];
					$i++;
				}
				if($getLicenseReq['licenseType']!=$_POST['licenseType'])
				{
					$adminActionData[$i]['field']	= "LicenseType";
					$adminActionData[$i]['Old']		= $getLicenseReq['licenseType'];
					$adminActionData[$i]['New']		= $_POST['licenseType'];
					$i++;
				}
				if($getLicenseReq['parentDomain']!=$_POST['parentDomain'])
				{
					$adminActionData[$i]['field']	= "ParentDomain";
					$adminActionData[$i]['Old']		= $oldparentName;
					$adminActionData[$i]['New']		= $parentName;
					$i++;
				}
				
				if($_POST['licenseType']=="Developer")
				{
					if($getLicenseReq['expiry']!=$_POST['expiry'])
					{
						$adminActionData[$i]['field']	= "Expiry";
						$adminActionData[$i]['Old']		= $getLicenseReq['expiry'];
						$adminActionData[$i]['New']		= $_POST['expiry'];
						$i++;
					
					}
				
					if((isset($_POST['expiryDate'])) && ($_POST['expiryDate']!=""))
					{
						if($getLicenseReq['expiryDate']!=$_POST['expiryDate'])
						{
							$adminActionData[$i]['field']	= "ExpiryDate";
							$adminActionData[$i]['Old']		= $getLicenseReq['expiryDate'];
							$adminActionData[$i]['New']		= $_POST['expiryDate'];
							$i++;
						}
					}
				}
			
				if(count($adminActionData)==1)
				{
					$adminActionData[0]['message']	= "No Changes for Form Elements OR Minor Changes";
				}
				$adminActionDataStr					= serialize($adminActionData);
                                
				$params =array(
				'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Edit', 'adminActionObject'=>'LicenseRequest', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
				);
				$ObjAdminlog->insertAdminlog($params);
				/* End Adminlog */
				
				//Mail
				$ObjEmailtemplate	= new EmailtemplateModel();
				$languageIDs		= $this->ObjView->languageIDs;		
				$mail_settings   	= $this->getSettingValue('mail_settings');
				$ObjMail          	= new Mail($mail_settings);
				$companyLogo   		= $this->getSettingValue('company_information', 'company_logo');
				$siteName      		= $this->getSettingValue('site_settings', 'site_name');
				$siteUrl       		= $this->getSettingValue('site_settings', 'global_http_url');
				$emailTempDet     	= $ObjEmailtemplate->getEmailTemlateDetails($languageIDs, '', 'deal-request-approved');
				$fromEmailName 		= $emailTempDet['emailFromName'];
				$fromEmailId   		= $emailTempDet['emailFromEmail'];
				$Subject       		= $emailTempDet['emailSubject'];
				$Body          		= $emailTempDet['emailHtml'];
				$this->ObjView->assign('emailBottom',$emailBottom);						
				$this->ObjView->assign('companyLogo', $companyLogo);
				$this->ObjView->assign('siteName', $siteName);
				$this->ObjView->assign('siteUrl', $siteUrl);
				$ObjAdminuser		= new AdminuserModel();
				$resAdminDetails   	= $ObjAdminuser->getAdminDetails($getLicenseReq['adminId'],'','','','','');
				$adminEmailID		= $resAdminDetails['adminUserEmail'];
				$adminName			= $resAdminDetails['adminUserFirstName'].''.$resAdminDetails['adminUserLastName'];
				$url		  		= $siteUrl.'manage/license/view/id/'.$licID;
				$Body         		= str_replace('{$userName}', $adminName, $Body);
				$Body         		= str_replace('{$siteName}', $siteName, $Body);
				$Body         		= str_replace('{$url}', $url, $Body);
				$Body				.= "<br/>".$_POST['mailContent'];
				
				$this->ObjView->assign('emailbody', $Body);
				$email_body = $this->ObjCommon->fetch("email_templates/Layout.tpl",$languageIDs);
				$ObjMail->IsHTML();
				$send      					= $ObjMail->sendMail(array(
																		$fromEmail,
																		$fromName
																		), 
																 array(
																		array(
																				$adminEmailID,
																				$adminName
																			 )
																
																	  ),$Subject, $email_body);
				if (!$ObjMail->Send()) 
				{
					$message					.= '<br>Sending failed for '.$adminEmailID;	
				}

				$ObjMail->clearAddresses();
			
				
				$this->setRedirect('license/index/');
			}
			else
			{
				$ObjLicenseReq->insert($languageIDs,$adminId,$branchCodeSes,$requestID);
				$this->setMessage('language.lblLicenserequpdatedSuccess','success');
				/* Adminlog */
				$adminAccessIP						= $this->ObjCommon->getClientIP();
				$i									= 0;
				$adminActionData					= array();
				$adminActionData[$i]['status']		= "Updated";
				$adminActionData[$i]['response']	= "Successfully Updated";
				$i++;
				if(isset($_POST['parentDomain']))
				{
					if(($_POST['parentDomain']!=0) || ($getLicense['parentDomain']!=0))
					{
						foreach ($resParent as $key => $value) 
						{
							if ($value['licenceID'] == $_POST['parentDomain']) 
							{
								$parentName	= $resCustomer[$key]['domainName'];
							}
							if($value['licenceID'] == $getLicense['parentDomain'])
							{
								$oldparentName	= $resCustomer[$key]['domainName'];
							}
						}
					}
					if($_POST['parentDomain']==0)
					{
						$parentName	= "Root Level";
					}
					if($getLicense['parentDomain']==0)
					{
						$parentName	= "Root Level";
					}

				}
				if($this->encryptDecrypt("decrypt",$getLicenseReq['customerFirstName'])!=$_POST['customerFirstName'])
				{
					$adminActionData[$i]['field']	= "CustomerFirstName";
					$adminActionData[$i]['Old']		= $this->encryptDecrypt("decrypt",$getLicenseReq['customerFirstName']);
					$adminActionData[$i]['New']		= $_POST['customerFirstName'];
					$i++;
				}
				if($this->encryptDecrypt("decrypt",$getLicenseReq['customerLastName'])!=$_POST['customerLastName'])
				{
					$adminActionData[$i]['field']	= "CustomerLastName";
					$adminActionData[$i]['Old']		= $this->encryptDecrypt("decrypt",$getLicenseReq['customerLastName']);
					$adminActionData[$i]['New']		= $_POST['customerLastName'];
					$i++;
				}
				if($this->encryptDecrypt("decrypt",$getLicenseReq['customerEmailID'])!=$_POST['customerEmailID'])
				{
					$adminActionData[$i]['field']	= "CustomerEmailID";
					$adminActionData[$i]['Old']		= $this->encryptDecrypt("decrypt",$getLicenseReq['customerEmailID']);
					$adminActionData[$i]['New']		= $_POST['customerEmailID'];
					$i++;
				}
				if($this->encryptDecrypt("decrypt",$getLicenseReq['customerPhone'])!=$_POST['customerPhone'])
				{
					$adminActionData[$i]['field']	= "CustomerPhone";
					$adminActionData[$i]['Old']		= $this->encryptDecrypt("decrypt",$getLicenseReq['customerPhone']);
					$adminActionData[$i]['New']		= $_POST['customerPhone'];
					$i++;
				}
				if($getLicenseReq['customerAddress1']!=$_POST['customerAddress1'])
				{
					$adminActionData[$i]['field']	= "CustomerAddress1";
					$adminActionData[$i]['Old']		= $getLicenseReq['customerAddress1'];
					$adminActionData[$i]['New']		= $_POST['customerAddress1'];
					$i++;
				}
				if($getLicenseReq['customerStatus']!=$_POST['customerStatus'])
				{
					$adminActionData[$i]['field']	= "CustomerStatus";
					$adminActionData[$i]['Old']		= $getLicenseReq['customerStatus'];
					$adminActionData[$i]['New']		= $_POST['customerStatus'];
					$i++;
				}
				if($getLicenseReq['domainName']!=$_POST['domainName'])
				{
					$adminActionData[$i]['field']	= "DomainName";
					$adminActionData[$i]['Old']		= $getLicenseReq['domainName'];
					$adminActionData[$i]['New']		= $_POST['domainName'];
					$i++;
				}
				if($this->encryptDecrypt("decrypt",$getLicenseReq['packageKey'])!=$_POST['packageKey'])
				{
					$adminActionData[$i]['field']	= "PackageKey";
					$adminActionData[$i]['Old']		= $this->encryptDecrypt("decrypt",$getLicenseReq['packageKey']);
					$adminActionData[$i]['New']		= $this->encryptDecrypt("decrypt",$_POST['packageKey']);
					$i++;
				}
				if($getLicenseReq['packageVersion']!=$_POST['packageVersion'])
				{
					$adminActionData[$i]['field']	= "PackageVersion";
					$adminActionData[$i]['Old']		= $getLicenseReq['packageVersion'];
					$adminActionData[$i]['New']		= $_POST['packageVersion'];
					$i++;
				}
				if($getLicenseReq['requeststatus']!=$_POST['requeststatus'])
				{
					$adminActionData[$i]['field']	= "RequestStatus";
					$adminActionData[$i]['Old']		= $getLicenseReq['requeststatus'];
					$adminActionData[$i]['New']		= $_POST['requeststatus'];
					$i++;
				}
				if($getLicenseReq['licenseType']!=$_POST['licenseType'])
				{
					$adminActionData[$i]['field']	= "LicenseType";
					$adminActionData[$i]['Old']		= $getLicenseReq['licenseType'];
					$adminActionData[$i]['New']		= $_POST['licenseType'];
					$i++;
				}
				if($getLicenseReq['parentDomain']!=$_POST['parentDomain'])
				{
					$adminActionData[$i]['field']	= "ParentDomain";
					$adminActionData[$i]['Old']		= $oldparentName;
					$adminActionData[$i]['New']		= $parentName;
					$i++;
				}
				
				if($_POST['licenseType']=="Developer")
				{
					if($getLicenseReq['expiry']!=$_POST['expiry'])
					{
						$adminActionData[$i]['field']	= "Expiry";
						$adminActionData[$i]['Old']		= $getLicenseReq['expiry'];
						$adminActionData[$i]['New']		= $_POST['expiry'];
						$i++;
					
					}
				
					if((isset($_POST['expiryDate'])) && ($_POST['expiryDate']!=""))
					{
						if($getLicenseReq['expiryDate']!=$_POST['expiryDate'])
						{
							$adminActionData[$i]['field']	= "ExpiryDate";
							$adminActionData[$i]['Old']		= $getLicenseReq['expiryDate'];
							$adminActionData[$i]['New']		= $_POST['expiryDate'];
							$i++;
						}
					}
				}
			
				if(count($adminActionData)==1)
				{
					$adminActionData[0]['message']	= "No Changes for Form Elements OR Minor Changes";
				}
				$adminActionDataStr					= serialize($adminActionData);
				$params =array(
				'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Edit', 'adminActionObject'=>'LicenseRequest', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
				);
				$ObjAdminlog->insertAdminlog($params);
				/* End Adminlog */
				$this->setRedirect('licenserequest/index/');
			}
			
		} 
		else
		{
			if(isset($_POST['submitLicense']))
			{
				if(!$this->ObjForm->isValid('formLicense','submitLicense'))
				{
					/* Adminlog */
					$adminAccessIP		= $this->ObjCommon->getClientIP();
					$i									= 0;
					$adminActionData					= array();
					$adminActionData[$i]['status']		= "Update Failed";
					$adminActionData[$i]['response']	= "Error found in form element";
					$adminActionData[$i]['message']		= "No Changes for Form Elements";
					$i++;
					$adminActionDataStr					= serialize($adminActionData);
					$params =array(
					'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Edit', 'adminActionObject'=>'LicenseRequest', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
					);
					$ObjAdminlog->insertAdminlog($params);
					/* End Adminlog */
				}
			}
		}
                 //Remove Encrypted values
                $keysToRemove   =   array(
                    'customerFirstName',
                    'customerLastName',
                    'customerEmailID',
                    'customerPhone',
                    'customerCompany',
                    'customerAddEmailID',
                    'customerFax'
                );
                $licenseRequestDetails    =   $this->ObjCommon->arrayRemoveKeys($getLicenseReq,$keysToRemove);
		$this->ObjView->assignValues($licenseRequestDetails);//echo "<pre>";print_r($licenseRequestDetails);print_r($licenseRequestDetails);exit;
                $this->ObjView->assign('customerFirstName',  $this->encryptDecrypt("decrypt",$getLicenseReq['customerFirstName']));
                $this->ObjView->assign('customerLastName',  $this->encryptDecrypt("decrypt",$getLicenseReq['customerLastName']));
                $this->ObjView->assign('customerEmailID',  $this->encryptDecrypt("decrypt",$getLicenseReq['customerEmailID']));
                $this->ObjView->assign('customerCompany',  $this->encryptDecrypt("decrypt",$getLicenseReq['customerCompany']));
                $this->ObjView->assign('customerAddEmailID',  $this->encryptDecrypt("decrypt",$getLicenseReq['customerAddEmailID']));
                $this->ObjView->assign('customerFax',  $this->encryptDecrypt("decrypt",$getLicenseReq['customerFax']));
                $this->ObjView->assign('customerPhone',  $this->encryptDecrypt("decrypt",$getLicenseReq['customerPhone']));
		$this->ObjView->assign('requestID', $requestID);
		$this->ObjView->assign('resCountry', $ObjCountry->listCountries($languageIDs, "Yes"));
		$this->ObjView->assign('stateID', $stateValue);
        $this->ObjView->assign('statehidValue', $stateValue);
		$this->ObjView->display('LicenseRequestForm.tpl');
		
	}
	
	/**** Parameter Encode  ****/
	public function paramEncode($data)
	{
		$encfirst	= str_rot13($data);
		$encsecnd	= base64_encode(convert_uuencode($encfirst));
		$encdata	= urlencode($encsecnd);
		return $encdata;
	}
	/**** End Parameter Encode  ****/
	
	/**** Decode result with random key  ****/
	public function decodeDmhostip($resdata)
	{
		$decfirst	= urldecode($resdata);
		$decdata	= base64_decode(str_rot13($decfirst));
		return $decdata;
	}
        
}