<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/	//
	//$Id: AdminlogModel.php, v 1.0 2014/07/28 02:24:11
class AdminlogModel extends Model
{
	//Function to get admin log list
	function listAdminLog($params=array())
	{
		extract($params);
		$sql= " SELECT ";
        if ($limitTo)
        {
            $sql.= " SQL_CALC_FOUND_ROWS ";
        }
        
        $sql.= "	adminlog.adminLogID,
					adminlog.adminUserID, 
					adminlog.adminActivityDate, 
					adminlog.adminActionType, 
					adminlog.adminActionObject, 
					adminlog.adminAccessIP,
					adminlog.adminActionStatus, 
					adminlog.adminActivityComments, 
					adminusers.adminUserFirstName, 
					adminusers.adminUserLastName, 
					adminusertype.userTypeName 
				FROM admin_activity_log AS adminlog 
				LEFT JOIN ".DB_PREFIX."admin_users AS adminusers ON adminlog.adminUserID=adminusers.adminUserID	
				LEFT JOIN ".DB_PREFIX."admin_user_type AS adminusertype ON  adminusers.userTypeID=adminusertype.userTypeID	
				WHERE 1 ";
		if(isset($user) && $user!='')
		{
			$sql.= "AND (adminusers.adminUserFirstName like '%".$user."%' OR adminusers.adminUserLastName like '%".$user."%')";
		}								
		if(isset($actionStatus) && $actionStatus!='')
		{
			$sql.= "AND adminlog.adminActionStatus ='".$actionStatus."' ";
		}	
		if(isset($actionObject) && $actionObject!='')
		{
			$sql.= "AND adminlog.adminActionObject like '%".$actionObject."%' ";
		}								
		if(isset($actionType) && $actionType!='')
		{
			$sql.= "AND adminlog.adminActionType ='".$actionType."' ";
		}		
		if ((isset($fromDate) && isset($toDate)) && ($fromDate != '' && $toDate != ''))
		{
			$sql .= "AND ( DATEDIFF('" . $fromDate . "',adminlog.adminActivityDate)<=0 AND DATEDIFF('" . $toDate . "',adminlog.adminActivityDate)>=0 )";
		}
		else if ((isset($fromDate)) && ($fromDate!= ''))
		{
			$sql .= " 	AND ( DATEDIFF( '" . $fromDate . "',adminlog.adminActivityDate)<=0 ) ";
		}
		else if ((isset($toDate)) && ($toDate != ''))
		{
			$sql .= " AND ( DATEDIFF('" . $toDate . "',adminlog.adminActivityDate)>=0 )  ";
		}
        if($orderby && $sortby)
		{
			$sql.="ORDER BY ".substr($sortby, 5)." ".$orderby." ";
		}
		else
		{
			$sql.="ORDER BY adminlog.adminActivityDate DESC ";
		}
		if ($limitTo)
		{
			$sql .= "LIMIT " . $limitFrom . ", " . $limitTo . "
			";
		}
		return  $this->ObjDatabase->readValues($sql, MYSQLI_ASSOC);
	}
	
	//Function to get admin log details
	function getAdminlogDetails($params=array())
	{
		extract($params);
        
        $sql= "SELECT	
					adminlog.adminLogID,
					adminlog.adminUserID,  
					adminlog.adminActionData 
				FROM admin_activity_log AS adminlog 
				WHERE adminlog.adminLogID='".$adminLogID."' ";
		return  $this->ObjDatabase->readValue($sql);
	}
	
	public function insertAdminlog($params=array())
    {
		extract($params);
		$sql	= "	INSERT INTO admin_activity_log SET
					adminActivityDate		= now(), 
					adminUserID		        = '".$this->escape($adminUserID)."', 
					adminActionType         = '".$this->escape($adminActionType)."', 
					adminActionObject       = '".$this->escape($adminActionObject)."',	
					adminActionData		    = '".$this->escape($this->encryptDecrypt("encrypt",$adminActionData))."', 
					adminAccessIP           = '".$this->escape($adminAccessIP)."',              adminActionStatus		= '".$this->escape($adminActionStatus)."',
					adminActivityComments	= '".$this->escape($adminActivityComments)."' ";
		$this->ObjDatabase->setQuery($sql);
    }
	
	// Clean Admin Log
	public function cleanAdminLog()
	{
		$sql	= "TRUNCATE TABLE admin_activity_log";
		$this->ObjDatabase->setQuery($sql);
	}
}