<?php
	/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/	//
//$Id: AdminuserModel.php, v 1.0 2013/03/14 14:14:14
class AdminuserModel extends Model 
{
	//Function to get admin details
	function getAdminDetails($adminUserID='',$adminUserEmail='',$adminUserLoginName='',$adminUserLoginPass='',$status='',$adminUserTransPass='')
	{
		$sql="
			SELECT 
				admUse.adminUserID as adminUserID, admUse.adminUserFirstName as adminUserFirstName, admUse.adminUserLastName as adminUserLastName, admUse.adminUserEmail as adminUserEmail, admUse.adminUserLoginName as adminUserLoginName, admUse.adminUserLoginPass as adminUserLoginPass, admUse.adminUserStatus as adminUserStatus, admUse.adminUserAccessCount as adminUserAccessCount, admUse.adminUserInvalidAccessCount as adminUserInvalidAccessCount, admUse.adminUserLockedDate as adminUserLockedDate, admUse.adminUserCreatedDate as adminUserCreatedDate, admUse.adminUserLastAccessDate as adminUserLastAccessDate, admUse.userTypeID as userTypeID, admUse.roleID as roleID, admUse.branchCode as branchCode 
			FROM 
					".DB_PREFIX."admin_users  AS admUse
			WHERE 
				1 ";
		if($this->escape($adminUserEmail)){
			$sql.= " 
				AND 
				`adminUserEmail`='".$this->escape($adminUserEmail)."' ";
		}
		if($adminUserID){
			$sql.= "
				AND `adminUserID`='".$adminUserID."' ";
		}
		if($this->escape($adminUserLoginName)){
			$sql.= " 
				AND `adminUserLoginName`='".$this->escape($adminUserLoginName)."' ";
		}
		if($this->escape($adminUserLoginPass)){
			$sql.= " 
				AND `adminUserLoginPass`='".$this->escape($adminUserLoginPass)."' ";
		}
		if($this->escape($adminUserTransPass)){
			$sql.= " 
				AND `adminUserTransPass`='".$this->escape($adminUserTransPass)."' ";
		}
		if($status){
			$sql.= " 
				AND `adminUserStatus`='".$status."' ";
		}
		$sql	.= " AND adminUserStatus<>'Deleted'";
		$result	 = $this->ObjDatabase->readValue($sql);		
		if($result){
			$sql		= "
			SELECT 
				userTypeStatus,
				userTypeName
			FROM 
				".DB_PREFIX."admin_user_type   
			WHERE 
				userTypeID='".$result['userTypeID']."'";
			$result1		= $this->ObjDatabase->readValue($sql);
			$result['userTypeStatus']	= $result1['userTypeStatus'];
			$result['userTypeName'] 	= $result1['userTypeName'];
		}
		return $result;
	}
	//End of function
	//Function to list admin roles
	function ListAdminRoles($excludetype='')
	{
		$sql	= "
		SELECT 
			* 
		FROM  
			".DB_PREFIX."admin_user_type 
		WHERE 
			`userTypeStatus`<>'Deleted'";
		if($excludetype>0)
			$sql	.= " AND userTypeID!='".$excludetype."'";
		$sql	.= " ORDER BY userTypeName ASC";
		$result	= $this->ObjDatabase->readValues($sql);
		return $result;
	}
	//End of function
	
	//Function to list Branch Codes
	function listBranchCodes()
	{
		$sql	= "
				SELECT 
					branch.branchCode as branchID, branch.branchCode as branchCode    
				FROM  
					branch_info as branch 
				WHERE 
					branch.branchStatus!='Deleted' ";

		$sql	.= " ORDER BY branch.branchID ASC ";
		$result	= $this->ObjDatabase->readValues($sql);
		return $result;
	}
	//End of function
	
	//Function to save admin deatils
	function saveAdminDetails($POST,$adminUserID='',$currentDateTime='')
	{
		if(!$adminUserID){
			$sql	= "
			INSERT INTO 
				".DB_PREFIX."admin_users(
						adminUserFirstName,
						adminUserLastName,
						adminUserEmail,
						adminUserLoginName,
						adminUserLoginPass,
						adminUserTransPass,
						adminUserStatus,
						adminUserCreatedDate,
						userTypeID, 
						branchCode 
					)VALUES(
						'".$this->escape($POST['adminUserFirstName'])."',
						'".$this->escape($POST['adminUserLastName'])."',
						'".$this->escape($POST['adminUserEmail'])."',
						'".$this->escape($POST['adminUserLoginName'])."',
						'".$this->encodeString(trim($POST['adminUserConfirmPass']))."',
						'".$this->encodeString(trim($POST['adminUserConfirmTransPass']))."',
						'".$POST['adminUserStatus']."',
						'".$currentDateTime."',
						'".$POST['adminRole']."',  
						'".$POST['branchCode']."'
					)";
			$result	= $this->ObjDatabase->setQuery($sql);
			/* City Based Privilages*/
			$adminUserID           = $this->ObjDatabase->getInsertId();
			if ($POST['adminType'] == 'CityAdmin'){
				$this->addUserPrivilagedCities($POST['cityID'], $adminUserID);
			}
			/* City Based Privilages*/
			return $result;
		}
		if($adminUserID){
			$sql		= "
			UPDATE 
				".DB_PREFIX."admin_users    
			SET 
				adminUserFirstName='".$this->escape($POST['adminUserFirstName'])."',
				adminUserLastName='".$this->escape($POST['adminUserLastName'])."',
				adminUserEmail='".$this->escape($POST['adminUserEmail'])."' ";
			if(trim($POST['adminUserConfirmPass'])!=''){
				$sql		.= " ,adminUserLoginPass='".$this->encodeString(trim($POST['adminUserConfirmPass']))."' ";
			}
			if(trim($POST['adminUserConfirmTransPass'])!=''){
				$sql		.= " ,adminUserTransPass='".$this->encodeString(trim($POST['adminUserConfirmTransPass']))."' ";
			}
			$sql	 	.= " ,adminUserStatus='".$POST['adminUserStatus']."',
							 userTypeID='".$POST['adminRole']."', branchCode='".$POST['branchCode']."' 
			WHERE `adminUserID`='".$adminUserID."'";
			$result		=  $this->ObjDatabase->setQuery($sql);
			/* City Based Privilages*/
			if ($POST['adminType'] == 'CityAdmin') {
				$this->addUserPrivilagedCities($POST['cityID'], $adminUserID);
			}
			/* City Based Privilages*/
			return $result;
		}
	}
	
	//Function to save admin deatils
	function changeTransactionPwd($POST,$adminUserID)
	{
		$sql	= "UPDATE 
						".DB_PREFIX."admin_users    
					SET 
						adminUserTransPass='".$this->encodeString(trim($POST['adminUserConfirmTransPass']))."'
					WHERE adminUserID='".$adminUserID."'";
		$result	=  $this->ObjDatabase->setQuery($sql);
	}
	/* City Based Privilages*/
	function addUserPrivilagedCities($cityIDArray, $adminUserID)
	{
		if($_SESSION['ADMIN_ACCED_CITIES']){
			$resCities	=	$this->getCitiesByAdminID($adminUserID);
			$sesCities	=	explode(',',$_SESSION['ADMIN_ACCED_CITIES']);
			$dbCities	=	array_diff($resCities,$sesCities);
			$cityIDArray	=	array_unique(array_merge($dbCities,$cityIDArray));
		}
		$this->ObjDatabase->setQuery("
			DELETE 
			FROM 
				`" . DB_PREFIX . "user_privilage_city` 
			WHERE 
				`adminuserID` = '" . $adminUserID . "'
		");
		for ($i = 0; $i < count($cityIDArray); $i++){
			$cityID = $cityIDArray[$i];
			if ($cityID != "" && $cityID!="test"){
				$this->ObjDatabase->setQuery("
				INSERT INTO 
					`" . DB_PREFIX . "user_privilage_city` (
							`adminuserID`, 
							`cityID`
					) VALUES (
							'" . $adminUserID . "', 
							'" . (int)$cityID . "')
				");
			}
		}
	}
	/* City Based Privilages*/
	//Function to List administrators
	function listAdmin($limitFrom=0,$limitTo="",$sortOrder="ASC",$status="")
	{
		$sql			= " SELECT ";
		//IF PAGINATION REQUIRED
		if($limitTo) 
			$sql			.=" SQL_CALC_FOUND_ROWS ";
		$sql 		.= " admUsr.*,
									 admUsrTyp.userTypeName";
		$sql 		.= " 
		FROM  
			".DB_PREFIX."admin_users admUsr,
			".DB_PREFIX."admin_user_type admUsrTyp ";
		$sql			.= " 
		WHERE 
			admUsr.adminUserStatus!='Deleted' 
			AND admUsr.userTypeID=admUsrTyp.userTypeID";
		if($status) 
			$sql			.=" AND admUsr.adminUserStatus='".$status."'";
		$sql.=" GROUP BY admUsr.adminUserID  
				ORDER BY admUsr.adminUserFirstName  ".$sortOrder." ";
		//IF PAGINATION REQUIRED
		if($limitTo) {
			$sql  .= " LIMIT  ".$limitFrom.",".$limitTo."";
		}
		$result = $this->ObjDatabase->readValues($sql);
		return $result;
	}
	//End of function
	//Function to change admin status
	function changeAdminStatus($adminUserStatus,$adminUserBulkStatusArray,$deleteprivilage=''){
		if(is_array($adminUserBulkStatusArray)){
			$adminUserBulkStatus=implode(',',$adminUserBulkStatusArray);
		} else {
			$adminUserBulkStatus= $adminUserBulkStatusArray;
		}
		if($adminUserStatus=='Deleted' && !$deleteprivilage)
			$adminUserStatus	=	'Active';
		$result    =   $this->ObjDatabase->setQuery("
		UPDATE 
			".DB_PREFIX."admin_users 
		SET 
			adminUserStatus ='".$adminUserStatus."' 
		WHERE 
			adminUserID IN(".$adminUserBulkStatus.")");
		return TRUE;
	}

	//End of function
	//Function to save login detils
	function saveLoginDetails($adminUserID,$accessDateTime){
		$sql="
		UPDATE 
			".DB_PREFIX."admin_users 
		SET 
			adminUserLastAccessDate='".$accessDateTime."',
			adminUserAccessCount=adminUserAccessCount+1,
			adminUserInvalidAccessCount='0' 
		WHERE 
			adminUserID='".$adminUserID."'";
		$result= $this->ObjDatabase->setQuery($sql);
		return $result;
	}
	//End of function
	//Function to save invalid access count
	function saveInvalidAccessCount($adminUserLoginName,$blockingAttemps){
		$resAdminDetails =$this->getAdminDetails('','',$adminUserLoginName);
		$sql="
		UPDATE 
			".DB_PREFIX."admin_users 
		SET 
			adminUserInvalidAccessCount=adminUserInvalidAccessCount+1 
		WHERE 
			adminUserID='".$resAdminDetails['adminUserID']."'";
		$result= $this->ObjDatabase->setQuery($sql);
		if($result) {
			if(($resAdminDetails['adminUserInvalidAccessCount']+1)>=$blockingAttemps) {
				$sql="
				UPDATE 
					".DB_PREFIX."admin_users 
				SET 
					adminUserStatus='Blocked' 
				WHERE 
					adminUserID='".$resAdminDetails['adminUserID']."' 
					AND  adminUserStatus!='Deleted' ";
				$result= $this->ObjDatabase->setQuery($sql);
			}
		}
		return $resAdminDetails['adminUserInvalidAccessCount']+1;
	}
	//End of function
	//Function to activate user account
	function activateUserAccount($adminUserLoginName) {
		$sql="
		UPDATE 
			".DB_PREFIX."admin_users 
		SET 
			adminUserInvalidAccessCount='0',
			adminUserLockedDate='',
			adminUserStatus='Active' 
		WHERE 
			adminUserLoginName='".$adminUserLoginName."' 
			AND adminUserStatus!='Deleted' ";
		$result    = $this->ObjDatabase->setQuery($sql);
		return $result;
	}
	//End of function
	//Function to get current database time
	function currentDbtime(){
		$sql="
		SELECT 
			NOW() as time";
		$result = $this->ObjDatabase->readValue($sql);
		return $result;
	}
	//End of function
	/* City Based Privilages*/ // FETCH CITIES OF ADMIN
	function getCitiesByAdminID($adminUserID='')
	{
		$sql = "
		SELECT 
			cityID 
		FROM 
			".DB_PREFIX."user_privilage_city 
		WHERE
			adminuserID='".$adminUserID."' ";
		$result = $this->ObjDatabase->readValues($sql);
		$result = (@array_map(array(
			$this,
			'filterCityIDs'
		), $result));
		return $result;
	}
	//END OF FUNCTION
	//FILTER ADMIN CITIES
	public function filterCityIDs($cities)
	{
		return $cities['cityID'];
	}
	//END OF FUNCTION
	function CaptchaSecurityImages($ObjSession, $width, $height, $characters = '6', $style)
	{
		$ObjImage		=	new ImageModel();
		$code      = $ObjImage->generateCode($ObjSession, $characters);
		/* font size will be 75% of the image height */
		$font_size = $height * 0.70;
		switch($style){
			case 'style 1':
				/// black////
				$font_size = $height * 0.52;
				$image = @imagecreate($width + 9, $height) or die('Cannot initialize new GD image stream');
				$font             = __DIR_PUBLIC.'/font/Kids.ttf';
				$background_color = imagecolorallocate($image, 0, 0, 0);
				$text_color       = imagecolorallocate($image, 255, 255, 255);
				$noise_color      = imagecolorallocate($image, 0, 0, 0);
				break;
			case 'style 2':
				//// blue///	
				$font_size = $height * 0.50;
				$image = @imagecreate($width + 9, $height) or die('Cannot initialize new GD image stream');
				$font             = __DIR_PUBLIC.'/font/Almagro Regular.ttf';
				$background_color = imagecolorallocate($image, 255, 255, 255);
				$text_color       = imagecolorallocate($image, 0, 0, 220);
				$noise_color      = imagecolorallocate($image, 192, 192, 192);
				break;
			case 'style 3':
				/// grey////
				$image = @imagecreate($width, $height) or die('Cannot initialize new GD image stream');
				$font             = __DIR_PUBLIC.'/font/monofont.ttf';
				$background_color = imagecolorallocate($image, 240, 240, 240);
				$text_color       = imagecolorallocate($image, 171, 171, 171);
				$noise_color      = imagecolorallocate($image, 240, 240, 240);
				break;
			case 'style 4':
				$font_size = $height * 0.50;
				$image = @imagecreate($width + 9, $height) or die('Cannot initialize new GD image stream');
				$font             = __DIR_PUBLIC.'/font/Verdana.TTF';
				$background_color = imagecolorallocate($image, 0, 200, 0);
				$text_color       = imagecolorallocate($image, 252, 255, 255);
				$noise_color      = imagecolorallocate($image, 0, 200, 0);
				break;
		}
		/* set the colours */
		/* generate random dots in background */
		for ($i = 0; $i < ($width * $height) / 3; $i++) {
			imagefilledellipse($image, mt_rand(0, $width), mt_rand(0, $height), 1, 1, $noise_color);
		}
		/* generate random lines in background */
		for ($i = 0; $i < ($width * $height) / 150; $i++) {
			imageline($image, mt_rand(0, $width), mt_rand(0, $height), mt_rand(0, $width), mt_rand(0, $height), $noise_color);
		}
		/* create textbox and add text */
		$textbox = imagettfbbox($font_size, 0, $font, $code) or die('Error in imagettfbbox function');
		$x = ($width - $textbox[4]) / 2;
		$y = ($height - $textbox[5]) / 2;
		imagettftext($image, $font_size, 0, $x, $y, $text_color, $font, $code) or die('Error in imagettftext function');
		/* output captcha image to browser */
		header('Content-Type: image/jpeg');
		imagejpeg($image);
		imagedestroy($image);
		$ObjSession->setSession("ses_code", $code);
		$ObjSession->setSession("IMAGE_CAPTCHA_CODE", $code);
		return $code;
	}
	//ASSIGNING ADMIN CITIES TO SESSION
	function getAssignedCitiesByAdminId($adminUserID='')
	{
		$sql = "
		SELECT 
			usrPriCit.* 
		FROM 
			".DB_PREFIX."user_privilage_city usrPriCit 
		LEFT JOIN  
			".DB_PREFIX."cities cit 
				ON usrPriCit.cityID=cit.cityID  
		WHERE 
			usrPriCit.adminuserID='".$adminUserID."'  
			AND cit.cityStatus!='Deleted' ";
		$result = $this->ObjDatabase->readValues($sql);
		$realCount	=	count($result);
		$totalCount  = count($result) - 1;
		for ($i = 0; $i < $realCount; $i++) {
			$cityIDS = $cityIDS . $result[$i]['cityID'];
			if ($i != $totalCount) {
				$cityIDS .= ',';
				}
		}
		$_SESSION['ADMIN_ACCED_CITIES'] = $cityIDS;
	}
	public function checkAdminUser($adminUserID = 0,$adminUserTypeID=0)
	{
		if ($adminUserID > 1 && $adminUserTypeID > 1)
		{
			$sql    = "	
						SELECT 
							adminUserID 
						FROM 
							" . DB_PREFIX . "admin_users admUsr
						INNER JOIN
							" . DB_PREFIX . "admin_user_type admUsrTyp
							ON admUsr.userTypeID = admUsrTyp.userTypeID
						WHERE 
							admUsr.adminUserID='" . $adminUserID . "'
							AND admUsrTyp.userTypeID='" . $adminUserTypeID . "'
							AND admUsrTyp.userTypeStatus = 'Active'
							AND admUsr.adminUserStatus = 'Active'";
			$resultUser = $this->ObjDatabase->readValue($sql);
			if($resultUser['adminUserID']>0)
			return true;
		}
		elseif($adminUserTypeID == 1)
		return true;
		return false;
	}
	//Get User Type Name
	public function getAdminUserTypeName($userTypeID)
	{
		$sql		= "
			SELECT 
				userTypeName
			FROM 
				".DB_PREFIX."admin_user_type   
			WHERE 
				userTypeID='".$userTypeID."'";
		$result		= $this->ObjDatabase->readValue($sql);
		return 	$result['userTypeName'];
	}
	//END OF FUNCTION
	//TO	CHANGE	PASSWORD
	public function ChangeAdminuserPassword($emailID	=	'')
	{
		$ObjUser	=	new	UserModel();
		$newPassword	=	$ObjUser->generatePassword(10);
		$sql	=	$this->ObjDatabase->setQuery("	UPDATE	
														".DB_PREFIX."admin_users	
													SET		
														adminUserLoginPass='".$this->encodeString($newPassword)."'
													WHERE	
														adminUserEmail='".$emailID."'");
		return	$newPassword;

	}
}