<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/
//$Id: CommonModel.php, v 1.0 2013/03/14 14:14:14
// * To change this template, choose Tools | Templates
//* and open the template in the editor.
class CommonModel extends Model
{
 	var $code='';  
	var $marker=array(); 
	private function start()
	{
		if(!$this->marker['lat'])
			$this->marker['lat']	= '25.7897333';
		if(!$this->marker['lng'])
			$this->marker['lng']	= '-80.2259474';
		$this->code='
		<script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=false"></script>
		<script type="text/javascript">
		Array.prototype.filter = function(){
			t = this;
			var len = t.length >>> 0;
			var res = [];
			var thisp = arguments[1];
			for (var i = 0; i < len; i++){
				if (i in t){
					if(t[i]!="")
					res.push(t[i]);
				}
			}
			return res;
		};
		$(document).ready(function(){
			var setLat	=	'.$this->marker['lat'].';
			var setLon	=	'.$this->marker['lng'].';
			if(!(setLat>0 || setLon>0)){
				var setLat = 25.7897333;
				var setLon = -80.2259474;
			}    
			latlng = new google.maps.LatLng (setLat, setLon);
			myOptions 	=  {
				zoom:'.$this->marker['zoom'].',
				mapTypeId: google.maps.MapTypeId.ROADMAP,
				center: latlng,
				disableDefaultUI: true,
				zoomControl:true,
				zoomControlOptions : {
					style: google.maps.ZoomControlStyle.SMALL
				}
			};
			map = new google.maps.Map(document.getElementById("'.$this->marker['mapContainer'].'"), myOptions);
			var marker = new google.maps.Marker({
				position: new google.maps.LatLng('.$this->marker['lat'].', '.$this->marker['lng'].'), 
				map: '.$this->marker['map'].',
				title: "'.$this->marker['title'].'",
				clickable: '.$this->marker['click'].',
				icon: "'.$this->marker['icon'].'",
				Draggable :'.$this->marker['draggable'].'
			  });	
			  ';
			if($this->marker['info']!=''){
				$this->code.='var infowindow=new google.maps.InfoWindow({content:"'.$this->marker['info'].'"});
				google.maps.event.addListener(marker, \'click\',function(){infowindow.open(map, marker); });'; 
			}
			if($this->marker['textBoxEnabled']){
				$this->code.='google.maps.event.addListener (marker, \'dragend\', function (event){
	  				var point = marker.getPosition();
	  				$("#'.$this->marker['latTextBox'].'").val(point.lat());
	  				$("#'.$this->marker['lngTextBox'].'").val(point.lng());
				});
		  		google.maps.event.addDomListener(document.getElementById("'.$this->marker['latTextBox'].'"),
					 \'change\', function(event){
						newpos	=	new google.maps.LatLng ($("#'.$this->marker['latTextBox'].'").val(), 
							$("#'.$this->marker['lngTextBox'].'").val());
						marker.setPosition(newpos);
						map.panTo(newpos)
				});	
				google.maps.event.addDomListener(document.getElementById("'.$this->marker['lngTextBox'].'"), 
					\'change\', function(event){
					newpos	=	new google.maps.LatLng ($("#'.$this->marker['latTextBox'].'").val(), 
						$("#'.$this->marker['lngTextBox'].'").val());
					marker.setPosition(newpos);
					map.panTo(newpos)
				});	';
		 }
		if($this->marker['findAddress']){
			$this->code.='function findAddress(){
				var address=new Array();';
				foreach($this->marker['address'] as $elm ){
					$this->code.='if($("#'.$elm.'").length > 0 ){
						if($("#'.$elm.'").attr(\'type\')=="text")
							address.push($("#'.$elm.'").val());
						else{
							if($("#'.$elm.'").val()!="")
								address.push($("#'.$elm.' option:selected").text());							}
						}';
				}
				$this->code.='return (address.filter()).join(\'+\'); 	
			}';
			if(!empty($this->marker['eventElm'])){
				foreach($this->marker['eventElm'] as $elm){
				$this->code.= '
				google.maps.event.addDomListener(document.getElementById(\''.$elm.'\'), \'blur\', function(event){
					geocoder = new google.maps.Geocoder();
					geocoder.geocode( { \'address\': findAddress()}, function(results, status){	
						if(status == google.maps.GeocoderStatus.OK){
							geopos	=	results[0].geometry.location;
							marker.setPosition(geopos);
							map.panTo(geopos);
				 			$("#'.$this->marker['latTextBox'].'").val(geopos.lat());
				  			$("#'.$this->marker['lngTextBox'].'").val(geopos.lng());			
					  	} 
					});		
				});';	
				}
			}
		  }
		  $this->code.= '});</script>';
	}
	public function addMarker($settings)
	{
		$this->marker['lat']='10.0151582';
		$this->marker['lng']='76.3130259';
		$this->marker['zoom']=14;
		$this->marker['map']='map';
		$this->marker['title']='';
		$this->marker['click']='true';
		$this->marker['icon']='';
		$this->marker['info']='';
		$this->marker['draggable']='true';
		$this->marker['address']=array();
		$this->marker['eventElm']=array();
		$this->marker['mapContainer']='map';
		$this->marker['findAddress']=false;
		$this->marker['textBoxEnabled']=false;
		if(isset($settings['latLngTextBox'])){
			$this->marker['latTextBox']=$this->marker['lat']=$settings['latLngTextBox'][0];
			$this->marker['lngTextBox']=$this->marker['lng']=$settings['latLngTextBox'][1];
			$this->marker['textBoxEnabled']=true;
		}
		if(isset($settings['latLng'])){
			$this->marker['lat']=$settings['latLng'][0];
			$this->marker['lng']=$settings['latLng'][1];
		}
		if(isset($settings['map']))
			$this->marker['map']=$settings['map'];
		if(isset($settings['isclickable']))	
			$this->marker['isclickable']=$settings['isclickable'];
		if(isset($settings['title']))	
			$this->marker['title']=$settings['title'];
		if(isset($settings['info']))	
			$this->marker['info']=$settings['info'];
		if(isset($settings['address'])){
			$this->marker['address']=$settings['address'];
			$this->marker['findAddress']=true;
		}
		if(isset($settings['changeTags']))	
			$this->marker['eventElm']=$settings['changeTags'];
		if(isset($settings['zoom']))	
			$this->marker['zoom']=$settings['zoom'];
		if(isset($settings['draggable']))	
			$this->marker['draggable']=$settings['draggable'];
		if(isset($settings['mapContainer']))	
			$this->marker['mapContainer']=$settings['mapContainer'];
	}
	public function showmap()
	{
		$this->start();
		return $this->code;
	}
	//FUNCTION TO CHEK WHETHR THE URL TABLE EXISTS
	public function checkForTable($tableName)
	{
		$sqlShowTable	=	"SHOW TABLES LIKE '".DB_PREFIX.$tableName."'";		
		$countOfRecord	=	$this->ObjDatabase->numberOfRecords($sqlShowTable);
		return $countOfRecord;
	}
	public function getLatLng($address,$returnType='text')
	{
		$xml = simplexml_load_file( "http://maps.google.com/maps/api/geocode/xml?address=".$address."&sensor=false" );
		if($xml->status=='OK'){
			$lat=$xml->result->geometry->location->lat;	
			$lng=$xml->result->geometry->location->lng;	
			if($returnType=='array')
				return array('lat'=>$lat,'lng'=>$lng);
			else if($returnType=='text')
				return $lat.",".$lng;
			else	
				return 'Second parameter: \'array\',\'text\' or null';
			}
		else
			return 'No Result';
	}
	public function googlePlaceAutoComplete($name,$showgoogle=true,$script=true)
	{
		if($script)
			$code='<script src="https://maps.googleapis.com/maps/api/js?sensor=false&libraries=places"></script>';
		$code.='<script>
				$(document).ready(function(){
				 	function initialize(input){
			        	var autocomplete = new google.maps.places.Autocomplete(input);
				}
				$("'.$name.'").live(\'focus\',function(){
					google.maps.event.addDomListener(window, \'load\', initialize($(this)[0]));
				});
			});
			</script>';
		if(!$showgoogle){
			$code.='<style>.pac-container::after{content:none;}</style>';
		}	
		return $code;	
	}
}