<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/	//
//$Id: CountryModel.php, v 1.0 2013/03/14 14:14:14
	class CountryModel extends Model 
	{
		public function listCountries($languageIDs,$countryAvailable="Yes",$limitFrom=0,$limitTo="",$sortOrder="ASC",$keywords="",$stateCount="No",$addressFormat="No",$priorityType="All")   
		{
			$sql  ="
					SELECT ";
			if($limitTo)
				$sql.= " 
						SQL_CALC_FOUND_ROWS ";
			$sql     .= " 
						cntry.countryID,
						cntryDet.countryName,
						cntry.*";
			// BASED ON ADDRESS FORMAT  REQUIREMENT			
			if($addressFormat=="Yes")
				$sql.= "
						,addFor.addressFormat";
			// BASED ON STATE COUNT REQUIREMENT			
			if($stateCount=="Yes")
				$sql.= "
						,COUNT(sta.stateID) as stateCount";
			$sql    .= " 
					FROM   
						".DB_PREFIX."countries cntry
					LEFT JOIN 
						".DB_PREFIX."country_details cntryDet 
						ON
						(
							cntryDet.countryID= cntry.countryID
							AND  cntryDet.languageID = '".$languageIDs['Current']."'
						)";
			// BASED ON ADDRESS FORMAT  REQUIREMENT			
			if($addressFormat=="Yes"){
				$sql       .= " 
				
					LEFT JOIN 
						".DB_PREFIX."address_formats addFor 
						ON cntry.addressFormatID=addFor.addressFormatID";
			}
			// BASED ON STATE COUNT REQUIREMENT			
			if($stateCount=="Yes") {
				$sql   .= " 
					LEFT JOIN  
						".DB_PREFIX."states sta 
						ON
						(
							cntry.countryID=sta.countryID 
							AND sta.stateStatus <>'Delete'
						)";
			}
			$sql   .= "  
					WHERE 
						1 ";
			//SELECT WITH STATUS			
			if($countryAvailable){
				$sql         .= " 
						AND  cntry.countryAvailable = '".$countryAvailable."'";
			}			
			if($keywords){
				$sql         .= "
						AND  cntryDet.countryName like '".$keywords."%' ";
			}
			// SORT ORDER/PRIORITY 			
			if($priorityType!="All") {				
				if($priorityType!="NotAssined") {
					$sql   .= " 
						AND  cntry.countryPriority != '256'";
					$sql   .= " 
					GROUP BY
						cntry.countryID  
					ORDER BY
						cntry.countryPriority ".$sortOrder."";
				} else {
					$sql   .= " 
						AND  cntry.countryPriority = '256'";
					$sql    .= "
					GROUP BY
						cntry.countryID  
					ORDER BY
						cntryDet.countryName ".$sortOrder."";
				}

			} else {
				$sql        .= "
					GROUP BY
						cntry.countryID 
			 		ORDER BY
						cntry.countryPriority,
						cntryDet.countryName ".$sortOrder."";
			}
			//IF PAGINATION REQUIRED			
			if($limitTo) {
				$sql   .= " 
					LIMIT
						".$limitFrom.",".$limitTo."";
			}
			return $this->ObjDatabase->readValues($sql);
		}
		function saveCountry($languageIDs,$POST,$countryID)   {
			if($countryID){
				//SET SELECTED
				$countryName    = $this->escape($POST['countryName']);
				$countryIsoA2    = $POST['countryIsoA2'];
				$countryIsoA3    = $POST['countryIsoA3'];
				$countryIsoNumber    = $POST['countryIsoNumber'];
				$countryAvailable    = $POST['countryAvailable'];
				$addressFormatID     = $POST['addressFormatID'];
				$sql = "
				UPDATE  
					".DB_PREFIX."countries
				SET 
					countryAvailable='".$countryAvailable."',       															                	countryIsoA2='".$countryIsoA2."',
					countryIsoA3='".$countryIsoA3."',
					countryIsoNumber='".$countryIsoNumber."',
					addressFormatID='".$addressFormatID."'
				WHERE 
					countryID='".$countryID."'";
				$resUpdateCountry             = $this->ObjDatabase->setQuery($sql);
				if($this->isCountryWithLanguageIDExists($languageIDs['Current'],$countryID)){
					$sql = "
					UPDATE  
						".DB_PREFIX."country_details 
					SET 
						countryName='".$countryName."',
						languageID='".$languageIDs['Current']."' 
					WHERE 
						countryID='".$countryID."' 
						AND  languageID='".$languageIDs['Current']."'";
					$resUpdateCountryDetails      = $this->ObjDatabase->setQuery($sql);
				} else {
					 $sql   =   "
					 INSERT INTO 
						`".DB_PREFIX."country_details`(
							`countryID`, 
							`languageID`, 
							`countryName`
						)VALUES(
							'".$countryID."',
							'".$languageIDs['Current']."',
							'".$countryName."'
						)";
					$resUpdateCountryDetails      = $this->ObjDatabase->setQuery($sql);
				}
			}
			return TRUE;
		}
		function changeCountryStatus($countryIDs,$status){
			$countryBulkStatusCount    = count($countryIDs);
			if($this->escape($status)!='') {
				for($i=0;$i<=$countryBulkStatusCount;$i++){
					$sql = "
					UPDATE  
						".DB_PREFIX."countries 
					SET 
						countryAvailable='".$this->escape($status)."'
				    WHERE 
						countryID='".$countryIDs[$i]."'";
					$resUpdateStatus= $this->ObjDatabase->setQuery($sql);
				}
			}
			return TRUE;
		}
		function getCountryDetails($countryID,$languageIDs=NULL)    
		{
		  $sql= "
			SELECT 
		  		* 
			FROM  
				".DB_PREFIX."countries  countries
			LEFT JOIN  
				".DB_PREFIX."country_details country_details
				ON
				(
					countries.countryID=country_details.countryID
					AND country_details.languageID = '" . $languageIDs['Current'] . "'
				)	 		
			WHERE 
		 		countries.countryID='".$countryID."'";
			return $this->ObjDatabase->readValue($sql);
		}
		function getCountryCode($countryID,$languageID=1,$out='Code')
		{
			$sql = " 
			SELECT 
				cntry.countryIsoA2,
				cntryDet.countryName
			FROM  
				".DB_PREFIX."country_details cntryDet 
			INNER JOIN 
				".DB_PREFIX."countries cntry ON  cntry.countryID=cntryDet.countryID 
			WHERE 
				cntryDet.countryID='".$countryID."' 
				AND cntryDet.languageID='".$languageID."'";
			$resSelectCountry         = $this->ObjDatabase->readValue($sql);
			if($out=='Name')
				return $resSelectCountry['countryName'];
			else
				return $resSelectCountry['countryIsoA2'];
		}
		function listCountryAddressFormat()  {
			$sql	= "
			SELECT  
				addressFormatID, 
	            addressFormat  
			FROM  
				".DB_PREFIX."address_formats";
			return  $this->ObjDatabase->readValues($sql);
		}
		function changeCountryPriority($priorityString)  {
			$sql = "
			UPDATE  
				".DB_PREFIX."countries 
			SET 
				countryPriority='256'";
			$result  = $this->ObjDatabase->setQuery($sql);
			$priorityArray     = explode('~*',$priorityString);
			for($i=0;$i<count($priorityArray);$i++) {
				$curr_PriorityArray          = explode('->',$priorityArray[$i]);
				if($curr_PriorityArray[0])  {
					$sql= "
					UPDATE  
						".DB_PREFIX."countries 
					SET 
						countryPriority='".$curr_PriorityArray[1]."'
			       	WHERE 
						countryID='".$curr_PriorityArray[0]."'";
					$result  = $this->ObjDatabase->setQuery($sql);
				}
			}
			return TRUE;
		}
		
		function listCountryAlphabets($languageIDs)  {
			$sql = "
			SELECT 
				DISTINCT SUBSTRING(cntryDet.countryName,1,1) AS countryName 
			FROM
				".DB_PREFIX."countries cntry,
				".DB_PREFIX."country_details cntryDet
			WHERE 
				cntry.countryID=  cntryDet.countryID  
				AND cntryDet.languageID='1'
			ORDER BY cntryDet.countryName";
			return $this->ObjDatabase->readValues($sql);
		}
		function isCountryWithLanguageIDExists($currentLanguageID,$enableCountryID)
		{
			$sql	=	"
			SELECT 
				* 
			FROM 
				`".DB_PREFIX."country_details` 
			WHERE 
				`languageID` = '".$currentLanguageID."' 
				AND `countryID` = '".$enableCountryID."'";
			$resSelectDeal          =$this->ObjDatabase->numberOfRecords($sql);
			if($resSelectDeal)return true; else return false;
		}
		//Check Countries with same details exits
		public function getCountryCount($languageIDs, $countryID, $countryName='', $countryIsoA2='', $countryIsoA3='',$countryIsoNumber='')
		{
			$sql =   "
			SELECT 
				COUNT(cntry.countryID) AS countryCount  
			FROM 
				`".DB_PREFIX."countries` cntry 
			LEFT JOIN 
				`".DB_PREFIX."country_details` cntryDet
				ON cntry.countryID = cntryDet.countryID 
			WHERE 
				cntryDet.languageID='".$languageIDs['Current']."' ";
			if($countryName)
				$sql    .=" AND cntryDet.countryName ='".$countryName."'  ";
			if($countryIsoA2)
				$sql    .=" AND cntry.countryIsoA2 ='".$countryIsoA2."'  ";
			if($countryIsoA3)
				$sql    .=" AND cntry.countryIsoA3 ='".$countryIsoA3."'  ";
			if($countryIsoNumber)
				$sql    .=" AND cntry.countryIsoNumber ='".$countryIsoNumber."'  ";
			if($countryID>0)
				$sql       .=   " AND cntry.countryID 	!='".$countryID."' ";
			$countryCount  =   $this->ObjDatabase->readValue($sql);
			if($countryCount['countryCount']>0){
				echo "1";
			} else {
				echo "0";
			}
		}
		public function getCountryAddressFormat($languageIDs,$countryID,$stateID='')
		{
			$sql =	"
			SELECT 
				addFor.addressFormat,
				cntryDet.countryName";
			if(is_numeric($stateID) && $stateID >0){
				$sql	.=	",staDet.stateName";
			}
			$sql	.=	"
			FROM 
				".DB_PREFIX."countries cntry
			LEFT JOIN 
				".DB_PREFIX."country_details cntryDet 
				ON
				(
					cntryDet.countryID=cntry.countryID 
					AND cntryDet.languageID='".$languageIDs['Current']."'
				) ";
			if(is_numeric($stateID) && $stateID >0){
				$sql	.=	"
				LEFT JOIN 
					".DB_PREFIX."state_details staDet 
					ON
					(
						staDet.stateID='".$stateID."' 
						AND staDet.languageID='".$languageIDs['Current']."'
					) ";
			}
			$sql	.=	"
			LEFT JOIN 
				".DB_PREFIX."address_formats addFor 
				ON addFor.addressFormatID=cntry.addressFormatID
			WHERE 
				cntry.countryID='".$countryID."' LIMIT 1";
			return $this->ObjDatabase->readValue($sql);					
		}
		// FORMATTING ADDRESS
	public function getFormattedAddress($addressIn,$languageIDs='',$separator='',
	$slice='',$currentLangID='')
	{
		$addressArray	=	array();
		if(!$separator){
			$separator	=	', <br /> ';
		}
		if(is_array($addressIn)){
			$addCount	=	$addressIn;
		}else{
			$addCount		=	explode('~*',$addressIn); 
		} 
		if($slice==2 && count($addCount)==9){
			$addCount	=	array_slice($addCount,2);
		}
		if(count($addCount)==9){
			$defaultFormat	=	array('Fname','Lname','Address1','Address2','City','Province','ZipCode','StateID','CountryID');
			for($k=0;$k<count($defaultFormat);$k++){
				$addressArray[$defaultFormat[$k]]	=	$addCount[$k];
			}
		}else if(count($addCount)==7){
			$defaultFormat	=	array('Address1','Address2','City','Province','ZipCode','StateID','CountryID');
			for($k=0;$k<count($defaultFormat);$k++){
				$addressArray[$defaultFormat[$k]]	=	$addCount[$k];
			}
		}else{
			if($addressIn)
				echo 'WRONG ADDRESS PARAMETER ORDER';
				//throw new Exception('WRONG ADDRESS PARAMETER ORDER'); 
		} 
		if(!empty($addressArray)){
			$countryID	 =	$addCount[count($addCount)-1];
			$stateID	 =	$addCount[count($addCount)-2];
			if(!$currentLangID){
				$ObjLanguage	=	new LanguageModel();
				$contentLangID	=	$ObjLanguage->getContentlanguageID();
				$languageIDs['Current'] 	=	$contentLangID;
			}else{
				$languageIDs['Current']		=	$currentLangID;
			}
			$resAddress	 =	$this->getCountryAddressFormat($languageIDs,$countryID,$stateID);
			$addressArray['stateName']	 =	(is_numeric($stateID))?$resAddress['stateName']:$stateID;
			$addressArray['countryName'] =	$resAddress['countryName'];
			$addressFormat        = explode(",", $resAddress['addressFormat']);
            $addressOut = '';
            foreach ($addressFormat as $format){
                $format = trim($format);
                if ($addressOut != '' && ($format != "Lname" && $format != "Fname" && $format != "County/State" && $format != "Country")){
                    $addressOut .= $separator;
                }
                if ($format == "Fname" && count($addCount)==9){
                    $addressOut .= $addressArray['Fname'] . ' ';
                }else if ($format == "Lname" && count($addCount)==9){
                    $addressOut .= $addressArray['Lname'] . ' ';
                }else if ($format == "Address"){
                    $addressOut .= " " .$addressArray['Address1'];
                    if ($addressArray['Address2'] != ''){
                        $addressOut .= $separator . $addressArray['Address2'];
                    }
                }else if ($format == "City"){
                    $addressOut .= $addressArray['City'];
                }else if ($format == "County/State"){
					$addressOut .= $separator;
					$addressOut .= $addressArray['stateName'] . $addressArray['Province'];
                }else if ($format == "Postcode/Zip Code"){
                    $addressOut .= $addressArray['ZipCode'];
                }else if ($format == "Country"){
					$addressOut .= $separator;
					$addressOut .= $addressArray['countryName'];
                }
            }
		}
		return $addressOut;
	}
        function getCountryNameByID($countryID,$languageIDs=NULL)    
		{
		  $sql= "
			SELECT 
		  		countryName
			FROM 			 
				".DB_PREFIX."country_details 
					 		
			WHERE  languageID = '" . $languageIDs['Current'] . "'
		 		AND countryID='".$countryID."'
                                    LIMIT 1";
			$resCountry= $this->ObjDatabase->readValue($sql);
                        return $resCountry['countryName'];
		}
	//END FUNCTION
}