<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/
//
//$Id: EmailtemplateModel.php, v 1.0 2011/06/14 20:52:11
//
class EmailtemplateModel extends Model{
//FUNCTION TO LIST EMAIL TEMPLATES
    public function listEmailTemplates()
    {
        $sql					   	 = "SELECT 
											    emaTemGro.templateGroupID,
											    emaTemGro.groupKey,
											    emaTemGro.groupLabel,
											    emaTem.emailTempID,
											    emaTem.emailTemplateName,
											    emaTem.emailKey 
                                       FROM
									   		     ".DB_PREFIX."email_template_group AS emaTemGro
                                       LEFT JOIN ".DB_PREFIX."email_template AS emaTem
                                       ON(emaTemGro.templateGroupID = emaTem.templateGroupID)   
										WHERE status='Active'
									   ORDER BY
									   		     emaTemGro.priority ASC,emaTem.emailSortOrder ASC";
        $result					   	 = $this->ObjDatabase->readValues($sql);
        return $result;
    }
//END OF FUNCTION
//FUNCTION TO GET EMAIL TEMPLATE DETAILS
    public function getEmailTemlateDetails($languageIDs,$emailTempID="",$emailKey="")
    {
       $sql				   			 = "SELECT 
	   										*
                                       FROM 
									           `".DB_PREFIX."email_template` AS emaTem
                                       LEFT JOIN ".DB_PREFIX."email_template_details AS emaTemDet
                                       ON
									   (
									   		emaTem.emailTempID      = emaTemDet.emailTempID
									   		AND emaTemDet.languageID = '".(int) $languageIDs['Current']."'
										)
                                       WHERE 1 ";
	 	 if($emailTempID){
			  $sql		  		   .= " AND  emaTem.emailTempID   = '".(int)$emailTempID."'";
		  }									
		 if($emailKey){
			  $sql		  				.= " AND emaTem.emailKey='".$emailKey."'";
		  }	
        $result            			 	= $this->ObjDatabase->readValue($sql); 
		$result['emailHtml'] 		 	= htmlspecialchars_decode($result['emailHtml']);
		$result['emailSubject'] 	 	= htmlspecialchars_decode($result['emailSubject']);      
        return $result;
    }
//END OF FUNCTION
//FUNCTION TO SAVE EMAIL TEMPLATE
      public function saveEmailTemplate($languageIDs,$POST,$emailTempID="")
    {
        $defultLanguageID      			=   $languageIDs['Default'];
        $currentLanguageID      		=   $languageIDs['Current'];
        $emailTempDetID         		= 	$POST['emailTempDetID'];        
        if($emailTempID) {
            $sqlUpdateEmailTemplate 	= "UPDATE `".DB_PREFIX."email_template` SET
                                       			  emailFromName    = '".$this->escape($POST['emailFromName'])."',
                                       			  emailFromEmail   = '".$this->escape($POST['emailFromEmail'])."'
                                      	   WHERE emailTempID='".$emailTempID."'" ;
            $resUpdateEmailTemplate 	= $this->ObjDatabase->setQuery($sqlUpdateEmailTemplate);
           $sqlCheckDetailsExists  		= "SELECT 
		   									     COUNT(*)
									  	   FROM ".DB_PREFIX."email_template_details
                                           WHERE emailTempID = '".$emailTempID."'
                                            	 AND languageID = '".$currentLanguageID."'";
            $sqlCheckDetailsExists  	= $this->ObjDatabase->readValue($sqlCheckDetailsExists) ;
            if($resUpdateEmailTemplate && $sqlCheckDetailsExists[0]>0) {
			
                 $sqlUpdateEmailTempDet =  "UPDATE ".DB_PREFIX."email_template_details SET
                                            		emailSubject     = '".$this->escape($POST['emailSubject'])."',
                                            		emailHtml        = '".$this->escape($POST['emailHtml'],FALSE)."',
                                            		emailText        = '".$this->escape($POST['emailText'])."',
													lastUpdatedDate  = NOW()
                                             WHERE emailTempID 		 = '".$emailTempID."'
                                               	   AND languageID    = '".$currentLanguageID."'";
                $resUpdateEmailTempDet  = $this->ObjDatabase->setQuery($sqlUpdateEmailTempDet);
                return $resUpdateEmailTempDet;
            }
            else if($sqlCheckDetailsExists[0]==0){			
                $insert             =   true;
            }
        }
        else {		
            $sqlInsertEmailTemplate = "INSERT INTO `".DB_PREFIX."email_template`
									   (
                                        emailFromName,
                                        emailFromEmail,
                                        emailTemplateName,
                                        emailSendToKey
                                        )
                                        VALUES
										(
                                        '".$this->escape($POST['emailFromName'])."',
                                        '".$this->escape($POST['emailFromEmail'])."',
                                        '".$this->escape($POST['emailSubject'])."',
                                        '".strtoupper(str_replace(' ', '_', $this->escape($POST['emailSubject'])))."'
                                        )"; 
            $resInsertEmailTemplate = $this->ObjDatabase->setQuery($sqlInsertEmailTemplate);
            if($resInsertEmailTemplate) {
                $emailTempID 		= $this->ObjDatabase->getInsertId();
                $insert      		= true;               
            }
        }
        if($insert){
              $sqlInsertEmailTempDetails= "INSERT INTO ".DB_PREFIX."email_template_details(
                                             emailTempID,
                                             languageID,
                                             emailSubject,
                                             emailHtml,
                                             emailText,
											 lastUpdatedDate)
                                             VALUES(
                                             ".$emailTempID.",
                                             ".$currentLanguageID.",
                                             '".$this->escape($POST['emailSubject'])."',
                                             '".$this->escape($POST['emailHtml'],FALSE)."',
                                             '".$this->escape($POST['emailText'])."',
											 NOW()
                                             )";
               $resInsertEmailTempDetails = $this->ObjDatabase->setQuery($sqlInsertEmailTempDetails);
               return $resInsertEmailTempDetails;
        }
        return true;
	}
//END OF FUNCTION
//FUNCTION TO GET EMAIL TEMPLATE SECTION
    public function getEmailTempSection($languageIDs,$section)
    {
         $defultLanguageID   			 = $languageIDs['Default'];
         $currentLanguageID  			 = $languageIDs['Current'];
         $sql							 = "SELECT 
		 										*
		 									FROM 
												".DB_PREFIX."email_template_sectons
                                            WHERE sectionUniqueString ='".$section."'
                                            AND sectionStatus='Active'
                                            AND languageID='".$currentLanguageID."' ";
					
			$result					 	= 	$this->ObjDatabase->readValue($sql);
			$result['sectionContent'] 	=   htmlspecialchars_decode($result['sectionContent']);	
                        
            return $result;
    }
//END OF FUNCTION
    public function getEmailTempSections($languageIDs,$status='Active')
    {
        $defultLanguageID   			= $languageIDs['Default'];
        $currentLanguageID  			= $languageIDs['Current'];
        $sql					 		= "SELECT 
												sectionUniqueString,
												sectionName,
												sectionContent
                                          FROM ".DB_PREFIX."email_template_sectons
                                          WHERE 
										  		sectionStatus='".$status."'
                                          IF(
										  EXISTS
										  (
										    SELECT
											      emailTempSecID
											FROM ".DB_PREFIX."email_template_sectons 
										    WHERE 
										  		languageID='".$currentLanguageID."'),
												languageID='".$currentLanguageID."',
										  		languageID='".$defultLanguageID."')";
        $result							= $this->ObjDatabase->readValues($sql);
		return $result;
    }
 public function saveEmailTempSections($languageIDs,$POST,$section)
    {
        $defultLanguageID   			= $languageIDs['Default'];
        $currentLanguageID  			= $languageIDs['Current'];
        $sectionContent     			= $this->escape($POST['sectionContent'],FALSE);
        $section           				= 'email_'.$section;
     	$sql						  	= "UPDATE ".DB_PREFIX."email_template_sectons SET
                                       			  sectionContent = '".$sectionContent ."'
                                    	   WHERE 
										          languageID='".$currentLanguageID."' 
										          AND sectionUniqueString = '".$section."'  " ; 
        $result							= $this->ObjDatabase->setQuery($sql);
		return $result;
    }
	public function getEmailTemplates($languageIDs,$groupKey,$languageXml='',$emailTemplateID='')
	{
		$sql	=	"	SELECT emaTem.emailTempID,emaTem.emailTemplateName 
						FROM	".DB_PREFIX."email_template_group AS emaTemGro
						LEFT JOIN	".DB_PREFIX."email_template AS emaTem
							ON	emaTem.templateGroupID	=	emaTemGro.templateGroupID
						WHERE
							emaTemGro.groupKey	=	'".$groupKey."'";
		$result	=	$this->ObjDatabase->readValues($sql);
		$emailTemplateArr	=	array();
		$options	='';
		foreach($result AS $resultArr){
			$options .= "<option value=".$resultArr['emailTempID']."";
			if($emailTemplateID	!= '' && $emailTemplateID == $resultArr['emailTempID']){
				$options	.=	" selected=selected ";
			}
			$options .= " >".$languageXml[$resultArr['emailTemplateName']]."</option>";
		}
		return $options;	
	}
}