<?php
/***************************************************************************
 *                                                                          *
 * Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
 *                                                                          *
 * This  is  commercial  software,  only  users  who have purchased a valid *
 * license  and  accept  to the terms of the  License Agreement can install *
 * and use this program.                                                    *
 *                                                                          *
 ****************************************************************************
 * PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
 * "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
 ****************************************************************************/
//
//$Id: ImageModel.php, v 1.0 2011/06/14 20:52:11
//
class ImageModel
{
	public $imageSizeX;
	public $imageSizeY;
	public $resizeX;
	public $resizeY;
	public $reduction_height;
	public $reduction_width;
	public $fileName;
	public $msg;
	public $image;
	public $imageType;
	//FUNCTION TO RESIZE IMAGE 
	public function resizeImage($imgName, $red_width, $red_height)
	{
		$this->reduction_height = $red_height;
		$this->reduction_width  = $red_width;
		if (is_file($imgName))
		{
			if (file_exists($imgName))
			{
				$this->fileName = $imgName;
				$this->getSize();
				$this->setSize();
				$this->resizeIt();
				$this->saveImage($imgName);
			}
			else
			{
				$this->errorState(0);
			}
		}
		else
		{
			$this->errorState(2);
		}
	}
	//END OF FUNCTION
	//FUNCTION TO SET IMAGE SIZE   
	public function setSize()
	{
		$ratio_image = $this->imageSizeX / $this->imageSizeY;
		$ratio       = $this->reduction_width / $this->reduction_height;
		if ($ratio_image < $ratio)
		{
			$ratio_image   = $this->imageSizeX / $this->imageSizeY;
			$this->resizeY = $this->reduction_height;
			$this->resizeX = round($ratio_image * $this->resizeY);
		}
		else
		{
			$ratio_image   = $this->imageSizeY / $this->imageSizeX;
			$this->resizeX = $this->reduction_width;
			$this->resizeY = round($ratio_image * $this->resizeX);
		}
	}
	//END OF FUNCTION      
	//FUNCTION TO SAVE IMAGE 
	public function saveImage($imgName)
	{
		switch ($this->imageType)
		{
			case "gif":
				imagegif($this->image, $imgName);
				break;
			case "jpg":
				imagejpeg($this->image, $imgName, 100);
				break;
			case "png":
				imagepng($this->image, $imgName);
				break;
		}
	}
	//END OF FUNCTION
	//FUNCTION TO GET SIZE       
	public function getSize()
	{
		$imgParams        = getimagesize($this->fileName);
		$this->imageSizeX = $imgParams[0];
		$this->imageSizeY = $imgParams[1];
		switch ($imgParams[2])
		{
			case 1:
				$this->imageType = "gif";
				$this->image     = imagecreatefromgif($this->fileName);
				break;
			case 2:
				$this->imageType = "jpg";
				$this->image     = imagecreatefromjpeg($this->fileName);
				break;
			case 3:
				$this->imageType = "png";
				$this->image     = imagecreatefrompng($this->fileName);
				//$this->image=imagealphablending($this->image, false);
				//	$this->image=imagesavealpha($this->image, true);
				break;
			default:
				$this->errorState(1);
		}
	}
	//END OF FUNCTION
	//FUNCTION  TO RESIZE     
	public function resizeIt()
	{
		if ($this->imageSizeX <= $this->resizeX)
		{
			$this->resizeX = $this->imageSizeX;
		}
		if ($this->imageSizeY <= $this->resizeY)
		{
			$this->resizeY = $this->imageSizeY;
		}
		$copy  = imagecreatetruecolor($this->resizeX, $this->resizeY);
		/* Setting transparent background for png */
		$color = imagecolorallocate($copy, 255, 255, 255);
		// Fill the background with white
		imagefill($copy, 0, 0, $color);
		// Alpha blending must be enabled on the background!
		imagealphablending($copy, TRUE);
		/* Setting transparent background for png */
		if ($copy)
		{
			if (imagecopyresampled($copy, $this->image, 0, 0, 0, 0, $this->resizeX, $this->resizeY, $this->imageSizeX, $this->imageSizeY))
			{
				if (imagedestroy($this->image))
				{
					$this->image = $copy;
				}
				else
				{
					$this->errorState(6);
				}
			}
			else
			{
				$this->errorState(4);
			}
		}
		else
		{
			$this->errorState(5);
		}
	}
	//END OF FUNCTION
	//FUNCTION FOR ERROR SHOW      
	public function errorState($err)
	{
		switch ($err)
		{
			case 0:
				$this->msg = "File Not Found.";
				break;
			case 1:
				$this->msg = "Invalid File Type.";
				break;
			case 2:
				$this->msg = "Invalid Input.";
				break;
			case 3:
				$this->msg = "Could Not Save.";
				break;
			case 4:
				$this->msg = "Could not Create Image.";
				break;
			case 5:
				$this->msg = "Could not Create Blank File.";
				break;
			case 6:
				$this->msg = "Unable to Destroy Old File.";
				break;
		}
		print $this->msg;
	}
	//END OF FUNCTION
	//FUNCTION TO GENERATE CODE	
	function generateCode($ObjSession, $characters)
	{
		/* list all possible characters, similar looking characters and vowels have been removed */
		$possible = '23456789bcdfghjkmnpqrstvwxyzYUIJHNMVSEDF';
		$code     = '';
		$i        = 0;
		while ($i < $characters)
		{
			$code .= substr($possible, mt_rand(0, strlen($possible) - 1), 1);
			$i++;
		}
		return $code;
	}
	//END OF FUNCTION
	//FUNCTION FOR CAPTCHA
	function CaptchaSecurityImages($width, $height, $characters = '6', $style)
	{
		$ObjSession = isset($ObjSession)?$ObjSession:'';
		$code      = $this->generateCode($ObjSession, $characters);
		/* font size will be 75% of the image height */
		$font_size = $height * 0.70;
		switch ($style)
		{
			case 'style 1':
				/// black////
				$font_size = $height * 0.52;
				$image = @imagecreate($width + 9, $height) or die('Cannot initialize new GD image stream');
				$font             = __DIR_PUBLIC . '/font/Kids.ttf';
				$background_color = imagecolorallocate($image, 0, 0, 0);
				$text_color       = imagecolorallocate($image, 255, 255, 255);
				$noise_color      = imagecolorallocate($image, 0, 0, 0);
				break;
			case 'style 2':
				//// blue///	
				$font_size = $height * 0.50;
				$image = @imagecreate($width + 9, $height) or die('Cannot initialize new GD image stream');
				$font             = __DIR_PUBLIC . '/font/Almagro Regular.ttf';
				$background_color = imagecolorallocate($image, 255, 255, 255);
				$text_color       = imagecolorallocate($image, 0, 0, 220);
				$noise_color      = imagecolorallocate($image, 192, 192, 192);
				break;
			case 'style 3':
				/// grey////
				$image = @imagecreate($width, $height) or die('Cannot initialize new GD image stream');
				$font             = __DIR_PUBLIC . '/font/monofont.ttf';
				$background_color = imagecolorallocate($image, 240, 240, 240);
				$text_color       = imagecolorallocate($image, 171, 171, 171);
				$noise_color      = imagecolorallocate($image, 240, 240, 240);
				break;
			case 'style 4':
				$font_size = $height * 0.50;
				$image = @imagecreate($width + 9, $height) or die('Cannot initialize new GD image stream');
				$font             = __DIR_PUBLIC . '/font/Verdana.TTF';
				$background_color = imagecolorallocate($image, 0, 200, 0);
				$text_color       = imagecolorallocate($image, 252, 255, 255);
				$noise_color      = imagecolorallocate($image, 0, 200, 0);
				break;
		}
		/* generate random dots in background */
		for ($i = 0; $i < ($width * $height) / 3; $i++)
		{
			imagefilledellipse($image, mt_rand(0, $width), mt_rand(0, $height), 1, 1, $noise_color);
		}
		/* generate random lines in background */
		for ($i = 0; $i < ($width * $height) / 150; $i++)
		{
			imageline($image, mt_rand(0, $width), mt_rand(0, $height), mt_rand(0, $width), mt_rand(0, $height), $noise_color);
		}
		/* create textbox and add text */
		$textbox = imagettfbbox($font_size, 0, $font, $code) or die('Error in imagettfbbox function');
		$x = ($width - $textbox[4]) / 2;
		$y = ($height - $textbox[5]) / 2;
		imagettftext($image, $font_size, 0, $x, $y, $text_color, $font, $code) or die('Error in imagettftext function');
		/* output captcha image to browser */
		header('Content-Type: image/jpeg');
		imagejpeg($image);
		imagedestroy($image);
		unset($_SESSION['captcha_val']);
		echo $_SESSION['captcha_val'] = $code; // carry the data through session
	}
	//END OF FUNCTION  
        function copy_file($source_path, $destination_path,$file_root='',$imgName='') {
        
        if($file_root=='') {
            $file_exists_path = __ROOT_PATH . '/' . $source_path;
        } else {
            $file_exists_path =  $source_path;
        }
        
        if (file_exists($file_exists_path)) {            
            if ($this->upload_images == 'amazon') {    
                
                if($imgName!='') {
                    
                    $this->unlinkImage($destination_path);
                }        
                
                $fullfilename = __ROOT_PATH . '/' . $source_path;
                $result       = $this->client->putObject(array(
                'ACL' => 'public-read',
                'Bucket' => $this->image_bucket,
                'Key' => __DIR_PUBLIC . $destination_path,
                'Body' => EntityBody::factory(fopen($fullfilename, 'r')),
		'CacheControl' => 'max-age=604800'
            ));
                
            } else if ($this->upload_images == 'rackspace') {
                $localFileName  = __ROOT_PATH . '/' . $source_path;
                $remoteFileName = __DIR_PUBLIC . $destination_path;
                $handle         = fopen($localFileName, 'r');
                $this->container->uploadObject($remoteFileName, $handle);
                fclose($handle);
            } else {
                if (!empty($source_path)) {                    
                    copy($source_path, __CORE_PUBLIC_PATH . $destination_path);                        
                }
            }
        }
    }
}