<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/
//$Id: RolesModel.php, v 1.0 2013/03/14 14:14:14
class RolesModel extends Model {

//FETCHING ROLES MODULES
  public function listRolesModules($languageIDs,$adminModuleParentID)	
  {		
		$sql		 = "
		SELECT 
			admMod.adminModuleID,
			admModDet.adminModuleCaption
		FROM 
			".DB_PREFIX."admin_modules admMod ";
		$sql	    .= " 
		LEFT JOIN  
			".DB_PREFIX."admin_module_details admModDet 
			ON  admModDet.adminModuleID=admMod.adminModuleID";
		if($adminModuleParentID>=0) {
			$sql	.= " 
			WHERE 
				admMod.adminModuleParentID='".$adminModuleParentID."'";
		}
		$sql .=	" AND(admMod.adminModuleType='Role' OR admMod.adminModuleType='ALL') 
				  AND admMod.adminModuleStatus='Active'
				  GROUP BY admMod.adminModuleID ";
		return	$this->ObjDatabase->readValues($sql);
  }
 //END OF FUNCTION
 //GET SUB ROLES COUNT
  public function getSubRolesCount($adminModuleParentID=0)	
  {
		$sql =	"
		SELECT 
			COUNT(adminModuleID) AS cnt 
		FROM 
			".DB_PREFIX."admin_modules  
		WHERE 
			adminModuleParentID='".$adminModuleParentID."'
			AND(adminModuleType='Role' OR adminModuleType='ALL')";
		$resSelectRolesModules	=	$this->ObjDatabase->readValue($sql);
		return $resSelectRolesModules['cnt'];
  }
 //END OF FUNCTION
 //FUNCTION  TO FILTER MODULE IDS
  public function filterModulesIDs($listUserTypeModules)
  {
    	return $listUserTypeModules['adminModuleID'];
  }
 //END OF FUNCTION
  //FUNCTION TO LIST ROLES MODULES TREE
  public function listRolesModulesTree($languageIDs,$POST,$userTypeID=array(),$campignEnable='',$manageUserID="")	
  {		
		$userTypeModuleIDs		=	array();
		$privilegeUrls			= 	array();
		$tree_string	="";
  		if($userTypeID){
			$tree_string 	= "";
			$resListUserTypeModules  = $this->listUserTypeModules($userTypeID);
			$userTypeModuleIDs  =(@array_map(array($this, 'filterModulesIDs'),$resListUserTypeModules));
		}
		$resPrivilegeUrls	=	$this->getAutoPrivilegeUrls('Active');
		foreach($resPrivilegeUrls as $PrivilegeUrl){
			$privilegeUrls[$PrivilegeUrl['privilegeUrl']]	=	$PrivilegeUrl['privilegeUrl'];
		}
		return  $this->listRolesModulesTreeItems($languageIDs,0,$tree_string,$tree_level=0,$POST,$userTypeModuleIDs,'','',$privilegeUrls,$campignEnable,$manageUserID);
  }
 //END OF FUNCTION
  //FUNCTION  TO LIST USER TYPE MODULES 
  public function listUserTypeModules($userTypeID,$adminModuleID='')	
  {
		$sql  =	"
		SELECT 
			adminModuleID 
		FROM 
			".DB_PREFIX."admin_user_type_modules
		WHERE 
			userTypeID=".(int)$userTypeID."";
		if($adminModuleID)
			 $sql	.=	" AND adminModuleID=".(int)$adminModuleID."";
		return	$this->ObjDatabase->readValues($sql);
  }
 //END OF FUNCTION
  //FUNCTION  TO GET USER TYPE DETAILS 
  public function getUserTypeDetails($userTypeID)	
  {
		$sql =	"
		SELECT 
			* 
		FROM 
			".DB_PREFIX."admin_user_type 
		WHERE 
			userTypeID='".$userTypeID."'
			AND userTypeStatus!='Deleted'";
		return	$this->ObjDatabase->readValue($sql);
  }
 //END OF FUNCTION
 //FUNCTION  TO LIST USER TYPES
  public function listUserTypes($limitFrom=0,$limitTo="")	
  {
		$sql 	 =	"SELECT "; 
		if($limitTo) {	
			$sql	.=	" SQL_CALC_FOUND_ROWS ";
		}		
		$sql		 .=	" * 
		FROM 
			".DB_PREFIX."admin_user_type  
		WHERE 
			userTypeStatus!='Deleted'
		GROUP BY 
			userTypeID ORDER BY userTypeName ASC";
		if($limitTo)
		 	$sql	 .=	 " LIMIT  ".$limitFrom.",".$limitTo."";
		return	$this->ObjDatabase->readValues($sql);
  }
  //END OF FUNCTION
  
   //FUNCTION  TO LIST ROLES MODULES TREE ITEMS
  public function listRolesModulesTreeItems($languageIDs,$parentID,$tree_string='',$tree_level=0,$POST,$userTypeModuleIDs=array(),$moduleGroupClassArray=array(),$moduleGroupIDsArray=array(),$privilegeUrls=array(),$campignEnable='',$manageUserID="")	
  {	  		
		$resListRolesModules = $this->listRolesModules($languageIDs,$parentID);	
		if($tree_level==0) {
			$tree_string 		= '<ul class="roles_listing treeview" id="tree">';
		} else {
			$tree_string 		= '<ul style="display: none;">';
		}		
		$tree_level++;			
		for($roles_i=0;$roles_i<count($resListRolesModules);$roles_i++)	{		
				$curr_moduleID	 			= $resListRolesModules[$roles_i]['adminModuleID'];
				$moduleKey	=	$this->getModuleKey($curr_moduleID);
				if(($campignEnable!='' && $moduleKey=='emailqueue/index/') || ($campignEnable=='' && $moduleKey=='dailydealemails/schedule/') || (array_key_exists($moduleKey,$privilegeUrls))|| ($manageUserID!=1 && $moduleKey=='report/adminrevenue/') )
					continue;
				$resSubRolesCount 			= $this->getSubRolesCount($curr_moduleID);
				$userTypeModuleIDs		    = isset($POST['moduleIDs'])?$POST['moduleIDs']:$userTypeModuleIDs;
				if(in_array($curr_moduleID,$userTypeModuleIDs))	{
					$RolesModulesChecked= 'checked="checked"';
				}else{
					$RolesModulesChecked= "";
				}				
				if($resSubRolesCount>0)	{
		   			$tree_string 	   	   .= '<li>';
				} else {
				    if($roles_i==(count($resListRolesModules)-1)) {
						$tree_string   .= '<li class="last">';
					} else {
					   $tree_string   .= '<li>';
					}
				}				
				if($resSubRolesCount>0)	{
		   			$tree_string 	   	   .= '<strong>';
					$tree_string 	  	   .= '<a href="javascript:void(0)">';
				}				
				$moduleGroupClass			= ' moduleGroupClass_'.$parentID;
				if(!@in_array($moduleGroupClass,$moduleGroupClassArray)) {
					$moduleGroupClassArray[]   .= ' moduleGroupClass_'.$parentID;
				} else {
					$moduleGroupClass			= '';
				}				
				$moduleGroupClass			= implode(" ",$moduleGroupClassArray);								
				if(!@in_array($parentID,$moduleGroupIDsArray) || $parentID==0) {
					$moduleGroupIDsArray[]   .= $parentID;
				}
				$moduleGroupIDs			= implode(",",$moduleGroupIDsArray);
				if($moduleKey=='content/listall/' || $moduleKey=='content/listown/' || $moduleKey=='content/listrole/'){
				$tree_string 	   		   .= '<input tabindex="1" class="moduleGroupClass_all '.$moduleGroupClass.'"  id="moduleID_'.$curr_moduleID.'" 
									   			rel="parentID_'.$parentID.'" name="contentListIDs[]" type="radio" 
												value="'.$curr_moduleID.'" title="'.$moduleGroupIDs.'" '.$RolesModulesChecked.' />';	
			  }elseif($moduleKey=='content/editall/' || $moduleKey=='content/editown/' || $moduleKey=='content/editrole/'){
				  $tree_string 	   		   .= '<input tabindex="1" class="moduleGroupClass_all '.$moduleGroupClass.'"  id="moduleID_'.$curr_moduleID.'" 
									   			rel="parentID_'.$parentID.'" name="contentEditIDs[]" type="radio" 
												value="'.$curr_moduleID.'" title="'.$moduleGroupIDs.'" '.$RolesModulesChecked.' />';
			  }elseif($moduleKey=='content/draft/' || $moduleKey=='content/publish/'){
				  $tree_string 	   		   .= '<input tabindex="1" class="moduleGroupClass_all '.$moduleGroupClass.'"  id="moduleID_'.$curr_moduleID.'" 
									   			rel="parentID_'.$parentID.'" name="moduleIDs[]" type="radio" 
												value="'.$curr_moduleID.'" title="'.$moduleGroupIDs.'" '.$RolesModulesChecked.' />';
			  }else{
				  $tree_string 	   		   .= '<input tabindex="1" class="moduleGroupClass_all '.$moduleGroupClass.'"  id="moduleID_'.$curr_moduleID.'" 
									   			rel="parentID_'.$parentID.'" name="moduleIDs[]" type="checkbox" 
												value="'.$curr_moduleID.'" title="'.$moduleGroupIDs.'" '.$RolesModulesChecked.' />';
			  }
				if($moduleKey=='deal/index/'){
					$tree_string 	  		   .= '&nbsp;'.'List Deal'.'';
				}else if($moduleKey=='deal/new/id/'){								
					$tree_string 	  		   .= '&nbsp;'.$resListRolesModules[$roles_i]['adminModuleCaption'].'<span class="sub-text">(Need any of the deal add privilege to access this role)</span>';
				}else{								
					$tree_string 	  		   .= '&nbsp;'.$resListRolesModules[$roles_i]['adminModuleCaption'].'';
				}
				if($resSubRolesCount>0)	{
					$tree_string 	   	   .= '</a>';
					$tree_string 	       .= '</strong>';
				}		   		
				if($resSubRolesCount>0)	{
					$tree_string 		   .= $this->listRolesModulesTreeItems($languageIDs,$curr_moduleID,$tree_string,$tree_level,$POST,$userTypeModuleIDs,$moduleGroupClassArray,$moduleGroupIDsArray,$privilegeUrls,$campignEnable,$manageUserID);
				} 
				if($parentID==0) {
				$moduleGroupClassArray          = array();
			}
			$tree_string 			   .= '</li>';		
		}
		$tree_string 				       .= '</ul>';
		return $tree_string;
  }
 //END OF FUNCTION
  //FUNCTION TO SAVE USER TYPE MODULES  
  public function saveUserTypeModules($POST,$userTypeID=0)
  {
		$userTypeName				=	$this->escape($POST['userTypeName']);
		if(!empty($POST['contentListIDs'])){
			$POST['moduleIDs']	=	array_merge($POST['moduleIDs'],$POST['contentListIDs']);
		}
		if(!empty($POST['contentEditIDs'])){
			$POST['moduleIDs']	=	array_merge($POST['moduleIDs'],$POST['contentEditIDs']);
		}
		$moduleIDs					=	$POST['moduleIDs'];
		$userTypeStatus				=	$POST['userTypeStatus'];
		if($moduleIDs){
			array_push($moduleIDs,1);
		}
		$sql	=	"
		DELETE  
		FROM  
			".DB_PREFIX."admin_user_type_modules 
		WHERE 
			userTypeID='".$userTypeID."'";
		$resDeleteRolesModules  	=	$this->ObjDatabase->setQuery($sql);
		if($userTypeID>0) {
			$sql	=	"
			UPDATE  
				".DB_PREFIX."admin_user_type 
			SET 
				userTypeName='".$userTypeName."',
				userTypeStatus='".$userTypeStatus."'";
			$sql .=   "WHERE userTypeID='".$userTypeID."'";
			$resUpdateRolesModules	=	$this->ObjDatabase->setQuery($sql);
		} else {
		    $sql	=	"
			INSERT INTO 
				".DB_PREFIX."admin_user_type(
					userTypeName,
					userTypeStatus
				)VALUES(
					'".$userTypeName."',
					'".$userTypeStatus."'
				)";
			$resInsertRolesModules	=	$this->ObjDatabase->setQuery($sql);
			$userTypeID				= 	$this->ObjDatabase->getInsertId();
		}
		if($moduleIDs){
			for($k=0;$k<count($moduleIDs);$k++){
				$rsKey 	=	$this->getModuleKey($moduleIDs[$k]);
	
				// for business request
				if($rsKey=='business/index/'){  
					$urlKeys	=	array("'business/show/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// for business review
				if($rsKey=='business/edit/'){  
					$urlKeys	=	array("'business/review/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// for business request 
				if($rsKey=='businessrequest/index/'){  
					$urlKeys	=	array("'businessrequest/show/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// for deal request 
				if($rsKey=='product/request/'){  
					$urlKeys	=	array("'product/requestshow/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// for user
				if($rsKey=='user/index/'){  
					$urlKeys	=	array("'user/show/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				if($rsKey=='user/edit/'){  
					$urlKeys	=	array("'user/status/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// order show
				if($rsKey=='order/edit/'){  
					$urlKeys	=	array("'order/show/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// affiliate request details
				if($rsKey=='affiliaterequest/'){  
					$urlKeys	=	array("'affiliaterequest/show/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// coupon status change
				if($rsKey=='coupon/index/'){  
					$urlKeys	=	array("'coupon/status/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// shipping edit
				if($rsKey=='shipping/index/' || $rsKey=='shipping/shipped/'){  
					$urlKeys	=	array("'shipping/edit/'","'shipping/label/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// shipping edit
				if($rsKey=='emailqueue/index/'){  
					$urlKeys	=	array("'emailqueue/preview/'","'newsletter/edit/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// newsletter preview
				if($rsKey=='newsletter/archieve/'){  
					$urlKeys	=	array("'newsletter/preview/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// subscriber sample csv
				if($rsKey=='subscriber/import/'){  
					$urlKeys	=	array("'subscriber/samplecsv/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// adbanner details
				if($rsKey=='adbanner/index/'){  
					$urlKeys	=	array("'adbanner/details/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// language download
				if($rsKey=='language/index/'){  
					$urlKeys	=	array("'language/download/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// email template view 
				if($rsKey=='emailtemplate/index/'){  
					$urlKeys	=	array("'emailtemplate/show/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// affiliate view 
				if($rsKey=='affiliate/index/'){  
					$urlKeys	=	array("'affiliate/show/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// sales details
				if($rsKey=='report/sale/'){  
					$urlKeys	=	array("'report/salesdetails/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// deal details
				if($rsKey=='report/deal/'){  
					$urlKeys	=	array("'report/dealdetails/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// referral report 
				if($rsKey=='report/referral/'){  
					$urlKeys	=	array("'report/userreferral/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// salesrep report 
				if($rsKey=='report/salesrep/'){  
					$urlKeys	=	array("'report/salesRepBusiness/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// affiliate report
				if($rsKey=='report/affiliate/'){  
					$urlKeys	=	array("'report/affiliateorder/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// analytics dashboard 
				if($rsKey=='analytics/'){  
					$urlKeys	=	array("'analytics/index/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// analytics bounce urls 
				if($rsKey=='analytics/bounce/'){  
					$urlKeys	=	array(
						"'analytics/pageBounce/'",
						"'analytics/browserBounce/'",
						"'analytics/refBounce/'",
						"'analytics/osBounce/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// analytics traffic urls 
				if($rsKey=='analytics/traffic/'){  
					$urlKeys	=	array(
						"'analytics/refTraffic/'",
						"'analytics/affTraffic/'",
						"'analytics/searchEngineTraffic/'",
						"'analytics/keywordTraffic/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// business payment 
				if($rsKey=='business/payment/'){  
					$urlKeys	=	array(
						"'business/paymentnotpaid/'",
						"'business/paymentpaid/'",
						"'business/dealorderpaymentnotpaid/'",
						"'business/dealorderpaymentpaid/'",
						"'business/dealorderpaymenttransaction/'",
						"'business/dealpaymentpaid/'",
						"'business/dealpaymentnotpaid/'",
						"'business/dealpaymenttransaction/'",
						"'business/transaction/'",
						"'business/transactiondetails/'",
						"'business/transactioncancel/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// affiliate payment 
				if($rsKey=='affiliate/paymentnotpaid/'){  
					$urlKeys	=	array(
					"'affiliate/paymentpaid/'",
					"'affiliate/affiliateOrderPaymentNotPaid/'",
					"'affiliate/affiliateOrderPaymentPaid/'",
					"'affiliate/affiliateOrderTransaction/'",
					"'affiliate/transaction/'","'affiliate/transactionCancel/'",
					"'affiliate/transactiondetails/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// affiliate user csv 
				if($rsKey=='affiliate/importuser/'){  
					$urlKeys	=	array("'affiliate/sampleCsvUser/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// affiliate subscriber csv 
				if($rsKey=='affiliate/importSubscriber/'){  
					$urlKeys	=	array("'affiliate/sampleCsvSubscribe/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// generate campaign  
				if($rsKey=='campaign/index/'){  
					$urlKeys	=	array("'campaign/generateCampaign/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// campaign   actions
				if($rsKey=='campaign/calendar/'){  
					$urlKeys	=	array(
						"'campaign/edit/'",
						"'campaign/zipDownload/'",
						"'campaign/generateCampaign/'",
						"'campaign/configXml/'",
						"'campaign/campaignXml/'",
						"'campaign/saveBanner/'",
						"'campaign/uploadImageList/'",
						"'campaign/imageupload/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// banners
				if($rsKey=='banner/index/'){  
					$urlKeys	=	array("'banner/show/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// agreements
				if($rsKey=='agreements/index/'){  
					$urlKeys	=	array("'agreements/view/'","'agreements/download/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// product details
				if($rsKey=='product/index/'){  
					$urlKeys	=	array("'product/show/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// attribute set
				if($rsKey=='attribute/editattributeset/'){  
					$urlKeys	=	array("'attribute/addattributegroup/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// email template edit
				if($rsKey=='newsletter/emailtemplates/'){  
					$urlKeys	=	array("'newsletter/emailtemplatesEdit/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// promocode details
				if($rsKey=='promocode/index/'){  
					$urlKeys	=	array("'promocode/show/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// payment gateway details
				if($rsKey=='paymentgateway/index/'){  
					$urlKeys	=	array("'paymentgateway/show/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// shipping method services, details
				if($rsKey=='shippingmethod/index/'){  
					$urlKeys	=	array("'shippingmethod/options/'","'shippingmethod/show/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// analytics top engaged user
				if($rsKey=='analytics/topengaged/'){  
					$urlKeys	=	array("'analytics/topbusy/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// analytics email statistics
				if($rsKey=='analytics/email/'){  
					$urlKeys	=	array("'analytics/emailShow/'","'analytics/emailPreviewMail/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// live cart recovery
				if($rsKey=='analytics/cart//'){  
					$urlKeys	=	array("'analytics/cartRecovery/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}
				// Shipment view
				if($rsKey=='shipping/shipped/'){  
					$urlKeys	=	array("'shipment/show/'");
					$resmoduleIDs	=	$this->getModuleIDs($urlKeys);
				}				
				if($resmoduleIDs){
					foreach($resmoduleIDs as $resmoduleID){
						array_push($POST['moduleIDs'],$resmoduleID);
						array_push($moduleIDs,$resmoduleID);
					}
					$resmoduleIDs  = array();
				}
			}
		}// end if
		$moduleIDsList				=   (count($moduleIDs)>0)?"(".$userTypeID.",".implode("),($userTypeID,",$moduleIDs).")":"";
		if($moduleIDsList!="") {
			$sql	=	"
			INSERT INTO 
				".DB_PREFIX."admin_user_type_modules(
					userTypeID,
					adminModuleID
				) VALUES ".$moduleIDsList."";
			$resInsertRolesModules	=	$this->ObjDatabase->setQuery($sql);
		}
		$this->writePrivilagesToXMLFile($POST,$userTypeID);
		return $resInsertRolesModules;
		}
//END OF FUNCTION
//FUNCTION TO CHANGE USER TYPE STATUS
  public function changeUserTypeStatus($userTypeIDs,$userTypeStatus,$deleteprivilage='')
  {
	  	$userTypeIDString		=	implode(',',$userTypeIDs);
		$resListUserID	=	$this->checkUserRole();
		 foreach($resListUserID as $resListUserID) {
				$usedIDs	.=		$resListUserID[0].",";
				$UserIDArray[]	=	$resListUserID[0];
		}
		$usedIDs	=	substr($usedIDs, 0, -1);
		$commomUserIDs	=	array_intersect($userTypeIDs,$UserIDArray);
		if($userTypeStatus=='Deleted' && $deleteprivilage)
	   		$userTypeStatus	=	$userTypeStatus;
		else if($userTypeStatus!='Deleted')
	   		$userTypeStatus	=	$userTypeStatus;
		else
	   		$userTypeStatus	=	'Active';
  		$sql	=	"
		UPDATE  
			".DB_PREFIX."admin_user_type 
		SET 
			userTypeStatus='".$userTypeStatus."' ";
		if($userTypeStatus=='Deleted'){
		$sql .=   "
		WHERE 
			userTypeID IN (".$userTypeIDString.") AND userTypeID NOT IN (".$usedIDs.")";
		}else{
			$sql .=   "WHERE userTypeID IN (".$userTypeIDString.")";
		}
		$resUpdateRolesModules	=	$this->ObjDatabase->setQuery($sql);
		$userRole				=	$this->getUserRole($commomUserIDs);
		return $userRole;
  }
  //END OF FUNCTION
  //FUNCTION TO CHECK USER ROLE
  function checkUserRole()
	{
	    $sql	=	"
		SELECT 
			admUsr.userTypeID AS roleCount  
		FROM 
			".DB_PREFIX."admin_users admUsr 
		INNER JOIN 
			".DB_PREFIX."admin_user_type admUsrTyp 
			ON
			(
				admUsr.userTypeID=admUsrTyp.userTypeID 
				AND admUsr.adminUserStatus !='Deleted'
			)
		GROUP BY admUsr.userTypeID"; 
		return $this->ObjDatabase->readValues($sql,MYSQL_NUM);
	}
	//END OF FUNCTION
	//FUNCTION TO GET USER ROLE
  function getUserRole($commomUserIDs)
	{
		$commomUserIDs	=	implode(',',$commomUserIDs);
		$sql			=	"SELECT 
								userTypeName 
							FROM 
								".DB_PREFIX."admin_user_type 
							WHERE 
								userTypeID IN(".$commomUserIDs.")";
		$resGetUserRole		=	 $this->ObjDatabase->readValues($sql,MYSQL_NUM);
		foreach($resGetUserRole as $GetUserRole) {
			$userRole		.=		$GetUserRole[0].",";
		}
		$userRole			=	substr($userRole, 0, -1); 
		return $userRole;
	}
	//END OF FUNCTION
	//FUNCTION  TO GET MODULE DETAILS
	function getModuleDetails($adminModuleID,$parentID)
	{
			$sql	=	"
			SELECT 
				admMod.*,
				admModDet.adminModuleLabel,
				(
					SELECT 
						COUNT(adminModuleID) 
					FROM 
						".DB_PREFIX."admin_modules 
					WHERE 
						adminModuleParentID=".(int)$adminModuleID." 
						AND (adminModuleType='Menu' OR adminModuleType='ALL')
				) AS rolesCount
			FROM 
				".DB_PREFIX."admin_modules  admMod
			JOIN 
				".DB_PREFIX."admin_module_details admModDet
				ON (admMod.adminModuleID=admModDet.adminModuleID)
			WHERE  
				admMod.adminModuleParentID!=0";
			if($adminModuleID){
				$sql			.=	"  AND admMod.adminModuleID='".$adminModuleID."' ";
			}
			if($parentID){
				$sql				.=	"  AND admMod.adminModuleParentID='".$parentID."' ";
			}
			return	$this->ObjDatabase->readValue($sql);
	}
	//END OF FUNCTION
	//FUNCTION TO GET USER TYPE ID
	function getUserTypeID($manageUserID)
	{
		$sql =	"
		SELECT 
			admUsr.userTypeID,
			admUsrTyp.userTypeName 
		FROM 
			`".DB_PREFIX."admin_users` admUsr 
		LEFT JOIN 
			`".DB_PREFIX."admin_user_type` admUsrTyp
			ON admUsr.userTypeID=admUsrTyp.userTypeID
		WHERE 
			admUsr.adminUserID='".$manageUserID."'";
		return	$this->ObjDatabase->readVALUE($sql);
	}
	//END OF FUNCTION
	//FUNCTION TO READ PREVILEGE FILE
	function readingPrivilageFile($userTypeName,$userTypeID){
		$userTypeName				=		$this->encodeString($userTypeName,__ENCRYPTION_KEY.$userTypeID);
		define("ADMIN_USER_TYPE_NAME",$userTypeName);
		$fileName					=		__CORE_PUBLIC_CACHE_PATH."/roles/".$userTypeName.".xml";
		if(file_exists($fileName)){
			$xml 						= 		simplexml_load_file($fileName);
			$i							=		0;
			foreach($xml->value  as $value){
				$urlKeyString							=	$this->escape($xml->value[$i]);		
				$privilage_array[$i]['accesURL']		=	htmlentities($urlKeyString);
				$privilage_array[$i]['subLevel']		=	$this->escape($xml->value[$i]['sublevel']);
				$privilage_array[$i]['parentID']		=	$this->escape($xml->value[$i]['parentid']);
				$privilage_array[$i]['id']				=	$this->escape($xml->value[$i]['id']);
				$privilage_array[$i]['label']			=	$this->escape($xml->value[$i]['label']);
				$privilage_array[$i]['autoPrivilege']	=	$this->escape($xml->value[$i]['autoprivilege']);
				$privilage_array[$i]['class']			=	$this->escape($xml->value[$i]['adminModuleStyleClass']);
				$privilage_array[$i]['child']			=	$this->escape($xml->value[$i]['child']);
				$i++;
			}
		}
		//echo "<pre>";
		//print_r($privilage_array);exit;
		return $privilage_array;
	}
	//END OF FUNCTION
	//FUNCTION TO WRITE PRIVILEGES TO XML FILE
	 public function writePrivilagesToXMLFile($POST,$userTypeID)
	{
		$arrayPrivilages                = 		'<?xml version="1.0" encoding="ISO-8859-1"?>';
		$arrayPrivilages              	.=  	'<roles>';
		$userTypeName				   	=		$this->escape($POST['userTypeName']);
		$moduleIDs					   	=		$POST['moduleIDs'];
		$urlKeys	=	array();
		for($i=0;$i<count($moduleIDs);$i++){
			$moduleID				    =	   	$moduleIDs[$i];
			$moduleDetails			  	= 		$this->getModuleDetails($moduleID,'');	
			if($moduleDetails['adminModuleID']){
				if($moduleDetails['rolesCount']>0)
					$subLevel				=	'Yes';	
				else
					$subLevel				=	'No';
				$subLevel					=	 $subLevel;		
				$urlKey						=	 htmlentities(stripslashes($moduleDetails['adminModuleURLKey']));	
				$adminModuleID				=	 $moduleDetails['adminModuleID'];	
				$adminModuleParentID		=	 $moduleDetails['adminModuleParentID'];
				$moduleLabel				=	 $moduleDetails['adminModuleLabel'];
				$class						=	 $moduleDetails['adminModuleStyleClass'];
				$roleCount					=	 $moduleDetails['rolesCount'];				
				if($moduleDetails['adminModuleType']!='Role')
					$autoPrivilege	=	'No';
				else
					$autoPrivilege	=	'Yes';
				$arrayPrivilages        	.= 	'<value  parentid="'.$adminModuleParentID.'" id="'.$adminModuleID.'" sublevel="'.$subLevel.'" label="'.$moduleLabel.'" autoprivilege="'.$autoPrivilege.'" class="'.$class.'" child="'.$roleCount.'">'.$urlKey.'</value>';
			}
		}
		$arrayPrivilages               .=  	'</roles>'; 
		$userTypeName					=	$this->encodeString($userTypeName,__ENCRYPTION_KEY.$userTypeID);	
		$Handle                       	= 	fopen(__CORE_PUBLIC_CACHE_PATH."/roles/".$userTypeName.".xml","w");
		fwrite($Handle,"".$arrayPrivilages."");
		fclose($Handle);
	}
	//END OF FUNCTION
	//FUNCTIONTO GET ALL PRIVILEGES
	function getAllPrivilages()
	{
		$sql =	"
		SELECT 
			*
		FROM 
			`".DB_PREFIX."admin_modules`   
		WHERE  
			`".DB_PREFIX."admin_modules`.adminModuleStatus='Active' 
			AND adminModuleParentID !='0'";
		return $this->ObjDatabase->readvalues($sql);
	}
	//END OF FUNCTION
	//FUNCTION TO CHANGE USER TYPE STATUS
	public function changeRoleStatus($userTypeIDs,$userTypeStatus)
	{
		$sql =	"
		UPDATE  
			".DB_PREFIX."admin_user_type 
		SET 
			userTypeStatus='".$userTypeStatus."' 
		WHERE 
			userTypeID =".(int)$userTypeIDs."
		LIMIT 1";
		return	$this->ObjDatabase->setQuery($sql);
	}
  	//END OF FUNCTION
  	// GET MODULE IDS FROM URL KEYS
	public function getModuleIDs($urlKeys)
	{
		$sql =	"
		SELECT 
			adminModuleID 
		FROM 
			".DB_PREFIX."admin_modules 
		WHERE 
			adminModuleURLKey IN (".implode(',',$urlKeys).") "; 
		$resIDs	=	$this->ObjDatabase->readvalues($sql,MYSQL_NUM);
		foreach($resIDs as $IDs){
			$moduleIDArray[]	=	$IDs[0];
		}
		return $moduleIDArray;
	}
	//END OF FUNCTION
	// GET URL KEY FROM MODULE ID
	public function getModuleKey($moduleID)
	{
		$sql	=	"
		SELECT 
			adminModuleURLKey 
		FROM 
			".DB_PREFIX."admin_modules 
		WHERE 
			adminModuleID= '".$moduleID."' "; 
		$resKey 	=	$this->ObjDatabase->readvalue($sql,MYSQLI_ASSOC);
		return $resKey['adminModuleURLKey'];
	}
	// END OF FUNCTION
	//GET AUTO PRIVILEGE URLS
	public function getAutoPrivilegeUrls($status='')
	{
		$sql	=	"
		SELECT 
	  		privilegeUrl 
		FROM  
			".DB_PREFIX."admin_module_privilege_urls 
		WHERE ";
		if($status)
			$sql	.= "privilegeStatus='".$status."' ";
		else
			$sql	.= "privilegeStatus!='Inactive' ";
		return $this->ObjDatabase->readvalues($sql);	
  }
   // END OF FUNCTION
    public function optgroupUserTypes($purpose='')	
    {
		$sqlSelectUserTypes	 	  =	"SELECT "; 
		$sqlSelectUserTypes		 .=	" (admin_user_type.userTypeName),admin_user_type.userTypeID ";		
    	$sqlSelectUserTypes		 .=	" FROM ".DB_PREFIX."admin_user_type as admin_user_type ";		
		$sqlSelectUserTypes		 .=	" WHERE admin_user_type.userTypeStatus!='Deleted' 
										GROUP BY admin_user_type.userTypeID";
		$resSelectUserTypes	      =	$this->ObjDatabase->readvalues($sqlSelectUserTypes);
		$i=0;
		foreach($resSelectUserTypes as $role){
			$sqlSelectUsers 	  =	"SELECT CONCAT(adminUserFirstName,' ',adminUserLastName) as adminname,admin_users.adminUserID ,admin_users.adminUserStatus";
			$sqlSelectUsers	 	 .=	" FROM  ".DB_PREFIX."admin_users as admin_users";
			$sqlSelectUsers		 .=	" WHERE admin_users.userTypeID='".$role['userTypeID']."'";
				if($purpose=='content'){
				$sqlSelectUsers		 .=	" AND admin_users.adminUserStatus ='Active'";
				}
			$resSelectUsers		  =	$this->ObjDatabase->readValues($sqlSelectUsers);
			$resSelectUserTypes[$i]['users']	=	$resSelectUsers;
			$i++;
		}
		
		return $resSelectUserTypes;
	}	
	//Save User Roles
	public function saveUserRoles()
	{
		//Roles Schema
		$schemaRoles = $this->includeRolesSchema();
		
		$userTypeName				=	$this->escape($_POST['userTypeName']);
		$userTypeID					=	$this->escape($_POST['userTypeID']);
		$moduleIDs					=	$_POST['moduleIDs'];
		$userTypeStatus				=	$_POST['userTypeStatus'];
		//Update/Insert into db
		if($userTypeID>0) 
		{
			$sql	=	"
						UPDATE  
							".DB_PREFIX."admin_user_type 
						SET 
							userTypeName='".$userTypeName."',
							userTypeStatus='".$userTypeStatus."'
						WHERE
							userTypeID='".$userTypeID."'";
			$this->ObjDatabase->setQuery($sql);
		} 
		else 
		{
		    $sql	=	"
						INSERT INTO 
							".DB_PREFIX."admin_user_type
							(
								userTypeName,
								userTypeStatus
							)
							VALUES
							(
								'".$userTypeName."',
								'".$userTypeStatus."'
							)";
			$this->ObjDatabase->setQuery($sql);
			$userTypeID				= 	$this->ObjDatabase->getInsertId();
		}
		//Writing to XML
		$arrayPrivilages                = 		'<?xml version="1.0" encoding="ISO-8859-1"?>';
		$arrayPrivilages              	.=  	'<roles>';
		foreach($moduleIDs as $moduleUrls)
		{
			if($moduleUrls!='')
			{	
				$subModules			=	explode("~*",$moduleUrls);
				$arrayPrivilages 	.= "<value>".implode("</value><value>",$subModules)."</value>";
			}
		}
		$arrayPrivilages               .=  	'</roles>'; 
		$fileName						=	$this->encodeString($userTypeID);	
		$Handle                       	= 	fopen(__CORE_PUBLIC_CACHE_PATH."/roles/".$fileName.".xml","w");
		fwrite($Handle,"".$arrayPrivilages."");
		fclose($Handle);
	}
	//Get Privilage File 
	public function getPrivilageFile($userTypeID)
	{
		$fileNameKey				=		$this->encodeString($userTypeID);
		define("ADMIN_USER_PRIV_FILE",$fileNameKey);
		$fileName					=		__CORE_PUBLIC_CACHE_PATH."/roles/".$fileNameKey.".xml";
		if(file_exists($fileName))
		{
			$xml 						= 		simplexml_load_file($fileName);
			$i							=		0;
			foreach($xml->value  as $value)
			{
				$urlKeyString						=	$this->escape($xml->value[$i]);		
				$privilageArray[]		=	htmlentities($urlKeyString);
				$i++;
			}
		}
		//print_r($privilageArray);exit;
		return $privilageArray;
	}
	//Include Roles Schema File
	public function includeRolesSchema()
	{
		//Roles Schema
		include_once(__CORE_PUBLIC_SCHEMA_PATH.'/roles.php');
		return $GLOBALS["ROLES_SCHEMA"];
	}
}
