<?php
/***************************************************************************
 *                                                                          *
 * Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
 *                                                                          *
 * This  is  commercial  software,  only  users  who have purchased a valid *
 * license  and  accept  to the terms of the  License Agreement can install *
 * and use this program.                                                    *
 *                                                                          *
 ****************************************************************************
 * PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
 * "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
 ****************************************************************************/ //
//$Id: StateModel.php, v 1.0 2013/03/18 20:52:11
//
class StateModel extends Model
{
	//List all State for the selected country
	public function listStates($languageIDs, $countryID, $status = "", $orderBy = "ASC", $page = "", $limitFrom = 0, $limitTo = "")
	{
		$sql	= "	SELECT ";
		if ($limitTo)
		{
			$sql .= "	SQL_CALC_FOUND_ROWS ";
		}
		$sql .= "		sta.stateID, 
						staDet.stateName, 
						sta.stateStatus, 
						sta.countryID, 
						sta.stateShortName 
					FROM 
							`" . DB_PREFIX . "states` AS sta 
					LEFT JOIN `" . DB_PREFIX . "state_details` AS staDet 
							ON (
								sta.stateID = staDet.stateID
								AND staDet.languageID =" .(int)$languageIDs['Current']. "
							) 
					WHERE 
						sta.countryID =" .(int)$countryID . " ";
		if ($status){
			$sql .= " AND sta.stateStatus ='" . $status . "'";
		}else{
			$sql .= " AND sta.stateStatus != 'Delete'";
		}
		$sql .= " 	ORDER BY staDet.stateName " . $orderBy . "";
		//IF PAGINATION REQUIRED
		if ($limitTo)
		{
			$sql .= " LIMIT  " . $limitFrom . "," . $limitTo . "";
		}
		return $this->ObjDatabase->readValues($sql);
	}
	//Insert/update State
	public function saveStateDetails($languageIDs, $POST)
	{
		$allLanguages      = $languageIDs['AllList'];
		$countryID         = $POST['countryID'];
		$stateID           = $POST['stateID'];
		$stateName         = $this->escape($POST['stateName']);
		$stateShortName    = $this->escape($POST['stateShortName']);
		$stateStatus       = $POST['stateStatus'];
		if (!$stateID)
		{
			$sql = "
					INSERT INTO " . DB_PREFIX . "states (
						`countryID`, 
						`stateStatus`, 
						`stateShortName`
					) 
					VALUES 
						(
						'" . $countryID . "', 
						'" . $stateStatus . "', 
						'" . $stateShortName . "'
						)";
			$this->ObjDatabase->setQuery($sql);
			$stateID        = $this->ObjDatabase->getInsertId();
			foreach ($allLanguages as $language)
			{
				$sql = "
					INSERT INTO " . DB_PREFIX . "state_details (
						`stateID`,
						`languageID`,
						`stateName`
					) 
					VALUES 
						(
						'" . $stateID . "',
						'" . $language . "',
						'" . $stateName . "'
						)";
				$this->ObjDatabase->setQuery($sql);
			}
		}
		else
		{
			$sql = "
					UPDATE  
						" . DB_PREFIX . "states 
					SET 
						stateStatus='" . $stateStatus . "'  ,
						stateShortName ='" . $stateShortName . "'
					WHERE 
						stateID	 ='" . $stateID . "'";
			$this->ObjDatabase->setQuery($sql);
			if ($this->isStateWithLanguageIDExists($languageIDs['Current'], $stateID))
			{
				$sql = "
					UPDATE  
						" . DB_PREFIX . "state_details 
					SET 
						stateName= 	'" . $stateName . "' 
					WHERE 
						stateID	='" . $stateID . "'
						AND 
						languageID = '" . $languageIDs['Current'] . "' ";
				$this->ObjDatabase->setQuery($sql);
			}
			else
			{
				$sql = "
					INSERT INTO " . DB_PREFIX . "state_details (
						`stateID`,
						`languageID`,
						`stateName`
					) 
					VALUES 
						(
						'" . $stateID . "',
						'" . $languageIDs['Current'] . "',
						'" . $stateName . "'
						)";
				$this->ObjDatabase->setQuery($sql);
			}
		}
		return 1;
	}
	function isStateWithLanguageIDExists($currentLanguageID, $hidStateID)
	{
		$sql = "
					SELECT 
						* 
					FROM 
						`" . DB_PREFIX . "state_details` 
					WHERE 
						`languageID` = '" . $currentLanguageID . "' 
						AND 
						`stateID` = '" . $hidStateID . "'";
		$resSelectDeal = $this->ObjDatabase->numberOfRecords($sql);
		if ($resSelectDeal)
			return true;
		else
			return false;
	}
	//Update status update 
	public function changeStateStatus($stateIDs, $stateStatus)
	{
		$sql = "
					UPDATE  
						" . DB_PREFIX . "states 
					SET 
						stateStatus    =	 '" . $stateStatus . "' 
					WHERE 
						stateID	in 	 (" . implode(",",$stateIDs) . ")";
		$this->ObjDatabase->setQuery($sql);
	}
	//Display State Details
	public function getStateDetails($languageIDs, $stateID)
	{
		$sql = "	SELECT 	* FROM 
						" . DB_PREFIX . "state_details as staDet, 
						" . DB_PREFIX . "states as sta 
					WHERE 
						staDet.stateID = sta.stateID 
						AND languageID = '" . $languageIDs['Current'] . "'									
						AND sta.stateID = '" . $stateID . "'";
		return $this->ObjDatabase->readValue($sql);
	}
	//Delete State Details
	public function destroyStateDetails($stateID)
	{
		$sql = "
			UPDATE 
				" . DB_PREFIX . "states 
			SET 
				stateStatus   = 'Delete' 
			WHERE 
				`stateID` ='" . $stateID . "'";
		$this->ObjDatabase->setQuery($sql);
	}
	//Check States with same name exits under same country
	public function getStatesCount($languageIDs, $countryID, $stateName = "", $stateShortName = "", $stateID)
	{
		$sql   = "
				SELECT 
					count(sta.stateID) as stateCount  
				FROM 
						`" . DB_PREFIX . "states` AS sta 
					LEFT JOIN 
						`" . DB_PREFIX . "state_details` AS staDet 
							ON (sta.stateID = staDet.stateID) 
				WHERE 
					staDet.languageID=" . (int)$languageIDs['Current'] . "
					AND 
					sta.stateStatus != 'Delete' ";
		if ($stateName)
		{
			$sql .= " 
					AND 
					staDet.stateName ='" . $stateName . "'  ";
		}
		if ($stateShortName)
		{
			$sql .= " 
					AND 
					sta.stateShortName ='" . $stateShortName . "'  ";
		}
		if ($countryID > 0)
		{
			$sql .= " 
					AND 
					sta.countryID 	='" . $countryID . "' ";
		}
		if ($stateID > 0)
		{
			$sql .= " 
					AND 
					sta.stateID != '" . $stateID . "' ";
		}
		$businessTypeCount = $this->ObjDatabase->readValue($sql);
		if ($businessTypeCount['stateCount'] > 0)
		{
			echo "1";
		}
		else
		{
			echo "0";
		}
	}
	//LIST AJAX STATES
	public function listAjaxStates($languageIDs, $selCountry,$selstates=array(),$status='')
	{
		$sql   = "	
				SELECT 
					sta.stateID, 
					staDet.stateName 
				FROM 
					`" . DB_PREFIX . "states` AS sta 
					LEFT JOIN `" . DB_PREFIX . "state_details` AS staDet ON (
						sta.stateID = staDet.stateID
					) 
				WHERE 
					sta.countryID = $selCountry 
					AND staDet.stateID = sta.stateID 
					AND staDet.languageID = '" . $languageIDs['Current'] . "'";
                if($status!='')
                 $sql            .=  "AND `stateStatus`  != 'Delete'  "; 
                else
		$sql            .=  "AND `stateStatus` = 'Active' ";
                if(!empty($selstates)){
                    $selectedstates =   implode(",",$selstates);
                    if($selectedstates!='')
                    $sql    .=  " AND sta.stateID IN($selectedstates)";
                }
		$sql    .=      "	GROUP BY sta.stateID	ORDER BY 
					staDet.stateName  ASC";
		$resSelectStates   = $this->ObjDatabase->readValues($sql);
                  if(count($selstates)>0){
                      return $resSelectStates;
                  }
		$arr_states[0][0]  = "";
		$arr_states[0][1]  = "Select";
		$count             = 1;
		foreach ($resSelectStates as $state)
		{
			$arr_states[$count][0] = $state['stateID'];
			$arr_states[$count][1] = $state['stateName'];
			$count++;
		}
		return $arr_states;
	}
	//Check Country State Mapping
	public function checkCountryStateMapping($countryID, $stateID)
	{
		$mappingCount = 0;
		$stateFlag    = 0;
		if ($countryID > 0)
		{
			$sql = "
				SELECT 
					count(sta.stateID) as stateCount  
				FROM 
					`" . DB_PREFIX . "states` 
				WHERE 
					stateStatus != 'Delete' 
					AND 
					countryID 	='" . $this->escape($countryID) . "' ";
			if ($stateID > 0)
			{
				$sql .= " AND stateID = '" . $this->escape($stateID) . "' ";
				$stateFlag = 1;
			}
			$mappingCountResult = $this->ObjDatabase->readValue($sql);
			$mappingCount       = $mappingCountResult['stateCount'];
			if ($mappingCount == 0 && $stateID != '' && $stateFlag == 0)
			{
				$mappingCount = 1;
			}
		}
		return $mappingCount;
	}
        public function getStateNameByID($stateID, $languageIDs)
        {
                  
		$sql .= " SELECT stateName FROM 
						" . DB_PREFIX . "state_details 
					WHERE 						
						 languageID = '" . $languageIDs['Current'] . "' 
						AND stateID = '" . $stateID . "'
                                                    LIMIT 1";
		$resState   =   $this->ObjDatabase->readValue($sql);
                return $resState['stateName'];
        }
}
