<?php
// START THE TIMER FOR THE PAGE PARSE TIME LOG 
 define('PAGE_PARSE_START_TIME', microtime());

// START OUTPUT BUFFER
 @ob_start();
// ERROR REPORTING ON/OFF
 ini_set("display_errors", 0 );

// DEFINE PROJECT VERSION 
 define('PROJECT_VERSION', 'Oorjit Daily Deal Package ver 1.2');

 // CHECK REGISTER GLOBAL ENABLE OR NOT
 if (function_exists('ini_get') && (ini_get('register_globals') == false) && (PHP_VERSION < 4.3) ) 
 {
    exit('Server Requirement Error: register_globals is disabled in your PHP configuration. This can be enabled in your php.ini configuration file or in the .htaccess file in your catalog directory. Please use PHP 4.3+ if register_globals cannot be enabled on the server.');
 }

// SET THE TYPE OF REQUEST (SECURE  OR NOT) 
 $global_request_type = (getenv('HTTPS') == 'on') ? 'SSL' : 'NONSSL';
 define ('__GLOBAL_REQUEST_TYPE', $global_request_type);

// DEFINE THE APPLICATION PATH 
 $application_path = realpath(dirname(__FILE__));
 define ('__APPLICATION_PATH', $application_path);
 
// HTML ENCODE ALL EXTERNAL DATA
  $_GET 	= clean_html($_GET);
  $_POST 	= clean_html($_POST);
  $_COOKIE 	= clean_html($_COOKIE);
  $_FILES 	= clean_html($_FILES);
  function clean_html($data) 
  {
	  if (is_array($data)) 
	  {
		  foreach ($data as $key => $value) 
		  {
			  unset($data[$key]);
				  $data[clean_html($key)] = clean_html($value);
		  }
	  } 
	  else 
	  { 
		  $data = htmlspecialchars($data, ENT_NOQUOTES, 'UTF-8');
	  }
	  return $data;
  }
