$(document).ready(function(){
	$( "ul.priority_drop_left" ).sortable({
			connectWith: "ul",
			remove: function(event, ui) {
				setCountryPriority();
				},
			items : ">li:visible"		
		});
		$( "ul.priority_drop_right" ).sortable({
			connectWith: "ul",
			dropOnEmpty: true,
			start: function(event, ui) {
				$( ".priority_drop_delete" ).hide();
			},			
			stop: function(event, ui) {
				$( "ul.priority_drop_left li .priority_drop_delete" ).hide();
				setCountryPriority();				
			},
			items : ">li:visible"
		});		
		$('ul#priority_drop_right_id li .priority_drop_delete').live('click', function() {
			
			$(this).closest("li").fadeOut('slow', function() {
				$(this).closest("li").appendTo('ul.priority_drop_left');
				$( "ul.priority_drop_left li .priority_drop_delete" ).hide();
				$( "ul.priority_drop_left li" ).show();
				setCountryPriority();
				location.reload();
  			});
		});
		$('ul#priority_drop_right_id li').live('mouseenter',function(){
			   $( "ul#priority_drop_right_id .priority_drop_delete" ).hide();
               $(this).find(".priority_drop_delete").show();
		});		
		$('ul#priority_drop_right_id li').live('mouseleave',function(){
			$( "ul#priority_drop_right_id .priority_drop_delete" ).hide();
		});
		$( "#priority_drop_left_id, #priority_drop_right_id" ).disableSelection();		
		$("#countrySearchLeft").keyup(function(){
			var filter = $(this).val();
			$("#priority_drop_left_id li").each(function(){
				if ($(this).text().search(new RegExp(filter, "i")) < 0) {
					$(this).fadeOut();
				} else {
					$(this).show();			
				}
			});
		});
		$("#countrySearchRight").keyup(function(){
			var filter = $(this).val();
			$("#priority_drop_right_id li").each(function(){
				if ($(this).text().search(new RegExp(filter, "i")) < 0) {
					$(this).fadeOut();
				} else {
					$(this).show();			
				}
			});
		});
	});	
	function setCountryPriority()
	{
	         var priorityString = "";
			 $('ul#priority_drop_right_id li').each(function(index) {
					priorityString = priorityString+$(this).attr("id")+"->"+(index+1)+"~*";					
			 });		
			
			var dataArray 			= new Array();
			dataArray[0] 			= priorityString;			
			$.ajax({		   
			  url: GLOBAL_BASE_PATH+"/country/ajaxPriority/",
			  type: "POST",
			  cache: false,
			  async: false,
			  global: false,
			  data: { ajax_request: dataArray },
			  success: function(data) {				 
				  if(data!="") {
					 
				  } 
			  }
		  
			});
	
	}