jQuery.fn.customInput = function (count) {
    $(this).each(function (i) {
        var $elem = $('.outer_container');
        if ($(this).is('[type=checkbox],[type=radio]')) {
            var input = $(this);
            var label = $('label[for=' + input.attr('id') + ']');
            var inputType = (input.is('[type=checkbox]')) ? 'checkbox' : 'radio';
            $('<span class="custom-' + inputType + count + '"></span>').insertBefore(input).append(input, label);
			var allInputs = $("input[name='" + input.attr('name') + "']");
            label.hover(function () {
                $(this).addClass('hover');
                if (inputType == 'checkbox' && input.is(':checked')) {
                    $(this).addClass('checkedHover');
                }
            }, function () {
                $(this).removeClass('hover checkedHover');
            });
            input.bind('updateState', function () {
                if (input.is(':checked')) {
                    if (input.is(':radio')) {
                        allInputs.each(function () {
                            $('label[for=' + $(this).attr('id') + ']').removeClass('checked');
                        });
                    };
                    label.addClass('checked');
                } else {
                    label.removeClass('checked checkedHover checkedFocus');
                }
            }).trigger('updateState').click(function () {
                $(this).trigger('updateState');
            }).focus(function () {
                label.addClass('focus');
                if (inputType == 'checkbox' && input.is(':checked')) {
                    $(this).addClass('checkedFocus');
                }
            }).blur(function () {
                label.removeClass('focus checkedFocus');
            });
        }
    });
};
