var ObjValid = new Validation();
$.fn.validate = function (options) {

    var $this = $(this);
    var defaults = {
        form: "formNews",
        field: $this.attr("id"),
        key: "required",
        error: "Enter value",
        group: "",
        row: "",
        inline: "0"
    };
    var custom_options = $.extend(defaults, options);
    var curr_form = custom_options.form;
    var curr_field = custom_options.field;
    var curr_value = $this.val();
    var curr_key = custom_options.key;
    var curr_error = custom_options.error;
    var curr_group = custom_options.group;
    var curr_row = custom_options.row;
    var curr_inline = custom_options.inline;
    var curr_error_div = "div_err_" + curr_form + "_" + curr_field;
    var curr_error_field = "hid_err_" + curr_form + "_" + curr_field;
    var checked_count = 0;
    var checked_started = 0;
    var curr_field_class = "";
    var curr_field_name = $this.attr("name");
    if (curr_group != "" && curr_row != "") //Check whether row deleted
    {
        var is_delete_field = curr_group + '_' + curr_row + '_is_delete';
        if ($("#" + is_delete_field).val() == '1') return true;
    }
    var curr_field_name_array = curr_field_name.split("[");
    if ((curr_field_name_array[1]) == "]" && checked_count == 0) {
        curr_field_name = curr_field_name_array[0];
        curr_field_class = curr_field_name + "_class";
        $('.' + curr_field_class).each(function () {
            checked_started = 1;
            if ($(this).attr("checked")) {
                checked_count++;
                curr_value = curr_value + $(this).val() + "~*";
            }
        });
    }
    var curr_error_field_value = $("#" + curr_error_field).val();
    curr_value = (checked_count == 0 && checked_started > 0) ? "" : curr_value;
    curr_value = (curr_value == null) ? "" : curr_value;

    var data = validate_element(curr_form, curr_field, curr_value, curr_key, curr_error);

    if (data == "") {
        if (curr_inline == 1) {
            $("#" + curr_error_div).addClass("hide");
        }
        var curr_height = $("#" + curr_error_div).height();
        $("#" + curr_error_field).val(0);
        return true;
    } else {
        $("#" + curr_error_div).html('<span>' + data + '</span>');
        if (curr_inline == 1) {
            $("#" + curr_error_div).removeClass("hide");
        }
        $("#" + curr_error_field).val(1);
        $('#' + curr_form + '_errors').val(1);
        return false;
    }
};
$.fn.validateForm = function (options) {
    var defaults = {
        form: "formNews"
    };
    var custom_options = $.extend(defaults, options);
    var curr_form = custom_options.form;
    var curr_form_result = 0;
    var curr_field_value = "";
    $('.hid_err_' + curr_form + '_validations').each(function () {
        curr_field_value = $(this).val();
        if (parseInt(curr_field_value) == 1) {
            var curr_error_div = $(this).attr("rel");
            $("#" + curr_error_div).removeClass("hide");
        }
        if (parseInt(curr_field_value) == 1 && curr_form_result == 0) {
            curr_form_result = 1;
        }
    });
    if (curr_form_result == 0) {
        $('#' + curr_form + '_errors').val(0);
        return true;
    } else return false;
}

function substr_count(string, substring, start, length) {
    var c = 0;
    if (start) {
        string = string.substr(start);
    }
    if (length) {
        string = string.substr(0, length);
    }
    for (var i = 0; i < string.length; i++) {
        if (substring == string.substr(i, substring.length)) c++;
    }
    return c;
}

function is_string(op) {
    return typeof op == 'string';
}

function validateReset(curr_form, curr_field) {
    var dataArray = new Array();
    dataArray[0] = curr_form;
    dataArray[1] = curr_field;
    var curr_error_div = "div_err_" + curr_form + "_" + curr_field;
    var curr_error_field = "hid_err_" + curr_form + "_" + curr_field;
    $.ajax({
        url: GLOBAL_BASE_PATH + "/validate/destroy/",
        type: "POST",
        cache: false,
        async: false,
        global: false,
        data: {
            ajax_request: dataArray
        },
        success: function (data) {
            $("#" + curr_error_div).addClass("hide");
            $("#" + curr_error_field).val(0);
        }
    });
}

function validate_element(params_form_name, params_field_name, params_curr_value, sessionRuleSet, sessionErrorSet) {
    var FormsBaseSeparator = "~*";
    var FormsSubSeparator = "->";
    var fieldDetailsArray = {};
    var params_form_name = params_form_name;
    var params_field_name = params_field_name;
    var params_curr_value = $.trim(params_curr_value);
    var sessionRuleSet = sessionRuleSet;
    var sessionErrorSet = sessionErrorSet;
    var params_curr_field = params_field_name;
    fieldDetailsArray[params_form_name] = {};
    fieldDetailsArray[params_form_name]['field'] = params_field_name;
    fieldDetailsArray[params_form_name]['currfield'] = params_field_name;
    fieldDetailsArray[params_form_name]['error'] = sessionErrorSet;
    fieldDetailsArray[params_form_name]['result'] = 0;
    var $params_curr_message = "";
    var params_curr_result = true;

    var ruleArray = (substr_count(sessionRuleSet, FormsBaseSeparator) > 0) ? sessionRuleSet.split(FormsBaseSeparator) : [""];
    var ruleConstructArray = (substr_count(sessionRuleSet, FormsSubSeparator) > 0) ? sessionRuleSet.split(FormsSubSeparator) : [""];

    if (sessionRuleSet != "") {
        if ((!$.isArray(ruleArray) || ruleArray[0] == '') && (!$.isArray(ruleConstructArray) || ruleConstructArray[0] == '')) {
            if (substr_count(sessionRuleSet, 'callback_')) {
                var sessionRuleSet = (sessionRuleSet).replace('callback_', '');
                if ($.isFunction(window[sessionRuleSet])) {
                    params_curr_result = window[sessionRuleSet](params_form_name, fieldDetailsArray);
                } else {
                    params_curr_result = true;
                    console.warn('Custom Error Message: Callback validation function "' + sessionRuleSet + '" not found in your *.js! Form: ' + params_form_name + ' , Element: ' + params_field_name);
                }
            } else if ($.isFunction(window['ObjValid'][sessionRuleSet])) {
                params_curr_result = window['ObjValid'][sessionRuleSet](params_form_name, fieldDetailsArray);
            } else {
                params_curr_result = true;
                console.warn('Custom Error Message: Function "' + sessionRuleSet + '" not found in validate plugin(validate.plugin.js)!')
            }
        } else {
            var sessionErrorSet_array = (substr_count(sessionErrorSet, FormsBaseSeparator) > 0) ? sessionErrorSet.split(FormsBaseSeparator) : sessionErrorSet;
            var params_curr_result_value_true = 0;
            var params_curr_result_value_equal_true = 0;
            var params_curr_result_value_equal_false = 0;
            var params_curr_result_value_equal_true_count = 0;
            var params_curr_result_value_equal_false_count = 0;
            var params_curr_result_value_notequal_true = 0;
            //var params_curr_value_array_ajax=(substr_count(params_curr_value,FormsBaseSeparator)>0)?params_curr_value.split(FormsBaseSeparator):"";
            var params_curr_result_value_compare = "";
            for (var $validate_i = 0; $validate_i < ruleArray.length; $validate_i++) {
                if (params_curr_result && !is_string(params_curr_result)) {
                    params_curr_field_array_sub = (ruleArray.length == 1) ? sessionRuleSet : ruleArray[$validate_i];
                    ruleConstructArray = (substr_count(params_curr_field_array_sub, FormsSubSeparator) > 0) ? params_curr_field_array_sub.split(FormsSubSeparator) : "";

                    operandName1 = $.isArray(ruleConstructArray) ? $.trim(ruleConstructArray[0]) : params_curr_field;
                    var params_curr_value_array = $.isArray(ruleConstructArray) ? $.trim($("#" + ruleConstructArray[0]).val()) : $.trim(params_curr_value);

                    if ($.isArray(ruleConstructArray) && (ruleConstructArray[2] != '') && ruleConstructArray[1] != 'isequal' && ruleConstructArray[1] != 'isnotequal' && ruleConstructArray[1] != 'compare' && ruleConstructArray[1] != 'value') operandName2 = $.trim(ruleConstructArray[2]);
                    else operandName2 = "";
                    operandPostDate2 = (operandName2 != "") ? $.trim($("#" + ruleConstructArray[0]).val()) : "";
                    expectedResult = (operandName2 != "") ? $.trim(ruleConstructArray[3]) : "";

                    fieldDetailsArray[params_form_name]['field'] = operandName1;
                    fieldDetailsArray[params_form_name]['field2'] = operandName2;
                    fieldDetailsArray[params_form_name]['expectedResult'] = expectedResult;

                    var sessionConstructFieldRule = $.isArray(ruleConstructArray) ? $.trim(ruleConstructArray[1]) : ruleArray[$validate_i];
                    if ($.trim(sessionConstructFieldRule) == '') {
                        continue;
                    } else if (sessionConstructFieldRule.toLowerCase() == "compare") {
                        if (params_curr_value == params_curr_value_array || params_curr_value == '') {
                            params_curr_result = true;
                            return "";
                        } else {
                            params_curr_result = ($.isArray(sessionErrorSet_array)) ? sessionErrorSet_array[$validate_i] : sessionErrorSet_array;
                        }
                    } else if (sessionConstructFieldRule.toLowerCase() == "value" || sessionConstructFieldRule.toLowerCase() == "isnotequal" || sessionConstructFieldRule.toLowerCase() == "isequal") {
                        if (params_curr_value_array == $.trim(ruleConstructArray[2])) {
                            if (sessionConstructFieldRule.toLowerCase() == "isnotequal") {
                                params_curr_result = true;
                                params_curr_result_value_notequal_true = 1;
                            } else if (sessionConstructFieldRule.toLowerCase() == "isequal") {
                                params_curr_result_value_equal_true = 1;
                                params_curr_result_value_equal_true_count++;
                            } else {
                                params_curr_result = true;
                            }
                        } else {
                            if (sessionConstructFieldRule.toLowerCase() == "isequal") {
                                params_curr_result_value_equal_false = 1;
                                params_curr_result_value_equal_false_count++;
                            } else {
                                params_curr_result = false;
                            }
                        }
                    } else if ($.trim(sessionConstructFieldRule.toLowerCase()) != "") {
                        fieldDetailsArray[params_form_name]['options'] = (ruleConstructArray.length) ? ruleConstructArray[2] : "";
                        if (substr_count(sessionConstructFieldRule, 'callback_')) {
                            var sessionConstructFieldRule = (sessionConstructFieldRule).replace('callback_', '');
                            if ($.isFunction(window[sessionConstructFieldRule])) {
                                params_curr_result = window[sessionConstructFieldRule](params_form_name, fieldDetailsArray);
                            } else {
                                params_curr_result = true;
                                console.warn('Custom Error Message: Callback validation function "' + sessionConstructFieldRule + '" not found in your *.js! Form: ' + params_form_name + ' , Element: ' + params_field_name);

                            }
                        } else if ($.isFunction(window['ObjValid'][sessionConstructFieldRule])) {
                            params_curr_result = window['ObjValid'][sessionConstructFieldRule](params_form_name, fieldDetailsArray);
                        } else {
                            params_curr_result = true;
                            console.warn('Custom Error Message: Function "' + sessionConstructFieldRule + '" not found in validate plugin!')
                        }
                    }
                    if (sessionErrorSet_array.length == 1) {
                        var sessionErrorSet_array_curr = fieldDetailsArray[params_form_name]['error'];
                    } else {
                        var sessionErrorSet_array_curr = ($.isArray(sessionErrorSet_array)) ? sessionErrorSet_array[$validate_i] : sessionErrorSet_array;
                    }
                    sessionErrorSet = (params_curr_result == "") ? sessionErrorSet_array_curr : params_curr_result;
                }
            }
        }
    }
    if (params_curr_result_value_notequal_true == 1) {
        params_curr_result = true;
    }
    if (params_curr_result_value_equal_true == 1 && !params_curr_result) {
        params_curr_result = false;
    } else if (params_curr_result_value_equal_false == 1) {
        params_curr_result = true;
    }
    if (params_curr_result_value_equal_false_count > 0 && params_curr_result_value_equal_true_count > 0) {

        params_curr_result = true;
        sessionErrorSet = fieldDetailsArray[params_form_name]['error'];
    }
    if (!params_curr_result || is_string(params_curr_result)) {
        $params_curr_message = (params_curr_result == "") ? sessionErrorSet : params_curr_result;
        $params_curr_message = ($params_curr_message == "") ? +"Error found in form element '" + fieldDetailsArray : $params_curr_message;
    }
    return $params_curr_message;
}

function Validation() {
    this.required = function (form, form_fields) {
        var form_fields_value = $("#" + form_fields[form].field).val();
        if ($.trim(form_fields_value) == "") {
            return false;
        } else {
            return true;
        }
    }

    this.email = function (form, form_fields) {
        var form_fields_value = $("#" + form_fields[form].field).val();
        var reg = /^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))$/i;
        if ((form_fields_value == "") || reg.test(form_fields_value)) {
            return true;
        } else {
            return false;
        }
    }

    this.isMultipleEmail = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var emails = value.split(/[,]+/);
        var valid = true;
        var reg = /^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))$/i;
        for (var i in emails) {
            singleEmail = emails[i];
            if ((singleEmail == "") || reg.test(singleEmail)) isValidSingleEmail = true
            else isValidSingleEmail = false
            valid = valid && isValidSingleEmail;
        }
        return valid;
    }

    this.isUrl = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var regex = /(?:(?:https?|ftp):\/\/|www\.)[a-z0-9-+&@#\/%?=~_|!:,.;]+(\.[\w\_]+)[a-z0-9+&@#\/%=~_|]/i;;
        return value == "" || regex.test(value);
    }

    this.isLoginName = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var regexp1 = /^[^0-9][A-z0-9_]+([.][A-z0-9_]+)*[@][A-z0-9_]+([.][A-z0-9_]+)*[.][A-z]{2,4}$/;
        var regexp2 = /^[a-zA-Z\d_.]{5,20}$/;
        return value == "" || regexp1.test(value) || regexp2.test(value);
    }

    this.isPassword = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var regex = /^.*(?=.{8,})(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).*$/;
        return value == "" || regex.test(value);
    }

    this.isPrice = function (form, form_fields) {
        var value = $("#" + form_fields[form]['field']).val();
        var value = (value.substring(0, 1) == ".") ? "0" + value : value;
        var regex = /^\d+(\.\d{1,2})?$/;
        return value == "" || regex.test(value);
    }

    this.isPhone = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        return value == "" || !isNaN(value) && (value.length == 10 || value.length == 12);
    }

    this.isKey = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var regex = /^[a-zA-Z0-9_\-]+$/;
        return value == "" || regex.test(value);
    }

    this.isUrlKey = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var regex = /^[a-zA-Z0-9.\-\_]+$/;
        return value == "" || regex.test(value);
    }

    this.isFloat = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var regex = (/(^\d+$)|(^\d+.\d+$)|[,.]/);
        return value == "" || regex.test(value);
    }

    this.isNumber = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        return value == "" || (!isNaN(parseFloat(value)) && isFinite(value));
    }

    this.isInteger = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var integerRegex = /^\-?[0-9]+$/;
        return value == "" || (integerRegex.test(value));
    }

    this.isWholeNumber = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var wholeNumberRegex = /^[0-9]+$/i;
        return value == "" || (wholeNumberRegex.test(value));
    }

    this.isWholeNumberWithZero = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var wholeNumberRegex = /^[0-9]+$/i;
        return value == "" || (wholeNumberRegex.test(value));
    }

    this.isWholeNumberWithOutZero = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var wholeNumberNonZeroRegex = /^[1-9][0-9]*$/i;
        return value == "" || (wholeNumberNonZeroRegex.test(value));
    }

    this.isPercentage = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var regex = /^\d{0,2}(\.\d{0,3})?$|^100$/;
        return regex.test(value);
    }

    this.isAlphaNumeric = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var regex = /^[a-zA-Z0-9]+$/;
        return value == "" || regex.test(value);
    }

    this.isAlpha2 = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var regex = /^[a-zA-Z]{2}$/;
        return value == "" || regex.test(value);
    }

    this.isAlpha3 = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var regex = /^[a-zA-Z]{3}$/;
        return value == "" || regex.test(value);
    }

    this.isAlphaCapsNumeric = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var regex = /^[A-Z0-9]+$/;
        return value == "" || regex.test(value);
    }

    this.isLCIDString = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var regex = /^[a-zA-Z0-9-]+$/;
        return value == "" || regex.test(value);
    }

    this.isCurrency = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var regex = /^\d+(\.\d{1,5})?$/;
        return value == "" || regex.test(value);
    }

    this.isTag = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var regex = /([\<])([^\>]{1,})*([\>])/i;
        return value == "" || !regex.test(value);
    }

    this.isISO = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var regex = /^[0-9]{0,4}$/;
        return value == "" || regex.test(value);
    }

    this.isZipCode = function (form, form_fields) {
        var value = $("#" + form_fields[form].field).val();
        var regex = /^[a-zA-Z\d]+(([\- ][a-zA-Z\d ])?[a-zA-Z\d]*)*[a-zA-Z\d]{1}$/;
        return value == "" || regex.test(value);
    }

    this.isNumberLimit = function (form, form_fields) {
        var currentfield = form_fields[form].field;
        var value = $("#" + currentfield).val();
        var form_fields_options = form_fields[form].options.split(",");
        var from_number = parseInt(form_fields_options[0]);
        var to_number = parseInt(form_fields_options[1]);
        if ((isNaN(from_number)) || (isNaN(to_number))) {
            return false;
        }
        if ((from_number && to_number && value >= from_number && value <= to_number) || (!from_number && to_number && value <= to_number) || (!to_number && from_number && value >= from_number) || value == '') {
            return true;
        } else {
            return false;
        }
    }

    /* ==================== New  Binary Operators with result checking ======================== */
    this.eq = function (form, form_fields) {
        var value1 = $("#" + form_fields[form].field).val();
        var value2 = $("#" + form_fields[form].field2).val();
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        return value1 == value2;
    }

    this.neq = function (form, form_fields) {
        var value1 = $("#" + form_fields[form].field).val();
        var value2 = $("#" + form_fields[form].field2).val();
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        return value1 != value2;
    }

    this.gt = function (form, form_fields) {
        var value1 = $("#" + form_fields[form].field).val();
        var value2 = $("#" + form_fields[form].field2).val();
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        return value1 > value2;
    }

    this.gteq = function (form, form_fields) {
        var value1 = $("#" + form_fields[form].field).val();
        var value2 = $("#" + form_fields[form].field2).val();
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        return value1 >= value2;
    }

    this.lt = function (form, form_fields) {
        var value1 = $("#" + form_fields[form].field).val();
        var value2 = $("#" + form_fields[form].field2).val();
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        return value1 < value2;
    }

    this.lteq = function (form, form_fields) {
        var value1 = $("#" + form_fields[form].field).val();
        var value2 = $("#" + form_fields[form].field2).val();
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        return value1 <= value2;
    }

    /* ==================== New  Binary Operators with result checking ======================== */
    this.plus = function (form, form_fields) {
        var value1 = $("#" + form_fields[form].field).val();
        var value2 = $("#" + form_fields[form].field2).val();
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        var expectedResult = parseFloat(form_fields[form].expectedResult);
        var result = value1 + value2;
        return result == expectedResult;
    }

    this.minus = function (form, form_fields) {
        var value1 = $("#" + form_fields[form].field).val();
        var value2 = $("#" + form_fields[form].field2).val();
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        var expectedResult = parseFloat(form_fields[form].expectedResult);
        var result = value1 - value2;
        return result == expectedResult;
    }

    this.multiply = function (form, form_fields) {
        var value1 = $("#" + form_fields[form].field).val();
        var value2 = $("#" + form_fields[form].field2).val();
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        var expectedResult = parseFloat(form_fields[form].expectedResult);
        var result = value1 * value2;
        return result == expectedResult;
    }

    this.divide = function (form, form_fields) {
        var value1 = $("#" + form_fields[form].field).val();
        var value2 = $("#" + form_fields[form].field2).val();
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        var expectedResult = parseFloat(form_fields[form].expectedResult);
        if (value2 != 0) {
            var result = value1 / value2;
        } else {
            result = 0;
        }
        return result == expectedResult;
    }

    this.mod = function (form, form_fields) {
        var value1 = $("#" + form_fields[form].field).val();
        var value2 = $("#" + form_fields[form].field2).val();
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        var expectedResult = parseFloat(form_fields[form].expectedResult);
        var result = value1 % value2;
        return result == expectedResult;
    }
}