<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/

//
//$Id: config.engine.php,v 1.0 2011/06/14 20:52:11
//Config - Config Engine for Oorjit Deal System
//

class Config
{
	public $db_host;
	public $db_user;
	public $db_password;
	public $db_name;
	protected $url_array;
	protected $url_licence_number;
	protected $url_licence_key;
	protected $url_rewrite_key;
	protected $url_rewrite_status;
	public $ObjRewrite;
	public $_settings;
	
	//Constructor for Config Class
	public function __construct () 
	{
		$ObjRewrite = Registry::getInstance('Rewrite');
		$this->init($ObjRewrite); 
	}
	
	//Initializing Objects
	public function init($ObjRewrite)  
	{
		$this->setDBinfo($ObjRewrite);
		//$this->setSettings($ObjRewrite);
		$this->setURLAccess();
		$this->setURLRewriteKey();
		$this->defineSettingsConstants();
	}

	//To set the Database details
	public function setDBinfo($ObjRewrite)  
	{
		if($ObjRewrite->_section==$ObjRewrite->_multisiteDIR) {
			if(@is_file(__CORE_PUBLIC_PATH . '/'.$ObjRewrite->_multisiteDIR.'/'.$ObjRewrite->_multisite.'/config.php')) {
				require_once __CORE_PUBLIC_PATH . '/'.$ObjRewrite->_multisiteDIR.'/'.$ObjRewrite->_multisite.'/config.php';
			} 
			else {
				require_once __SYSTEM_PATH . '/config/'   . 'config.php';
			}
		} else {
			require_once __SYSTEM_PATH . '/config/'   . 'config.php';
		}
		/*
		$this->db_host		= DB_HOST;
		$this->db_user		= DB_USER;
		$this->db_password	= DB_PASSWORD;
		$this->db_name		= DB_NAME;	
		*/
		$this->db_host		= DB_HOST;
		$this->db_user		= DB_USER;
		$this->db_password	= DB_PASSWORD;
		$this->db_name		= DB_NAME;	
		$this->db_slave_servers = $this->db_servers		= unserialize(DB_SLAVES); 	 	
		array_unshift($this->db_servers,array('DB_HOST'=>DB_HOST,'DB_USER'=>DB_USER,'DB_PASSWORD'=>DB_PASSWORD,'DB_NAME'=>DB_NAME)); 
	}
	
	//To load settings xml
	public function setSettings()  
	{
		if(@is_file(__CORE_PUBLIC_PATH . '/cache/'   . 'settings.xml'))
			$settingsXmlFile	= __CORE_PUBLIC_PATH . '/cache/'   . 'settings.xml';
		else
			$settingsXmlFile	= __SYSTEM_PATH . '/cache/'   . 'settings.xml';
		$ObjSettingsXml 		= simplexml_load_file($settingsXmlFile);
		$settingsArray 			= $this->settingsXmlToArray($ObjSettingsXml);			
		$test = Registry::setInstance('_settings',$settingsArray);
	}

	//Settings XML to array
	public function settingsXmlToArray($object,$maximum_step=4,$curr_step=1) 
	{ 
		$return = NULL; 
		$curr_step++;
		if(is_array($object)) { 
			foreach($object as $key => $value) {
            	$return[$key]	= $this->settingsXmlToArray($value,$maximum_step,$curr_step); 
			}
		} else {  
			$var = @get_object_vars($object); 
			if($var) { 
				foreach($var as $key => $value) { 
					if($maximum_step>$curr_step) {
						$return[$key] = ($key && !$value) ? NULL : $this->settingsXmlToArray($value,$maximum_step,$curr_step); 
					} else {
						$return[$key] = ($key && !$value) ? NULL : $value; 
					}
				}
			} else {
			   return $object; 
			}
		} 
    	return $return; 
	} 

	//Get Settings details
	public function getSettings($keyGroupID,$keyID = "")  
	{
		$_settings	= Registry::getInstance('_settings');
		$_settings[$keyGroupID][$keyID] = isset($_settings[$keyGroupID][$keyID]) ? $_settings[$keyGroupID][$keyID]  : '';
		return $_settings[$keyGroupID][$keyID];	  
	}

	//Set Url access
	public function setURLAccess()  
	{
		$this->url_array		    = @substr_count('REGISTERED_URL',",")?explode(",",'REGISTERED_URL'):array('REGISTERED_URL');
		$this->url_licence_number	= 'LICENCE_NUMBER';	
		$this->url_licence_key		= 'LICENCE_KEY';
	}

	//Set Url rewrite key
	public function setURLRewriteKey()  
	{
		$this->url_rewrite_key		= __URL_REWRITE_KEY;
		$this->url_rewrite_status	= __URL_REWRITE_STATUS;
	}

	public function defineSettingsConstants() {
		// For enable/disable affiliate
		if($this->getSettings('affiliate_settings','affiliate_enable')=='Yes' && __AFFILIATE_MODULE){
			if(!defined("__AFFILIATE_ENABLE"))
			{
			define("__AFFILIATE_ENABLE",TRUE);
			}
		}else{
			if(!defined("__AFFILIATE_ENABLE"))
			{
			define("__AFFILIATE_ENABLE",FALSE);
		}
	}
	}
  
} // End of Class