<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/

//
//$Id: filter.engine.php,v 1.0 2011/06/14 20:52:11
//Filter - Filter Engine for Oorjit Deal System
//

class Filter
{
	
	public static $_options;
	
	//Constructor for Filter class
	public function __construct () 
	{
		$options	= isset($options)?$options:'';
		$this->init($options);
	}

	//Initialization of objects  
	public function init($options) 
	{
		$this->setOptions($options);
	}

	//To set the options	  
	private function setOptions($options)  
	{
		return $this->_options =	$options;
	}

	//To get the instance   
	public function getInstance($entryKey) 
	{
		$filterInstance = $this->isInstance($entryKey);
		if($filterInstance!="")  
		{
			return Registry::getInstance($filterInstance);
		} 
		else 
		{
			return false;
		}
	}
	
	//To check is the key is an instance
	public function isInstance($entryKey)  
	{
		$filterInstance = "";
		switch($entryKey) 
		{
			case "Session":
			$filterInstance = $entryKey;
			break;
			case "Cookie":
			$filterInstance = $entryKey;
			break;
			case "Tools":
			$filterInstance = $entryKey;
			break;
			case "Rewrite":
			$filterInstance = $entryKey;
			break;
			case "Settings":
			$filterInstance = "_settings";
			break;
			default:
			$filterInstance = "";
		}
		return $filterInstance;
	}

	//To get the settings  
	public function getSettings($keyGroupID,$keyID="")  
	{
		$settingsArray 			= $this->getInstance('Settings');
		return (($keyID=="")?($settingsArray[$keyGroupID]):($settingsArray[$keyGroupID][$keyID]));
	}

	//To get the tool instance  
	public function getToolInstance()  
	{
		return $this->getInstance('Tool');
	}

	//To get session instance  
	public function getSessionInstance()  
	{
		return $this->getInstance('Session');
	}

	//To get Cookie instance  
	public function getCookieInstance()  
	{
		return $this->getInstance('Cookie');
	}

	//To get Url settings  
	public function getUrlSettings()  
	{
		$urlSettingsArray = array();
		$ObjRewrite  	  =  Registry::getInstance('Rewrite');
		$urlSettingsArray['queryString'] 	=  $ObjRewrite->_queryString;
		$urlSettingsArray['queryDelimiter'] =  $ObjRewrite->_queryDelimiter;
		$urlSettingsArray['requestUrl'] 	=  $ObjRewrite->_requestUrl;
		$urlSettingsArray['requestPage'] 	=  $ObjRewrite->_requestPage;
		$urlSettingsArray['outputUrl'] 		=  $ObjRewrite->_outputUrl;
		$urlSettingsArray['section'] 		=  $ObjRewrite->_section;
		return $urlSettingsArray;
	}
  
}

?>