<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/

//
//$Id: paginate.engine.php,v 1.0 2011/06/14 20:52:11
//Paginate - Paginate Engine for Oorjit Deal System
//
class Paginate 
{
 
  public $_page_limit;
  public $_page_number;
  public $_pages_display;
  public $_page_count;
  
  //Constructor for paginate class
  public function __construct () 
  {
	  	$this->_page_limit	= 10;
		$this->_page_number	= 1;
		$this->_pages_display= 7;
		$this->_page_count	=1;
  }
  
  //To set layout of pagination
  public function layout($params, $ObjView) 
  {
  		$params_key 			= (empty($params['key']))?"page":trim($params['key']);
  		$params_label_record 	= (empty($params['label_record']))?"Record(s) found":trim($params['label_record']);
  		$params_label_pages 	= (empty($params['label_pages']))?"Page(s)":trim($params['label_pages']);
		$params_count 			= (empty($params['total_pages']))?"":trim($params['total_pages']);
		$params_limit 			= (empty($params['rows_per_page']))?"":trim($params['rows_per_page']);
		
		$params_display 		= (empty($params['display_pages']))?$this->_pages_display:trim($params['display_pages']);
		$params_class 			= (empty($params['class']))?"pagination":trim($params['class']);
		$params_count			= (empty($params_count))?$ObjView->getTemplateVars("paginate_total_pages_".$params_key):$params_count;
		$params_limit 			= (empty($params_limit))?$ObjView->getTemplateVars("paginate_rows_per_page_".$params_key):$params_limit; 
		$params_limit 			= (empty($params_limit))?$this->_page_limit:$params_limit;
		$ObjRewrite  			= Registry::getInstance('Rewrite');
		$queryStringKeyNumber 	= (array_search($params_key, $ObjRewrite->_queryString)+1);
		$params_page			= ($queryStringKeyNumber>1)?trim($ObjRewrite->_queryString[$queryStringKeyNumber]):"";
		$params_page 			= (empty($params_page))?"1":trim($params_page);
		$_queryStringArray      = $this->encodeQueryStringArray($ObjRewrite->_queryString);   
		$params_pages 			= floor($params_count/$params_limit)+ (($params_count%$params_limit>0)?1:0);
		$params_page 			= $params_page-1;
		$page_i_start   		= $params_page-($params_page%$params_display);
		$page_i_start			= $page_i_start+1;
		$params_pages_display  	= $page_i_start+$params_display-1;
		$params_pages_display   = ($params_pages_display>$params_pages)?$params_pages:$params_pages_display;
		$params_page 			= $params_page+1;
		if($params_count>$params_limit)
			$this->_page_count	=	ceil($params_count/$params_limit);
		$paginate_result 		= "";
	 	$paginate_result		= '<ul class="'.$params_class.'">';
		
		$params_records_found_visible	= (empty($params['records_found_visible']))?"":trim($params['records_found_visible']);
		if($params_page>$params_pages && $params_page!=1) {
			 $_queryStringArray[$queryStringKeyNumber] = $params_pages;
			 $location_url    		= implode($ObjRewrite->_queryDelimiter,$_queryStringArray);
			 if($location_url) {
				$header_location	= $ObjView->_base_path;
				$slash_required		= 0;
				$slash_required		= (substr($header_location,strlen($header_location)-2,strlen($header_location))=="..")?1:$slash_required;
				$slash_required		= (substr($location_url,0,1)!="/")?($slash_required+1):$slash_required;
				$header_location 	= ($slash_required==2)?($header_location."/"):$header_location;
		   		$header_location   .= $location_url;
		 	} else {
				$ObjRewrite  		=  Registry::getInstance('Rewrite');
				$header_location	= $ObjView->_base_path;
				$location_url    	= implode($ObjRewrite->_queryDelimiter,$ObjRewrite->_queryString);
				$header_location    = $header_location.$ObjRewrite->_queryDelimiter.$location_url;
		 	}
			 header("Location:$header_location");
		     exit;
		}
		//show backward button link if current page greater than 1
		if($params_page>1){
		    if($queryStringKeyNumber==1) {
				$page_string 	= $params_key.$ObjRewrite->_queryDelimiter."1".$ObjRewrite->_queryDelimiter;
			} else {
				$page_string 	= "";
				$_queryStringArray[$queryStringKeyNumber] = 1;
			}
			$page_url    		= implode($ObjRewrite->_queryDelimiter,$_queryStringArray);
			$page_url 	 		= $ObjView->_base_path.$ObjRewrite->_queryDelimiter.$page_url.$page_string;
        	$paginate_result   .= '<li class="backward"><a href="'.$page_url.'">Backward</a></li>';
		} else {//else backward button as label if current page equals 1
			$paginate_result   .= '<li class="backward">Backward</li>';
		}
		//show previous button link if current page greater than 1
		if($params_page>1) {
			
			if($queryStringKeyNumber==1) {
				$page_string 	= $params_key.$ObjRewrite->_queryDelimiter.($params_page-1).$ObjRewrite->_queryDelimiter;
			} else {
				$page_string 	= "";
				$_queryStringArray[$queryStringKeyNumber] = $params_page-1;
			}
			
			$page_url     		= implode($ObjRewrite->_queryDelimiter,$_queryStringArray);
			$page_url 	  		= $ObjView->_base_path.$ObjRewrite->_queryDelimiter.$page_url.$page_string;
			$paginate_result   .= '<li class="previous"><a href="'.$page_url.'">Previous</a></li>';
		} else {
			$paginate_result   .= '<li class="previous">Previous</li>';
		}
		//end previous

		if($params_page>$params_display){
		    $page_from   		= $page_i_start-$params_display;
			$page_to     		= $page_from+$params_display-1;
			
			if($queryStringKeyNumber==1) {
				$page_string 	= $params_key.$ObjRewrite->_queryDelimiter.$page_from.$ObjRewrite->_queryDelimiter;
				$page_string 	= (empty($_queryStringArray[1]))?"index".$ObjRewrite->_queryDelimiter.$page_string:$page_string;
			} else {
				$page_string 	= "";
				$_queryStringArray[$queryStringKeyNumber] = $page_from;
			}
			
			$page_url    		= implode($ObjRewrite->_queryDelimiter,$_queryStringArray);
			$page_url 	 		= $ObjView->_base_path.$ObjRewrite->_queryDelimiter.$page_url.$page_string;
			$paginate_result   .= '<li><a href="'.$page_url.'">'.$page_from.'-'.$page_to.'</a></li>';
		}
		

		for($page_i=$page_i_start;$page_i<=$params_pages_display;$page_i++){
			
			if($queryStringKeyNumber==1) {
				$page_string 	= $params_key.$ObjRewrite->_queryDelimiter.$page_i.$ObjRewrite->_queryDelimiter;
				$page_string 	= (empty($_queryStringArray[1]))?"index".$ObjRewrite->_queryDelimiter.$page_string:$page_string;
			} else {
				$page_string 	= "";
				 $_queryStringArray[$queryStringKeyNumber] = $page_i;
			}
			 
			$page_url    		= implode($ObjRewrite->_queryDelimiter,$_queryStringArray);
			$page_url 	  		= $ObjView->_base_path.$ObjRewrite->_queryDelimiter.$page_url.$page_string;
			if($page_i==$params_page) {
        		$paginate_result .= '<li class="active" >'.$page_i.'</li>';
			} else {
			    $paginate_result .= '<li><a href="'.$page_url.'">'.$page_i.'</a></li>';
			}
		}
		
		
		if($params_pages>$params_pages_display){
			$page_to 	 	= ($params_pages<($params_pages_display+$params_display))?$params_pages:($params_pages_display+$params_display);
			$page_from   	= (($params_pages_display+1)==$page_to)?"":$params_pages_display+1;
			
			if($queryStringKeyNumber==1) {
				$page_string = $params_key.$ObjRewrite->_queryDelimiter.$page_from.$ObjRewrite->_queryDelimiter;
				$page_string = (empty($_queryStringArray[1]))?"index".$ObjRewrite->_queryDelimiter.$page_string:$page_string;
			} else {
				$page_string = "";
				$_queryStringArray[$queryStringKeyNumber] = $page_from;
			}
			
			$page_url    	= implode($ObjRewrite->_queryDelimiter,$_queryStringArray);
			$page_url 	 	= $ObjView->_base_path.$ObjRewrite->_queryDelimiter.$page_url.$page_string;
			if($params_pages-1>=$page_to) {
				$paginate_result   .= '<li><a href="'.$page_url.'">'.$page_from.'-'.$page_to.'</a></li>';
			} elseif(($params_pages-$params_pages_display)==1) {
			   
			   
			   /*$_queryStringArray[$queryStringKeyNumber] = $page_to;
			   $page_url    	= implode($ObjRewrite->_queryDelimiter,$_queryStringArray);
			   $page_url 	 	= $ObjView->_base_path.$ObjRewrite->_queryDelimiter.$page_url.$page_string;
			   $paginate_result   .= '<li><a href="'.$page_url.'">'.$page_to.'</a></li>';*/
			   
			   
			   if($queryStringKeyNumber==1) {
					$page_string = $params_key.$ObjRewrite->_queryDelimiter.($page_to).$ObjRewrite->_queryDelimiter;
					$page_string = (empty($_queryStringArray[1]))?"index".$ObjRewrite->_queryDelimiter.$page_string:$page_string;
				} else {
					$page_string = "";
					$_queryStringArray[$queryStringKeyNumber] = $page_to;
				}
				
				$page_url    		= implode($ObjRewrite->_queryDelimiter,$_queryStringArray);
				$page_url 	 		= $ObjView->_base_path.$ObjRewrite->_queryDelimiter.$page_url.$page_string;
				$paginate_result   .= '<li><a href="'.$page_url.'">'.$page_to.'</a></li>';
			   
			   
			} else if(($params_pages-$params_pages_display)<$params_pages_display) {
			   $paginate_result   .= '<li><a href="'.$page_url.'">'.$page_from.'-'.$page_to.'</a></li>';
			} else if(($params_pages-$params_pages_display)==$params_pages_display) {
			   $paginate_result   .= '<li><a href="'.$page_url.'">'.$page_from.'-'.$page_to.'</a></li>';
			}
		}
		
			//next visible
		
		 if($params_page<$params_pages) {
				
				if($queryStringKeyNumber==1) {
					$page_string = $params_key.$ObjRewrite->_queryDelimiter.($params_page+1).$ObjRewrite->_queryDelimiter;
					$page_string = (empty($_queryStringArray[1]))?"index".$ObjRewrite->_queryDelimiter.$page_string:$page_string;
				} else {
					$page_string = "";
					$_queryStringArray[$queryStringKeyNumber] = $params_page+1;
				}
				
				$page_url    		= implode($ObjRewrite->_queryDelimiter,$_queryStringArray);
				$page_url 	 		= $ObjView->_base_path.$ObjRewrite->_queryDelimiter.$page_url.$page_string;  
				$paginate_result   .= '<li class="next"><a href="'.$page_url.'">Next </a></li>';
		 } else {
			 	$paginate_result   .= '<li class="next">Next</li>';
		 }
		 
		 
		 if($params_pages!=$params_page) {
			//if($params_pages>$params_display && $params_pages!=$params_page) {
				
				if($queryStringKeyNumber==1) {
					$page_string = $params_key.$ObjRewrite->_queryDelimiter.$params_pages.$ObjRewrite->_queryDelimiter;
					$page_string = (empty($_queryStringArray[1]))?"index".$ObjRewrite->_queryDelimiter.$page_string:$page_string;
				} else {
					$page_string = "";
					$_queryStringArray[$queryStringKeyNumber] = $params_pages;
					$page_string = ($queryStringKeyNumber==1)?$params_key.$ObjRewrite->_queryDelimiter.$_queryStringArray[$queryStringKeyNumber].$ObjRewrite->_queryDelimiter:"";
				}
				
				$page_url    = implode($ObjRewrite->_queryDelimiter,$_queryStringArray);
				
				$page_url 	 = $ObjView->_base_path.$ObjRewrite->_queryDelimiter.$page_url.$page_string;  
				$paginate_result   .= '<li class="forward"><a href="'.$page_url.'">Forward</a></li>';
		 } else {
		 	$paginate_result   .= '<li class="forward">Forward</li>';
		 }
		 
         $paginate_result   .= '</ul>';
		 if($params_records_found_visible=="") {
			 $paginate_result   .= '<span><span>  '.$params_label_record.': '.$params_count.'<span> | </span></span>'.$this->_page_count.' '.$params_label_pages.'</span>';
		 }
		 echo $paginate_result;
  }

 	public function encodeQueryStringArray($queryStringArray)
	{
	 	foreach ($queryStringArray as $key => $val)
	 		$queryStringArray[$key]		= urlencode($val);
		return($queryStringArray);
	}
}