<?php
class Session {
 
  public $_system_session_key;
  public $_system_session_expire_minute;
  public $_system_session_encrypt;

  public function __construct () 
  {
     
		$this->_system_session_expire_minute	= SESSION_TIME;
		$this->_system_session_encrypt			= 0;
		$this->setSessionKey();
		$this->setSessionExpire();
  }
  
  public function setSessionKey()  
  {
                
	 	$this->_system_session_key	 = SESSION_PREFIX.$this->getSessionID();
               
  }
  public function resetSession(){
        
        session_regenerate_id();        
        $this->setSessionKey();
        
  }
  public function startSession($curr_key,$curr_value="")  
  {
	 	@session_start();
  }
  
  public function setSession($curr_key,$curr_value)  
  {
		$curr_key= ($this->_system_session_encrypt==1)?$this->encryptSession($curr_key):$curr_key;
		$curr_value = serialize(array($curr_value));
		$curr_value= ($this->_system_session_encrypt==1)?$this->encryptSession($curr_value):$curr_value;
	 	$_SESSION[$this->_system_session_key][$this->getSessionID(0).$curr_key] = $curr_value;
  }
  
  public function getSession($curr_key)  
  { 
		$curr_key= ($this->_system_session_encrypt==1)?$this->encryptSession($curr_key):$curr_key;
		$session_value	=  @$_SESSION[$this->_system_session_key][$this->getSessionID(0).$curr_key];
		$session_value	= ($this->_system_session_encrypt==1 && $session_value)?$this->decryptSession($session_value):$session_value;
		$session_value   = unserialize($session_value);
		$session_value   = $session_value[0];
		return $session_value;
  }
  
   public function getSessionID($encrypt=1)  
  {     
	 	 $session_id = session_id();
		 $session_id = ($this->_system_session_encrypt==1 && $encrypt==1)?$this->encryptSession($session_id):$session_id;
		 return $session_id;
  }
  
  public function unsetSession($curr_key)  
  {
	 	$curr_key= ($this->_system_session_encrypt==1)?$this->encryptSession($curr_key):$curr_key;
		unset($_SESSION[$this->_system_session_key][$this->getSessionID(0).$curr_key]);
  }
  
  public function setSessionExpire($session_expire_minute="")  
  {
		$session_expire_minute = ($session_expire_minute=="")?$this->_system_session_expire_minute:$session_expire_minute;
		if(!@ini_set("session.gc_maxlifetime", $session_expire_minute)){
			@session_cache_expire($system_session_expire_minute);
		}
  }
  
  public function distroySession()  
  {
                
	 	unset($_SESSION[$this->_system_session_key]);
		
  }
  
   public function encryptSession($input,$key=__ENCRYPTION_KEY)
  {
		$key = "SESSION".$key;
		$key = substr(md5($key),0,24);
		$td = @mcrypt_module_open ('tripledes', '', 'ecb', '');
		$iv = mcrypt_create_iv (mcrypt_enc_get_iv_size ($td), MCRYPT_RAND);
		mcrypt_generic_init ($td, $key, $iv);
		$encrypted_data = @mcrypt_generic ($td, $input);
		mcrypt_generic_deinit ($td);
		mcrypt_module_close ($td);
		$result= trim(chop($this->urlBase64Encode($encrypted_data)));
		return $result;
  }
  private function urlBase64Encode($str) {
		
	return strtr(base64_encode($str),
		array('+' => '.','=' => '-','/' => '~','[' => ':',']' => '@'));
  }
 
  private function urlBase64Decode($str) {
	
		return base64_decode(strtr($str,array('.' => '+','-' => '=','~' => '/',':' => ']','@' => ']')));
 }  
 
  public function decryptSession($input,$key=__ENCRYPTION_KEY)
  {
		$key = "SESSION".$key;
		$input = trim(chop($this->urlBase64Decode($input)));
		$td = mcrypt_module_open ('tripledes', '', 'ecb', '');
		$key = substr(md5($key),0,24);
		$iv = mcrypt_create_iv (mcrypt_enc_get_iv_size ($td), MCRYPT_RAND);
		mcrypt_generic_init ($td, $key, $iv);
		$decrypted_data = @mdecrypt_generic ($td, $input);
		mcrypt_generic_deinit ($td);
		mcrypt_module_close ($td);
		$result= trim(chop($decrypted_data));
		return $result;
  }
  
  
}

?>