<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/

//
//$Id: validate.engine.php,v 1.0 2011/06/14 20:52:11
//Validate - Validate Engine for Oorjit Deal System
//

class Validate 
{

  public  $ValidateResult;
  public  $formName;
  public  $formErrorCount;

  public function __construct () 
  {
		$this->ValidateResult	= array();
		
  }
  
  //REQUIRED FIELD VALIDATION
  public function required($fieldDetailsArray=array())
  {
  	$fieldDetailsArray_value= $fieldDetailsArray['value'];
	if((trim($fieldDetailsArray_value)=="")||(trim(stripslashes($fieldDetailsArray_value))=="")) {
		return false;
	}else{
		return true;
	}
  }	

  //REQUIRED FIELD VALIDATION
  public function compare($fieldDetailsArray=array())
  {
  	$fieldDetailsArray_value= $fieldDetailsArray['value'];
	$currValue= $fieldDetailsArray['currValue'];
	if($fieldDetailsArray_value == $currValue) {
		return true;
	}else{
		return false;
	}
  }	
    
  //EMAIL FIELD VALIDATION
  public function email($fieldDetailsArray=array())
  {
		$fieldDetailsArray_value= $fieldDetailsArray['value'];
		$regexp="/^[A-Z0-9._%+-]+@(?:[A-Z0-9-]+\.)+[A-Z]{2,4}$/i";
		
		if (($fieldDetailsArray_value=="") || preg_match($regexp, $fieldDetailsArray_value)) {
			return true;
		} else {
			return false;
		}
  }	
  
  //BULK EMAIL FIELD VALIDATION
  public function isMultipleEmail($fieldDetailsArray=array())
  {
		$fieldDetailsArray_value   		= $fieldDetailsArray['value'];
		$fieldDetailsArray_value   		= str_replace(chr(13),"",$fieldDetailsArray_value);
		$explode_fieldDetailsArray_value  = explode(",",$fieldDetailsArray_value);   
		$regexp						= "/^[A-Z0-9._%+-]+@(?:[A-Z0-9-]+\.)+[A-Z]{2,4}$/i";
		$invalid				    = 1;
		  
		for($email_i=0;$email_i<count($explode_fieldDetailsArray_value);$email_i++ ){
			if (!empty($explode_fieldDetailsArray_value[$email_i]) && !preg_match($regexp, trim($explode_fieldDetailsArray_value[$email_i]))) {
				return false;
			} 
		}
		return true;   
 }
  //BULK EMAIL FIELD VALIDATION
  public function isDuplicateEmail($fieldDetailsArray=array())
  {
		$fieldDetailsArray_value   		= $fieldDetailsArray['value'];
		$fieldDetailsArray_value   		= str_replace(chr(13),"",$fieldDetailsArray_value);
		$explode_fieldDetailsArray_value  = explode(",",$fieldDetailsArray_value);		  
		  $email_unique = array_count_values($explode_fieldDetailsArray_value);
		for($email_i=0;$email_i<count($explode_fieldDetailsArray_value);$email_i++ ){
			if ($email_unique[trim($explode_fieldDetailsArray_value[$email_i])] !=1) {
				return false;
			} 
		}
		return true;   
 }  
  
  //URL VALIDATION
  public function url($fieldDetailsArray=array())
  {
		$fieldDetailsArray_value= $fieldDetailsArray['value'];
		$regexp="/^(((ht|f)tp(s?))\://)?(www.|[a-zA-Z].)[a-zA-Z0-9\-\.]+\.(\:[0-9]+)*(/($|[a-zA-Z0-9\.\,\;\?\'\\\+&%\$#\=~_\-]+))*$/";
		
		if (!empty($fieldDetailsArray_value) && !preg_match($regexp, $fieldDetailsArray_value)) {
			return false;
		} else {
			return true;
		}
  }	
  
  //URL VALIDATION
  public function isUrl($fieldDetailsArray=array())
  {
		$fieldDetailsArray_value= $fieldDetailsArray['value'];
		$regexp= '/(?:(?:https?|ftp):\/\/|www\.)[a-z0-9-+&@#\/%?=~_|!:,.;]+(\.[\w\_]+)[a-z0-9+&@#\/%=~_|]/i';
		
		if (!empty($fieldDetailsArray_value) && !preg_match($regexp, $fieldDetailsArray_value)) {
			return false;
		} else {
			return true;
		}
  }
  
  //LOGIN NAME VALIDATION
  public function isLoginName($fieldDetailsArray=array())
  {
	  	$fieldDetailsArray_value= $fieldDetailsArray['value'];
		$regexp1  =  '/^[^0-9][A-z0-9_]+([.][A-z0-9_]+)*[@][A-z0-9_]+([.][A-z0-9_]+)*[.][A-z]{2,4}$/';
		$regexp2  =  '/^[a-zA-Z\d_.]{5,20}$/';
		if (preg_match($regexp2, $fieldDetailsArray_value) || preg_match($regexp1, $fieldDetailsArray_value)) {
		  return true;
		} else {
		  return false;
		}
  }	

   //PASSWORD VALIDATION
  public function isPassword($fieldDetailsArray=array())
  {
		$fieldDetailsArray_value= $fieldDetailsArray['value'];
		$regexp	='/^.*(?=.{8,})(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).*$/'; //For Password
		if (!preg_match("/[\s+]/",$fieldDetailsArray_value) && preg_match($regexp, $fieldDetailsArray_value)) {
			return true;
		} else {
			return false;
		}
  }	 
  
   //CUSTOM PASSWORD VALIDATION
  public function isSecurePassword($fieldDetailsArray=array(),$ObjController)
  {
	    $currentfield=$fieldDetailsArray['field'];	 
		$fieldDetailsArray_value		= html_entity_decode($fieldDetailsArray['value']);
		if(!empty($fieldDetailsArray[$currentfield]['options']))
		$fieldDetailsArray_options 	= explode(",",$fieldDetailsArray[$currentfield]['options']);	
		$password_criterias		= explode(",",PASSWORD_CRITERIA);
	     $minLength 				= (!empty($fieldDetailsArray_options[0]))?$fieldDetailsArray_options[0]:$password_criterias[0]; 
	     $maxLength 				= (!empty($fieldDetailsArray_options[1]))?$fieldDetailsArray_options[1]:$password_criterias[1]; 
	
		$minNumbers 			= (!empty($fieldDetailsArray_options[2]))?$fieldDetailsArray_options[2]:$password_criterias[2]; 
		$minLetters 			= (!empty($fieldDetailsArray_options[3]))?$fieldDetailsArray_options[3]:$password_criterias[3]; 
		$minLowerCase 			= (!empty($fieldDetailsArray_options[4]))?$fieldDetailsArray_options[4]:$password_criterias[4]; 
		$minUpperCase 			= (!empty($fieldDetailsArray_options[5]))?$fieldDetailsArray_options[5]:$password_criterias[5]; 
		$minSymbols 			= (!empty($fieldDetailsArray_options[6]))?$fieldDetailsArray_options[6]:$password_criterias[6]; 
		$maxSymbols 			= (!empty($fieldDetailsArray_options[7]))?$fieldDetailsArray_options[7]:$password_criterias[7]; 
		$allowedSymbols 		= (isset($fieldDetailsArray_options[8]))?$fieldDetailsArray_options[8]:array('#', '_', '!');
		
		if (empty($fieldDetailsArray_value) && $fieldDetailsArray_value!='0') {
			return true;
		} else if (strlen($fieldDetailsArray_value) < $minLength) {
            return $fieldDetailsArray_error = $ObjController->getLanguageValue('errPasswordmustbe').$minLength .$ObjController->getLanguageValue('errPasswordlength') . strlen($fieldDetailsArray_value) .$ObjController->getLanguageValue('characters');
            return false;
		} else if (strlen($fieldDetailsArray_value) > $maxLength) {
            return $fieldDetailsArray_error = $ObjController->getLanguageValue('errPasswordshouldnotexceed') . $maxLength . $ObjController->getLanguageValue('errPassworcharacterscurrent') . strlen($fieldDetailsArray_value) . $ObjController->getLanguageValue('characters');
            return false;
		} else if (strlen(preg_replace('/([^0-9]*)/', '', $fieldDetailsArray_value)) < $minNumbers) {
            return $fieldDetailsArray_error = $ObjController->getLanguageValue('errPassworNotenoughnumbers') . $minNumbers .$ObjController->getLanguageValue('required');
        } else if  (strlen(preg_replace('/([^a-zA-Z]*)/', '', $fieldDetailsArray_value)) < $minLetters) {
            return $fieldDetailsArray_error = $ObjController->getLanguageValue('errPassworNotenoughletters') . $minLetters .$ObjController->getLanguageValue('required');
        } else if  (strlen(preg_replace('/([^a-z]*)/', '', $fieldDetailsArray_value)) < $minLowerCase && $minLowerCase != 0) {
            return $fieldDetailsArray_error = $ObjController->getLanguageValue('errPassworNotenoughlowercase') . $minLowerCase . $ObjController->getLanguageValue('required');
        } else if (strlen(preg_replace('/([^A-Z]*)/', '', $fieldDetailsArray_value)) < $minUpperCase && $minUpperCase != 0) {
            return $fieldDetailsArray_error = $ObjController->getLanguageValue('errPassworNotenoughuppercase') . $minUpperCase . $ObjController->getLanguageValue('required');
        } else if (strlen(preg_replace('/([a-zA-Z0-9]*)/', '', $fieldDetailsArray_value)) < $minSymbols && $maxSymbols != 0) {
            return $fieldDetailsArray_error = $ObjController->getLanguageValue('errPassworNotenoughsymbols'). $minSymbols . $ObjController->getLanguageValue('required');
        } else if (strlen(preg_replace('/([a-zA-Z0-9]*)/', '', $fieldDetailsArray_value)) > $maxSymbols) {
            if ($maxSymbols == 0) {
                return $fieldDetailsArray_error = $ObjController->getLanguageValue('errPassworremove');
            } else {
                return $fieldDetailsArray_error = $ObjController->getLanguageValue('errPasswormanysymbols');
            }
        } else if  (preg_match("/\\s/", $fieldDetailsArray_value)) {
   				 return $fieldDetailsArray_error = $ObjController->getLanguageValue('errPassworNotSpace');
		} else if  ($maxSymbols != 0) {
					$symbols = preg_replace('/([a-zA-Z0-9]*)/', '', $fieldDetailsArray_value);
					for ($i = 0;$i < strlen($symbols);++$i) {
						if (!in_array($symbols[$i], $allowedSymbols)) {
							return $fieldDetailsArray_error = $ObjController->getLanguageValue('errPassworNonspecified'). $symbols[$i] . $ObjController->getLanguageValue('errPassworusedinpassword') . implode('', $allowedSymbols) . '.';
					return false;
                }
            }
        } else {
			return true;
		}
		return true;
  }	 
  
  
  //DATE FIELD VALIDATION
  public function isDate($fieldDetailsArray=array())
  {
		$fieldDetailsArray_value= $fieldDetailsArray['value'];
		if(trim($fieldDetailsArray_value)=="") {
			return true;
		}
		$_ret_value = strtotime($fieldDetailsArray_value);
		return $_ret_value != -1 && $_ret_value !== false;
  }	
  
  
  //PRICE FIELD VALIDATION
  public function isPrice($fieldDetailsArray=array())
  {
		$fieldDetailsArray_value  = $fieldDetailsArray['value'];
		$fieldDetailsArray_value  =  (substr($fieldDetailsArray_value,0,1)==".")?"0".$fieldDetailsArray_value:$fieldDetailsArray_value;
		if (empty($fieldDetailsArray_value) || preg_match('/^\d+(\.\d{1,5})?$/', $fieldDetailsArray_value)) {
		    return true;
		} else{
			return false;
		}
  }	
  
  //PHONE(US) FIELD VALIDATION
  public function isPhone($fieldDetailsArray=array())
  {
		$fieldDetailsArray_value= $fieldDetailsArray['value'];
		if (empty($fieldDetailsArray_value) ||  preg_match('/\(?\d{3}\)?[-\s.]?\d{3}[-\s.]\d{4}/x', $fieldDetailsArray_value)) {
		   return true;
		} else{
			return false;
		}
		return preg_match('![0-9\.\-\W]!', $fieldDetailsArray_value);
  }	
  
  
  //KEY VALIDATION
  public function isKey($fieldDetailsArray=array())
  {
		$fieldDetailsArray_value= $fieldDetailsArray['value'];
		if (empty($fieldDetailsArray_value) ||  preg_match('/^[a-zA-Z0-9_\-]+$/', $fieldDetailsArray_value)) {
		   return true;
		} else{
			return false;
		}
  }	
  
   //URL KEY VALIDATION
  public function isUrlKey($fieldDetailsArray=array())
  {
		$fieldDetailsArray_value= trim($fieldDetailsArray['value']);
                $sysKeysArr  = explode(",",SYSTEM_DIR_KEYS);
                if(in_array($fieldDetailsArray_value, $sysKeysArr)){
                    return false;
                }
		if (empty($fieldDetailsArray_value) ||  preg_match('/^[a-zA-Z0-9.\-\_]+$/', $fieldDetailsArray_value)) {
		   return true;
		} else{
			return false;
		}
  }	
  //CITY KEY VALIDATION
  public function isCityKey($fieldDetailsArray=array())
  {
		$fieldDetailsArray_value= $fieldDetailsArray['value'];
		if (empty($fieldDetailsArray_value) ||  preg_match('/^[a-zA-Z0-9\-]+$/', $fieldDetailsArray_value)) {
		   return true;
		} else{
			return false;
		}
  }	
  //FLOAT NUMBER FIELD VALIDATION
  public function isFloat($fieldDetailsArray=array())
  {
		$fieldDetailsArray_value= $fieldDetailsArray['value'];
		if (empty($fieldDetailsArray_value) ||  preg_match('/^[-+]?[0-9]*\.?[0-9]+$/', $fieldDetailsArray_value)) {
		   return true;
		} else{
			return false;
		}
  }
  //FLOAT NUMBER FIELD VALIDATION
  public function isPositiveFloat($fieldDetailsArray=array())
  {
		$fieldDetailsArray_value= $fieldDetailsArray['value'];
		if (empty($fieldDetailsArray_value) ||  preg_match('/^[0-9]*[.][0-9]+$/', $fieldDetailsArray_value)) {
		   return true;
		} else{
			return false;
		}

  }
  
  //NUMBER FIELD VALIDATION
  public function isNumber($fieldDetailsArray=array())
  {
		$fieldDetailsArray_value= $fieldDetailsArray['value'];
		if(empty($fieldDetailsArray_value) ||  is_numeric($fieldDetailsArray_value))	{
			return true;
		} else{
			return false;
		}
  }
  
  //INTEGER FIELD VALIDATION
  public function isInteger($fieldDetailsArray=array())
  {
		$fieldDetailsArray_value= $fieldDetailsArray['value'];
		if(empty($fieldDetailsArray_value) || is_int($fieldDetailsArray_value))	{
			return true;
		} else{
			return false;
		}
  }
  
  //WHOLE NUMBER FIELD VALIDATION
  public function isWholeNumber($fieldDetailsArray=array())
  {
	  $fieldDetailsArray_value= $fieldDetailsArray['value'];
	  if ($fieldDetailsArray_value == "" ||  preg_match('/^[0-9]+$/', $fieldDetailsArray_value)) {
		 return true;
	  } else{
		  return false;
	  }
  }
 
  //WHOLE NUMBER WITH ZERO FIELD VALIDATION
  public function isWholeNumberWithZero($fieldDetailsArray=array())
  {
	  $fieldDetailsArray_value= $fieldDetailsArray['value'];
	  if ($fieldDetailsArray_value == "" ||  preg_match('/^[0-9]+$/', $fieldDetailsArray_value)) {
		 return true;
	  } else{
		  return false;
	  }
  }
  
  //WHOLE NUMBER WITH OUT ZERO FIELD VALIDATION
  public function isWholeNumberWithOutZero($fieldDetailsArray=array())
  {
	  $fieldDetailsArray_value= $fieldDetailsArray['value'];
	  if($fieldDetailsArray_value == "" ||  preg_match('/^[1-9][0-9]*$/', $fieldDetailsArray_value)) {
		 return true;
	  } else{
		  return false;
	  }
 } 
   
  //PERCENTAGE VALIDATION
  public function isPercentage($fieldDetailsArray=array())
  {
		 $fieldDetailsArray_value	= $fieldDetailsArray['value'];
		if (empty($fieldDetailsArray_value) || (!empty($fieldDetailsArray_value) &&  preg_match('/^\d{0,2}(\.\d{0,2})?$|^100(\.0{1,2})?$/', $fieldDetailsArray_value)) || ($fieldDetailsArray_value=='0')) {		    	
			return true;
		} else{
			return false;
		}
  }
  
  //ALPHANUMERIC VALIDATION
  public function isAlphaNumeric($fieldDetailsArray=array())
  {
	$fieldDetailsArray_value= $fieldDetailsArray['value'];
		return empty($fieldDetailsArray_value) || preg_match("/^[a-zA-Z0-9]+$/", $fieldDetailsArray_value);
  }	
  
  //ALPHA VALIDATION
  public function isAlpha($fieldDetailsArray=array())
  {
	$fieldDetailsArray_value= $fieldDetailsArray['value'];
		return empty($fieldDetailsArray_value) || preg_match("/^[a-zA-Z]+$/", $fieldDetailsArray_value);
  }	

  //ALPHABET WITH 2 DIGITS
  public function isAlpha2($fieldDetailsArray=array())
  {
	$fieldDetailsArray_value= $fieldDetailsArray['value'];
		return empty($fieldDetailsArray_value) || preg_match("/^[a-zA-Z]{2}$/", $fieldDetailsArray_value);
  }	
  
  //ALPHABET WITH 3 DIGITS
  public function isAlpha3($fieldDetailsArray=array())
  {
	$fieldDetailsArray_value= $fieldDetailsArray['value'];
		return empty($fieldDetailsArray_value) || preg_match("/^[a-zA-Z]{3}$/", $fieldDetailsArray_value);
  }
  	 
  //ALPAHANUMEIC CAPS VALIDATION
  public function isAlphaCapsNumeric($fieldDetailsArray=array())
  {
	$fieldDetailsArray_value= $fieldDetailsArray['value'];
		return empty($fieldDetailsArray_value) || preg_match("/^[A-Z0-9]+$/", $fieldDetailsArray_value);
  }
  
  //LCID STRING VALIDATION
  public function isLCIDString($fieldDetailsArray=array())
  {
	$fieldDetailsArray_value= $fieldDetailsArray['value'];
		return empty($fieldDetailsArray_value) || preg_match("/^[a-zA-Z0-9-]+$/", $fieldDetailsArray_value);
  } 
  
  //CURRENCY FIELD VALIDATION
  public function isCurrency($fieldDetailsArray=array())
  {
	$fieldDetailsArray_value= $fieldDetailsArray['value'];
		return empty($fieldDetailsArray_value) || preg_match("/^\d+(\.\d{1,5})?$/", $fieldDetailsArray_value);
  }     
  //ISO NUMBER
  
  //CHECKING FOR HTML TAGS, DONT USE THIS
  public function isTag($fieldDetailsArray=array())
  {
	$fieldDetailsArray_value= $fieldDetailsArray['value'];
		return empty($fieldDetailsArray_value) || !(preg_match("/([\<])([^\>]{1,})*([\>])/i", $fieldDetailsArray_value));	  
  }
  
  //ISO CODE VALIDATION   
  public function isISO($fieldDetailsArray=array())
  {
	$fieldDetailsArray_value= $fieldDetailsArray['value'];
		return empty($fieldDetailsArray_value) || preg_match("/^[0-9]{0,4}$/", $fieldDetailsArray_value);
  }
  
  //VALIDATION WITH REGULAR EXPRESSION
  public function isPregMatch($fieldDetailsArray=array())
  {
	$currentfield					= $fieldDetailsArray['field'];	
	$fieldDetailsArray_value		= $fieldDetailsArray['value'];
	$fieldDetailsArray_expression 	= $fieldDetailsArray[$currentfield]['options'];
		return empty($fieldDetailsArray_value) || preg_match($fieldDetailsArray_expression, $fieldDetailsArray_value);
  }
  
  //ZIP CODE VALIDATION
  public function isZipCode($fieldDetailsArray=array())
  {
		$fieldDetailsArray_value= $fieldDetailsArray['value'];
		if (empty($fieldDetailsArray_value) || preg_match('/^[a-zA-Z\d]+(([\- ][a-zA-Z\d ])?[a-zA-Z\d]*)*[a-zA-Z\d]{1}$/', $fieldDetailsArray_value) || ctype_alpha($fieldDetailsArray_value)) {
			return true;
		} 
		else 
		{
		   return false;
		}
  }	
  
  //VALIDATION WITH NUMBER LIMIT
  public function isNumberLimit($fieldDetailsArray=array())
  {
	$currentfield				= $fieldDetailsArray['field'];
	$fieldDetailsArray_value	= $fieldDetailsArray['value'];
	$fieldDetailsArray_options 	= explode(",",$fieldDetailsArray[$currentfield]['options']);
	$from_number 				= $fieldDetailsArray_options[0]; // SET FROM NUMBER
	$to_number 					= $fieldDetailsArray_options[1]; // SET TO NUMBER
	if(!(is_numeric($from_number)) || !(is_numeric($to_number)) ) 
		return false;	
	if(($from_number && $to_number && $fieldDetailsArray_value>=$from_number && $fieldDetailsArray_value<=$to_number) || 
	   (!$from_number && $to_number && $fieldDetailsArray_value<=$to_number) ||
	   (!$to_number && $from_number && $fieldDetailsArray_value>=$from_number) || empty($fieldDetailsArray_value) )  
	{
		return true;
	} 
	else 
	{
		return false;
	}
  }	

  //IMAGE FIELD VALIDATION
  public function isImage($fieldDetailsArray=array())
  {  
	return true;
  }
  
  //VALIDATION WITH DATABASE
  public function database($fieldDetailsArray=array())
  {  
	$currentfield=$fieldDetailsArray['field'];
	$fieldDetailsArray_value		= trim(addslashes($fieldDetailsArray['value']));
	$fieldDetailsArray_options 		= explode(",",$fieldDetailsArray[$currentfield]['options']);			
	$db_table_name 					= $fieldDetailsArray_options[0]; // SET TABLE NAME (DATABASE)
	$db_field_name 					= $fieldDetailsArray_options[1]; // SET FIELD NAME (DATABASE)
	$db_custom_query 				= $fieldDetailsArray_options[2]; // SET CUSTOM QUERY)
	$ObjDatabase 					= Registry::getInstance('Database');
	$result_exist= $ObjDatabase->checkExist($db_table_name,$db_field_name,$fieldDetailsArray_value,$db_custom_query);
	if($result_exist=="YES")  
	{
		return false;
	} 
	else 
	{
		return true;
	}
  }	
  
  //VALIDATION WITH DATABASE
  public function isDatabase($fieldDetailsArray=array())
  {  
	$currentfield=$fieldDetailsArray['field'];
	$fieldDetailsArray_value		= trim(addslashes($fieldDetailsArray['value']));
	$fieldDetailsArray_options 		= explode(",",$fieldDetailsArray[$currentfield]['options']);
	$db_table_name 					= $fieldDetailsArray_options[0]; // SET TABLE NAME (DATABASE)
	$db_field_name 					= $fieldDetailsArray_options[1]; // SET FIELD NAME (DATABASE)
	$db_custom_query 				= $fieldDetailsArray_options[2]; // SET CUSTOM QUERY)
	$ObjDatabase 					= Registry::getInstance('Database');
	$result_exist					= $ObjDatabase->checkExist($db_table_name,$db_field_name,$fieldDetailsArray_value,$db_custom_query);
	if($result_exist=="YES")  
	{
		return false;
	} 
	else 
	{
		return true;
	}
  }
  
  //FILE EXTENSION VALIDATION
  function isFileType($fieldDetailsArray=array())
  {
	  $currentfield=$fieldDetailsArray['field'];
	  $fieldDetailsArray_value			 	= $fieldDetailsArray['value'];
	  $fieldDetailsArray_options 		 	= explode(",",$fieldDetailsArray[$currentfield]['options']);
	  $fieldDetailsArray_value_extention 	= strtolower(substr($fieldDetailsArray_value, strrpos($fieldDetailsArray_value, '.') + 1));
	  if(!in_array($fieldDetailsArray_value_extention,$fieldDetailsArray_options) && $fieldDetailsArray_value!='') 
	  {
		  return false;
	  } 
	  else 
	  {
		  return true;
	  }
  }

/* ==================== New  Binary Operators ======================== */

  public function eq($fieldDetailsArray=array())
  {
    $fieldDetailsArray_value1 = $fieldDetailsArray['value'];
	$fieldDetailsArray_value2 = $fieldDetailsArray['value2'];
	if($fieldDetailsArray_value1 == "" && $fieldDetailsArray_value2 == "")
		return true;
    if($fieldDetailsArray_value1 == $fieldDetailsArray_value2)
      return true;
    else
      return false;
  }
  public function neq($fieldDetailsArray=array())
  {
    $fieldDetailsArray_value1 = $fieldDetailsArray['value'];
	$fieldDetailsArray_value2 = $fieldDetailsArray['value2'];
	if($fieldDetailsArray_value1 == "" && $fieldDetailsArray_value2 == "")
		return true;	
    if($fieldDetailsArray_value1 != $fieldDetailsArray_value2)
      return true;
    else
      return false;
  }  
  public function gt($fieldDetailsArray=array())
  {
    $fieldDetailsArray_value1 = $fieldDetailsArray['value'];
	$fieldDetailsArray_value2 = $fieldDetailsArray['value2'];
	if($fieldDetailsArray_value1 == "" && $fieldDetailsArray_value2 == "")
		return true;	
    if($fieldDetailsArray_value1 > $fieldDetailsArray_value2)
      return true;
    else
      return false;
  }
  public function gteq($fieldDetailsArray=array())
  {
    $fieldDetailsArray_value1 = $fieldDetailsArray['value'];
	$fieldDetailsArray_value2 = $fieldDetailsArray['value2'];
	if($fieldDetailsArray_value1 == "" && $fieldDetailsArray_value2 == "")
		return true;	
    if($fieldDetailsArray_value1 >= $fieldDetailsArray_value2)
      return true;
    else
      return false;
  } 
  public function lt($fieldDetailsArray=array())
  {
    $fieldDetailsArray_value1 = $fieldDetailsArray['value'];
	$fieldDetailsArray_value2 = $fieldDetailsArray['value2'];
	if($fieldDetailsArray_value1 == "" && $fieldDetailsArray_value2 == "")
		return true;	
    if($fieldDetailsArray_value1 < $fieldDetailsArray_value2)
      return true;
    else
      return false;
  }
  public function lteq($fieldDetailsArray=array())
  {
    $fieldDetailsArray_value1 = $fieldDetailsArray['value'];
	$fieldDetailsArray_value2 = $fieldDetailsArray['value2'];
	if($fieldDetailsArray_value1 == "" && $fieldDetailsArray_value2 == "")
		return true;	
    if($fieldDetailsArray_value1 < $fieldDetailsArray_value2)
      return true;
    else
      return false;
  }
  
/* ==================== New  Binary Operators with result checking ======================== */
  public function plus($fieldDetailsArray=array())
  {
    $fieldDetailsArray_value1 			= $fieldDetailsArray['value'];
	$fieldDetailsArray_value2 			= $fieldDetailsArray['value2'];
	if($fieldDetailsArray_value1 == "" && $fieldDetailsArray_value2 == "")
		return true;	
	$fieldDetailsArray_expectedResult 	= $fieldDetailsArray['expectedResult'];
	$result			  					= $fieldDetailsArray_value1 + $fieldDetailsArray_value2;
    if($fieldDetailsArray_expectedResult == $result)
      return true;
    else
      return false;
  }
  public function minus($fieldDetailsArray=array())
  {
    $fieldDetailsArray_value1 			= $fieldDetailsArray['value'];
	$fieldDetailsArray_value2 			= $fieldDetailsArray['value2'];
	if($fieldDetailsArray_value1 == "" && $fieldDetailsArray_value2 == "")
		return true;	
	$fieldDetailsArray_expectedResult 	= $fieldDetailsArray['expectedResult'];
	$result			  					= $fieldDetailsArray_value1 - $fieldDetailsArray_value2;
    if($fieldDetailsArray_expectedResult == $result)
      return true;
    else
      return false;
  } 
  public function multiply($fieldDetailsArray=array())
  {
    $fieldDetailsArray_value1 			= $fieldDetailsArray['value'];
	$fieldDetailsArray_value2 			= $fieldDetailsArray['value2'];
	if($fieldDetailsArray_value1 == "" && $fieldDetailsArray_value2 == "")
		return true;	
	$fieldDetailsArray_expectedResult 	= $fieldDetailsArray['expectedResult'];
	$result			  					= $fieldDetailsArray_value1 * $fieldDetailsArray_value2;
    if($fieldDetailsArray_expectedResult == $result)
      return true;
    else
      return false;
  } 
  public function divide($fieldDetailsArray=array())
  {
    $fieldDetailsArray_value1 			= $fieldDetailsArray['value'];
	$fieldDetailsArray_value2 			= $fieldDetailsArray['value2'];
	if($fieldDetailsArray_value1 == "" && $fieldDetailsArray_value2 == "")
		return true;	
	$fieldDetailsArray_expectedResult 	= $fieldDetailsArray['expectedResult'];
	$result			  					= $fieldDetailsArray_value1 / $fieldDetailsArray_value2;
    if($fieldDetailsArray_expectedResult == $result)
      return true;
    else
      return false;
  } 
  public function mod($fieldDetailsArray=array())
  {
    $fieldDetailsArray_value1 			= $fieldDetailsArray['value'];
	$fieldDetailsArray_value2 			= $fieldDetailsArray['value2'];
	if($fieldDetailsArray_value1 == "" && $fieldDetailsArray_value2 == "")
		return true;	
	$fieldDetailsArray_expectedResult 	= $fieldDetailsArray['expectedResult'];
	$result			  					= $fieldDetailsArray_value1 % $fieldDetailsArray_value2;
    if($fieldDetailsArray_expectedResult == $result)
      return true;
    else
      return false;
  }   
  //VALIDATION FILE SIZE
  public function checkFileSize($fieldDetailsArray=array())
  {
	$currentfield				= $fieldDetailsArray['field'];
	$fieldDetailsArray_value	= $fieldDetailsArray['value'];
	$fieldDetailsArray_option 	=array();
	if($fieldDetailsArray[$currentfield]['options']!='')
	$fieldDetailsArray_option 	= explode(",",$fieldDetailsArray[$currentfield]['options']);
	$file_size					= $fieldDetailsArray_option[0]; //SET FILE SIZE	
	$uploaded_file_size			= ($_FILES[$currentfield]['size']/1024); //KB Conversion
	if($uploaded_file_size > $file_size)
		return false;
	else
		return true;
  }
  //File Extension Validation for uploaded files
  public function isValidFileExtension($fieldDetailsArray=array())
  {		
	$currentfield				= $fieldDetailsArray['field'];
	$fieldDetailsArray_value	= $fieldDetailsArray['value'];
	$fieldDetailsArray_option 	=array();
	if($fieldDetailsArray[$currentfield]['options']!='')
	$fieldDetailsArray_option 	= explode(",",$fieldDetailsArray[$currentfield]['options']);
	if (!empty($fieldDetailsArray_value)) 
	{
	   $fieldDetailsArray_value_extention 	= strtolower(substr($fieldDetailsArray_value, strrpos($fieldDetailsArray_value, '.') + 1));
		if(in_array($fieldDetailsArray_value_extention,$fieldDetailsArray_option) && !empty($fieldDetailsArray_option))
		{
			return true;
		}	
		else if(empty($fieldDetailsArray_option))
		{
			$forbidden_file_extensions	= explode(",",FORBIDDEN_FILE_EXTENSIONS);			
			if(in_array($fieldDetailsArray_value_extention,$forbidden_file_extensions) && !empty($forbidden_file_extensions))
			{
				return false;
			}	
		}
		else
		{

			return false;
		}
	} 
	return true;
  }
   //ALPHA VALIDATION
  public function isValidSuffix($fieldDetailsArray=array())
  {
      
	$fieldDetailsArray_value= $fieldDetailsArray['value'];
		if (empty($fieldDetailsArray_value) || preg_match('/^\.[a-z]+$/', $fieldDetailsArray_value)) {
			return true;
		} 
		else 
		{
		   return false;
		}
  }    
  //URL KEY VALIDATION
  public function isRequestPath($fieldDetailsArray=array())
  {
		$fieldDetailsArray_value= rtrim($fieldDetailsArray['value'],'/');
                $sysKeysArr  = explode(",",SYSTEM_DIR_KEYS);
                foreach($sysKeysArr as $value){
                if(substr_count($fieldDetailsArray_value,$value.'/')){               
                    return false;
                }
                }
		if (empty($fieldDetailsArray_value) ||  preg_match('/^[a-zA-Z0-9.\-\_\/]+$/', $fieldDetailsArray_value)) {
		   return true;
		} else{
			return false;
		}
  }	
}